/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Marshaller;
import com.devexperts.io.MarshallingException;
import com.devexperts.io.SerialClassContext;
import com.devexperts.util.LogUtil;
import java.io.IOException;
import java.util.Arrays;

public final class Marshalled<T> {
    public static final Marshalled<Object> NULL = Marshaller.SERIALIZATION.getNullObjectMarshalled();
    private static final byte[] UNDEFINED = new byte[0];
    private final SerialClassContext serialContext;
    private volatile T object;
    private volatile byte[] bytes;
    private volatile MarshallingException exception;
    private final Marshaller<T> marshaller;

    public static Object unwrap(Object object) {
        return object instanceof Marshalled ? ((Marshalled)object).getObject() : object;
    }

    public static <T> Marshalled<T> forObject(T object) {
        return object == null ? NULL : new Marshalled<Object>(object, UNDEFINED, Marshaller.SERIALIZATION, null);
    }

    public static <T> Marshalled<T> forObject(T object, Marshaller<T> marshaller) {
        return object == null ? marshaller.getNullObjectMarshalled() : new Marshalled<T>(object, UNDEFINED, marshaller, null);
    }

    public static Marshalled<Object> forBytes(byte[] bytes) {
        return bytes == null ? NULL : new Marshalled<Object>(UNDEFINED, bytes, Marshaller.SERIALIZATION, SerialClassContext.getDefaultSerialContext(null));
    }

    public static <T> Marshalled<T> forBytes(byte[] bytes, Marshaller<T> marshaller) {
        return bytes == null ? marshaller.getNullBytesMarshalled() : new Marshalled<byte[]>(UNDEFINED, bytes, marshaller, SerialClassContext.getDefaultSerialContext(null));
    }

    public static <T> Marshalled<T> forBytes(byte[] bytes, Marshaller<T> marshaller, SerialClassContext serialContext) {
        return bytes == null ? marshaller.getNullBytesMarshalled() : new Marshalled<byte[]>(UNDEFINED, bytes, marshaller, serialContext);
    }

    Marshalled(T object, byte[] bytes, Marshaller<T> marshaller, SerialClassContext serialContext) {
        this.object = object;
        this.bytes = bytes;
        this.marshaller = marshaller;
        this.serialContext = serialContext;
    }

    public T getObject() {
        T object = this.object;
        if (object != UNDEFINED) {
            return object;
        }
        MarshallingException exception = this.exception;
        if (exception != null) {
            throw exception;
        }
        return this.getObjectSync(this.serialContext);
    }

    public T getObject(ClassLoader cl) {
        T object = this.object;
        if (object != UNDEFINED) {
            return object;
        }
        MarshallingException exception = this.exception;
        if (exception != null) {
            throw exception;
        }
        return this.getObjectSync(SerialClassContext.getDefaultSerialContext(cl));
    }

    private synchronized T getObjectSync(SerialClassContext serialContext) {
        T object = this.object;
        if (object != UNDEFINED) {
            return object;
        }
        MarshallingException exception = this.exception;
        if (exception != null) {
            throw exception;
        }
        try {
            ByteArrayInput in = new ByteArrayInput(this.bytes);
            this.object = this.marshaller.readObjectFrom(in, this.bytes.length, serialContext);
            return this.object;
        }
        catch (IOException e) {
            this.exception = new MarshallingException(e);
            throw this.exception;
        }
    }

    public void ensureBytes() {
        this.getBytes();
    }

    public byte[] getBytes() {
        byte[] bytes = this.bytes;
        if (bytes != UNDEFINED) {
            return bytes;
        }
        MarshallingException exception = this.exception;
        if (exception != null) {
            throw exception;
        }
        return this.getBytesSync();
    }

    private synchronized byte[] getBytesSync() {
        byte[] bytes = this.bytes;
        if (bytes != UNDEFINED) {
            return bytes;
        }
        MarshallingException exception = this.exception;
        if (exception != null) {
            throw exception;
        }
        try {
            ByteArrayOutput out = new ByteArrayOutput();
            this.marshaller.writeObjectTo(out, this.object);
            bytes = out.getBuffer();
            if (bytes.length != out.getPosition()) {
                bytes = out.toByteArray();
            }
            this.bytes = bytes;
            return bytes;
        }
        catch (IOException e) {
            this.exception = new MarshallingException(e);
            throw this.exception;
        }
    }

    public Marshaller<T> getMarshaller() {
        return this.marshaller;
    }

    public boolean equals(Object obj) {
        return obj instanceof Marshalled && this.getMarshaller().equals(((Marshalled)obj).getMarshaller()) && Arrays.equals(this.getBytes(), ((Marshalled)obj).getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes()) + this.getMarshaller().hashCode() * 31;
    }

    public String toString() {
        try {
            T object = this.getObject();
            return LogUtil.deepToString(object);
        }
        catch (Throwable e) {
            return "Could not unmarshall: " + e;
        }
    }
}

