/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.CompactSerializer;
import com.devexperts.io.Compression;
import com.devexperts.io.ObjectDeserializer;
import com.devexperts.io.ObjectSerializer;
import com.devexperts.io.SerialClassContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.zip.DataFormatException;

public class IOUtil {
    private static boolean compressionEnabled = false;

    private IOUtil() {
    }

    public static void checkRange(byte[] b, int off, int len) {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static int getCompactLength(long n) {
        if (n >= 0L) {
            if (n < 64L) {
                return 1;
            }
            if (n < 8192L) {
                return 2;
            }
            if (n < 0x100000L) {
                return 3;
            }
            if (n < 0x8000000L) {
                return 4;
            }
            if (n < 0x400000000L) {
                return 5;
            }
            if (n < 0x20000000000L) {
                return 6;
            }
            if (n < 0x1000000000000L) {
                return 7;
            }
            if (n < 0x80000000000000L) {
                return 8;
            }
            return 9;
        }
        if (n >= -64L) {
            return 1;
        }
        if (n >= -8192L) {
            return 2;
        }
        if (n >= -1048576L) {
            return 3;
        }
        if (n >= -134217728L) {
            return 4;
        }
        if (n >= -17179869184L) {
            return 5;
        }
        if (n >= -2199023255552L) {
            return 6;
        }
        if (n >= -281474976710656L) {
            return 7;
        }
        if (n >= -36028797018963968L) {
            return 8;
        }
        return 9;
    }

    public static void writeCompactInt(DataOutput out, int v) throws IOException {
        if (v >= 0) {
            if (v < 64) {
                out.writeByte(v);
            } else if (v < 8192) {
                out.writeShort(0x8000 | v);
            } else if (v < 0x100000) {
                out.writeByte(0xC0 | v >> 16);
                out.writeShort(v);
            } else if (v < 0x8000000) {
                out.writeInt(0xE0000000 | v);
            } else {
                out.writeByte(240);
                out.writeInt(v);
            }
        } else if (v >= -64) {
            out.writeByte(0x7F & v);
        } else if (v >= -8192) {
            out.writeShort(0xBFFF & v);
        } else if (v >= -1048576) {
            out.writeByte(0xDF & v >> 16);
            out.writeShort(v);
        } else if (v >= -134217728) {
            out.writeInt(0xEFFFFFFF & v);
        } else {
            out.writeByte(247);
            out.writeInt(v);
        }
    }

    public static void writeCompactLong(DataOutput out, long v) throws IOException {
        if (v == (long)((int)v)) {
            IOUtil.writeCompactInt(out, (int)v);
            return;
        }
        int hi = (int)(v >>> 32);
        if (hi >= 0) {
            if (hi < 4) {
                out.writeByte(0xF0 | hi);
            } else if (hi < 512) {
                out.writeShort(0xF800 | hi);
            } else if (hi < 65536) {
                out.writeByte(252);
                out.writeShort(hi);
            } else if (hi < 0x800000) {
                out.writeInt(0xFE000000 | hi);
            } else {
                out.writeByte(255);
                out.writeInt(hi);
            }
        } else if (hi >= -4) {
            out.writeByte(0xF7 & hi);
        } else if (hi >= -512) {
            out.writeShort(0xFBFF & hi);
        } else if (hi >= -65536) {
            out.writeByte(253);
            out.writeShort(hi);
        } else if (hi >= -8388608) {
            out.writeInt(0xFEFFFFFF & hi);
        } else {
            out.writeByte(255);
            out.writeInt(hi);
        }
        out.writeInt((int)v);
    }

    public static int readCompactInt(DataInput in) throws IOException {
        int n = in.readUnsignedByte();
        if (n < 128) {
            return n << 25 >> 25;
        }
        if (n < 192) {
            return (n << 8) + in.readUnsignedByte() << 18 >> 18;
        }
        if (n < 224) {
            return (n << 16) + in.readUnsignedShort() << 11 >> 11;
        }
        if (n < 240) {
            return (n << 24) + (in.readUnsignedByte() << 16) + in.readUnsignedShort() << 4 >> 4;
        }
        while (((n <<= 1) & 0x10) != 0) {
            in.readUnsignedByte();
        }
        return in.readInt();
    }

    public static long readCompactLong(DataInput in) throws IOException {
        int n = in.readUnsignedByte();
        if (n < 128) {
            return n << 25 >> 25;
        }
        if (n < 192) {
            return (n << 8) + in.readUnsignedByte() << 18 >> 18;
        }
        if (n < 224) {
            return (n << 16) + in.readUnsignedShort() << 11 >> 11;
        }
        if (n < 240) {
            return (n << 24) + (in.readUnsignedByte() << 16) + in.readUnsignedShort() << 4 >> 4;
        }
        n = n < 248 ? n << 29 >> 29 : (n < 252 ? (n << 8) + in.readUnsignedByte() << 22 >> 22 : (n < 254 ? (n << 16) + in.readUnsignedShort() << 15 >> 15 : (n < 255 ? (in.readByte() << 16) + in.readUnsignedShort() : in.readInt())));
        return ((long)n << 32) + ((long)in.readInt() & 0xFFFFFFFFL);
    }

    public static void writeByteArray(DataOutput out, byte[] bytes) throws IOException {
        if (bytes == null) {
            IOUtil.writeCompactInt(out, -1);
            return;
        }
        IOUtil.writeCompactInt(out, bytes.length);
        out.write(bytes);
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        long length = IOUtil.readCompactLong(in);
        IOUtil.checkEncapsulatedLength(in, length);
        if (length == -1L) {
            return null;
        }
        if (length == 0L) {
            return BufferedInput.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[(int)length];
        in.readFully(bytes);
        return bytes;
    }

    public static void writeCharArray(DataOutput out, char[] chars) throws IOException {
        int length = chars == null ? -1 : chars.length;
        IOUtil.writeCompactInt(out, length);
        for (int i = 0; i < length; ++i) {
            IOUtil.writeUTFChar(out, chars[i]);
        }
    }

    public static void writeCharArray(DataOutput out, String str) throws IOException {
        int length = str == null ? -1 : str.length();
        IOUtil.writeCompactInt(out, length);
        for (int i = 0; i < length; ++i) {
            IOUtil.writeUTFChar(out, str.charAt(i));
        }
    }

    public static char[] readCharArray(DataInput in) throws IOException {
        long length = IOUtil.readCompactLong(in);
        IOUtil.checkEncapsulatedLength(in, length);
        if (length == -1L) {
            return null;
        }
        char[] chars = new char[(int)length];
        int i = 0;
        while ((long)i < length) {
            int codePoint = IOUtil.readUTFChar(in);
            if (codePoint > 65535) {
                throw new UTFDataFormatException("Code point is beyond BMP.");
            }
            chars[i] = (char)codePoint;
            ++i;
        }
        return chars;
    }

    public static String readCharArrayString(DataInput in) throws IOException {
        char[] chars = IOUtil.readCharArray(in);
        return chars == null ? null : new String(chars);
    }

    public static void writeUTFChar(DataOutput out, int codePoint) throws IOException {
        if (codePoint < 0) {
            throw new UTFDataFormatException();
        }
        if (codePoint <= 127) {
            out.writeByte(codePoint);
        } else if (codePoint <= 2047) {
            CompactSerializer.writeUTF2Unchecked(out, codePoint);
        } else if (codePoint <= 65535) {
            CompactSerializer.writeUTF3Unchecked(out, codePoint);
        } else if (codePoint <= 0x10FFFF) {
            CompactSerializer.writeUTF4Unchecked(out, codePoint);
        } else {
            throw new UTFDataFormatException();
        }
    }

    public static int readUTFChar(DataInput in) throws IOException {
        byte c = in.readByte();
        if (c >= 0) {
            return (char)c;
        }
        if ((c & 0xE0) == 192) {
            return CompactSerializer.readUTF2(in, c);
        }
        if ((c & 0xF0) == 224) {
            return CompactSerializer.readUTF3(in, c);
        }
        if ((c & 0xF8) == 240) {
            return CompactSerializer.readUTF4(in, c);
        }
        throw new UTFDataFormatException();
    }

    public static void writeUTFString(DataOutput out, String str) throws IOException {
        char c;
        if (str == null) {
            IOUtil.writeCompactInt(out, -1);
            return;
        }
        int strLen = str.length();
        long utfLen = 0L;
        int i = 0;
        while (i < strLen) {
            if ((c = str.charAt(i++)) <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c <= '\u07ff') {
                utfLen += 2L;
                continue;
            }
            if (Character.isHighSurrogate(c) && i < strLen && Character.isLowSurrogate(str.charAt(i))) {
                ++i;
                utfLen += 4L;
                continue;
            }
            utfLen += 3L;
        }
        IOUtil.writeCompactLong(out, utfLen);
        i = 0;
        while (i < strLen) {
            if ((c = str.charAt(i++)) <= '\u007f') {
                out.writeByte(c);
                continue;
            }
            if (c <= '\u07ff') {
                CompactSerializer.writeUTF2Unchecked(out, c);
                continue;
            }
            if (Character.isHighSurrogate(c) && i < strLen && Character.isLowSurrogate(str.charAt(i))) {
                CompactSerializer.writeUTF4Unchecked(out, Character.toCodePoint(c, str.charAt(i++)));
                continue;
            }
            CompactSerializer.writeUTF3Unchecked(out, c);
        }
    }

    public static String readUTFString(DataInput in) throws IOException {
        if (in instanceof BufferedInput) {
            return ((BufferedInput)in).readUTFString();
        }
        long utfLen = IOUtil.readCompactLong(in);
        if (utfLen < -1L || utfLen > 0x1FFFFFFFCL) {
            throw new IOException("Illegal length: " + utfLen);
        }
        if (utfLen == -1L) {
            return null;
        }
        if (utfLen == 0L) {
            return "";
        }
        char[] chars = new char[(int)Math.min(utfLen, Integer.MAX_VALUE)];
        return String.valueOf(chars, 0, CompactSerializer.readUTFBody(in, utfLen, chars, 0));
    }

    public static int readUTFBody(DataInput in, long utfLength, char[] chars, int offset) throws IOException {
        return CompactSerializer.readUTFBody(in, utfLength, chars, offset);
    }

    public static byte[] objectToBytes(Object object) throws IOException {
        return ObjectSerializer.toBytes(object);
    }

    public static Object bytesToObject(byte[] bytes) throws IOException {
        return ObjectDeserializer.toObject(bytes, SerialClassContext.getDefaultSerialContext(null));
    }

    public static Object bytesToObject(byte[] bytes, ClassLoader cl) throws IOException {
        return ObjectDeserializer.toObject(bytes, SerialClassContext.getDefaultSerialContext(cl));
    }

    public static Object bytesToObject(byte[] bytes, SerialClassContext serialContext) throws IOException {
        if (serialContext == null) {
            throw new NullPointerException();
        }
        return ObjectDeserializer.toObject(bytes, serialContext);
    }

    public static void writeObject(DataOutput out, Object object) throws IOException {
        ObjectSerializer.writeCompact(out, object);
    }

    public static Object readObject(DataInput in) throws IOException {
        return ObjectDeserializer.readCompact(in, SerialClassContext.getDefaultSerialContext(null));
    }

    public static Object readObject(DataInput in, ClassLoader cl) throws IOException {
        return ObjectDeserializer.readCompact(in, SerialClassContext.getDefaultSerialContext(cl));
    }

    public static Object readObject(DataInput in, SerialClassContext serialContext) throws IOException {
        if (serialContext == null) {
            throw new NullPointerException();
        }
        return ObjectDeserializer.readCompact(in, serialContext);
    }

    private static void checkEncapsulatedLength(DataInput in, long length) throws IOException {
        if (in instanceof BufferedInput) {
            ((BufferedInput)in).checkEncapsulatedLength(length, -1L, Integer.MAX_VALUE);
            return;
        }
        if (length < -1L || length > Integer.MAX_VALUE) {
            throw new IOException("Illegal length: " + length);
        }
    }

    public static byte[] deflate(byte[] bytes, int level) {
        ByteArrayOutput out = new ByteArrayOutput(Math.max(bytes.length / 4, 8192));
        Compression.deflate(bytes, 0, bytes.length, level, out);
        return out.toByteArray();
    }

    public static byte[] inflate(byte[] bytes) throws DataFormatException {
        ByteArrayOutput out = new ByteArrayOutput(Math.max(bytes.length * 2, 8192));
        Compression.inflate(bytes, 0, bytes.length, out);
        return out.toByteArray();
    }

    public static boolean isCompressionEnabled() {
        return compressionEnabled;
    }

    public static void setCompressionEnabled(boolean compressionEnabled) {
        IOUtil.compressionEnabled = compressionEnabled;
    }

    public static byte[] compress(byte[] bytes) {
        if (bytes == null || !Compression.shallCompress(bytes, 0, bytes.length)) {
            return bytes;
        }
        ByteArrayOutput out = new ByteArrayOutput(Math.max(bytes.length / 4, 8192));
        Compression.deflate(bytes, 0, bytes.length, 1, out);
        return out.getPosition() < bytes.length - (bytes.length >> 4) ? out.toByteArray() : bytes;
    }

    public static byte[] decompress(byte[] bytes) {
        try {
            while (bytes != null && Compression.isCompressed(bytes, 0, bytes.length)) {
                bytes = IOUtil.inflate(bytes);
            }
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return bytes;
    }

    static {
        try {
            compressionEnabled = "true".equalsIgnoreCase(System.getProperty("com.devexperts.io.compressionEnabled", String.valueOf(compressionEnabled)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

