/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.util.LockFreePool;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class Compression {
    private static final LockFreePool<Deflater> DEFLATERS_POOL = new LockFreePool("com.devexperts.io.Deflater", 16);
    private static final LockFreePool<Inflater> INFLATERS_POOL = new LockFreePool("com.devexperts.io.Inflater", 16);
    private static final byte[] emptyInput = new byte[0];

    Compression() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deflate(byte[] bytes, int offset, int length, int level, ByteArrayOutput out) {
        Deflater deflater = DEFLATERS_POOL.poll();
        if (deflater == null) {
            deflater = new Deflater();
        }
        try {
            deflater.setLevel(level);
            deflater.setInput(bytes, offset, length);
            deflater.finish();
            while (!deflater.finished()) {
                int pos = out.getPosition();
                out.ensureCapacity(pos + 8192);
                int n = deflater.deflate(out.getBuffer(), pos, out.getLimit() - pos);
                out.setPosition(pos + n);
            }
        }
        finally {
            deflater.reset();
            deflater.setInput(emptyInput);
            if (!DEFLATERS_POOL.offer(deflater)) {
                deflater.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void inflate(byte[] bytes, int offset, int length, ByteArrayOutput out) throws DataFormatException {
        Inflater inflater = INFLATERS_POOL.poll();
        if (inflater == null) {
            inflater = new Inflater();
        }
        try {
            inflater.setInput(bytes, offset, length);
            while (!inflater.finished()) {
                int pos = out.getPosition();
                out.ensureCapacity(pos + 8192);
                int n = inflater.inflate(out.getBuffer(), pos, out.getLimit() - pos);
                out.setPosition(pos + n);
                if (n != 0 || inflater.finished()) continue;
                if (inflater.needsInput()) {
                    throw new DataFormatException("needs input");
                }
                if (!inflater.needsDictionary()) continue;
                throw new DataFormatException("needs dictionary");
            }
            if (inflater.getRemaining() != 0) {
                throw new DataFormatException("remaining bytes");
            }
        }
        finally {
            inflater.reset();
            inflater.setInput(emptyInput);
            if (!INFLATERS_POOL.offer(inflater)) {
                inflater.end();
            }
        }
    }

    static boolean isCompressed(byte[] bytes, int offset, int length) {
        if (length < 6) {
            return false;
        }
        int header = (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
        return header <= 30975 && (header & 0xF00) == 2048 && header % 31 == 0;
    }

    static boolean shallCompress(byte[] bytes, int offset, int length) {
        return IOUtil.isCompressionEnabled() && length >= 8192 && !Compression.isCompressed(bytes, offset, length);
    }
}

