/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

class CompactSerializer {
    private static final Map<Class<?>, CompactType> TYPES_MAP = new HashMap();

    private CompactSerializer() {
    }

    static void writeUTF2Unchecked(DataOutput out, int codePoint) throws IOException {
        out.writeShort(0xC080 | codePoint << 2 & 0x1F00 | codePoint & 0x3F);
    }

    static void writeUTF3Unchecked(DataOutput out, int codePoint) throws IOException {
        out.writeByte(0xE0 | codePoint >>> 12);
        out.writeShort(0x8080 | codePoint << 2 & 0x3F00 | codePoint & 0x3F);
    }

    static void writeUTF4Unchecked(DataOutput out, int codePoint) throws IOException {
        out.writeInt(0xF0808080 | codePoint << 6 & 0x7000000 | codePoint << 4 & 0x3F0000 | codePoint << 2 & 0x3F00 | codePoint & 0x3F);
    }

    static char readUTF2(DataInput in, int first) throws IOException {
        byte second = in.readByte();
        if ((second & 0xC0) != 128) {
            throw new UTFDataFormatException();
        }
        return (char)((first & 0x1F) << 6 | second & 0x3F);
    }

    static char readUTF3(DataInput in, int first) throws IOException {
        short tail = in.readShort();
        if ((tail & 0xC0C0) != 32896) {
            throw new UTFDataFormatException();
        }
        return (char)((first & 0xF) << 12 | (tail & 0x3F00) >> 2 | tail & 0x3F);
    }

    static int readUTF4(DataInput in, int first) throws IOException {
        byte second = in.readByte();
        short tail = in.readShort();
        if ((second & 0xC0) != 128 || (tail & 0xC0C0) != 32896) {
            throw new UTFDataFormatException();
        }
        int codePoint = (first & 7) << 18 | (second & 0x3F) << 12 | (tail & 0x3F00) >> 2 | tail & 0x3F;
        if (codePoint > 0x10FFFF) {
            throw new UTFDataFormatException();
        }
        return codePoint;
    }

    static int readUTFBody(DataInput in, long utfLen, char[] chars, int offset) throws IOException {
        int count = offset;
        while (utfLen > 0L) {
            byte c = in.readByte();
            if (c >= 0) {
                --utfLen;
                chars[count++] = (char)c;
                continue;
            }
            if ((c & 0xE0) == 192) {
                utfLen -= 2L;
                chars[count++] = CompactSerializer.readUTF2(in, c);
                continue;
            }
            if ((c & 0xF0) == 224) {
                utfLen -= 3L;
                chars[count++] = CompactSerializer.readUTF3(in, c);
                continue;
            }
            if ((c & 0xF8) == 240) {
                utfLen -= 4L;
                count += Character.toChars(CompactSerializer.readUTF4(in, c), chars, count);
                continue;
            }
            throw new UTFDataFormatException();
        }
        if (utfLen < 0L) {
            throw new UTFDataFormatException();
        }
        return count - offset;
    }

    static boolean isCompact(Class<?> clazz) {
        return TYPES_MAP.containsKey(clazz) || clazz.isArray() && CompactSerializer.isCompact(clazz.getComponentType());
    }

    static void writeCompact(BufferedOutput out, Class<?> clazz, Object value) throws IOException {
        CompactSerializer.writeCompact(out, clazz, CompactSerializer.getCompactType(clazz), value);
    }

    static Object readCompact(BufferedInput in, Class<?> clazz) throws IOException {
        return CompactSerializer.readCompact(in, clazz, CompactSerializer.getCompactType(clazz));
    }

    private static void writeCompact(BufferedOutput out, Class<?> clazz, CompactType type, Object value) throws IOException {
        try {
            if (clazz.isArray()) {
                if (value == null) {
                    out.writeCompactInt(-1);
                    return;
                }
                Class<?> componentType = clazz.getComponentType();
                if (componentType.isArray()) {
                    Object[] array = (Object[])value;
                    out.writeCompactInt(array.length);
                    for (Object element : array) {
                        CompactSerializer.writeCompact(out, componentType, type, element);
                    }
                } else {
                    CompactSerializer.writePrimitiveArray(out, type, value);
                }
            } else {
                CompactSerializer.writePrimitiveValue(out, type, value);
            }
        }
        catch (ClassCastException e) {
            throw new IOException(e);
        }
    }

    private static Object readCompact(BufferedInput in, Class<?> clazz, CompactType type) throws IOException {
        if (clazz.isArray()) {
            long length = in.readCompactLong();
            if (length < -1L || length > Integer.MAX_VALUE) {
                throw new IOException("Illegal length.");
            }
            if (length == -1L) {
                return null;
            }
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isArray()) {
                Object[] array = (Object[])Array.newInstance(componentType, (int)length);
                int i = 0;
                while ((long)i < length) {
                    array[i] = CompactSerializer.readCompact(in, componentType, type);
                    ++i;
                }
                return array;
            }
            return CompactSerializer.readPrimitiveArray(in, type, (int)length);
        }
        return CompactSerializer.readPrimitiveValue(in, type);
    }

    private static void writePrimitiveArray(BufferedOutput out, CompactType type, Object value) throws IOException {
        switch (type) {
            case BOOLEAN: {
                boolean[] array = (boolean[])value;
                out.writeCompactInt(array.length);
                for (boolean element : array) {
                    out.writeBoolean(element);
                }
                break;
            }
            case BYTE: {
                byte[] array = (byte[])value;
                out.writeCompactInt(array.length);
                out.write(array);
                break;
            }
            case CHAR: {
                char[] array = (char[])value;
                out.writeCompactInt(array.length);
                for (char element : array) {
                    out.writeUTFChar(element);
                }
                break;
            }
            case SHORT: {
                short[] array = (short[])value;
                out.writeCompactInt(array.length);
                for (short element : array) {
                    out.writeCompactInt(element);
                }
                break;
            }
            case INT: {
                int[] array = (int[])value;
                out.writeCompactInt(array.length);
                for (int element : array) {
                    out.writeCompactInt(element);
                }
                break;
            }
            case LONG: {
                long[] array = (long[])value;
                out.writeCompactInt(array.length);
                for (long element : array) {
                    out.writeCompactLong(element);
                }
                break;
            }
            case FLOAT: {
                float[] array = (float[])value;
                out.writeCompactInt(array.length);
                for (float element : array) {
                    out.writeFloat(element);
                }
                break;
            }
            case DOUBLE: {
                double[] array = (double[])value;
                out.writeCompactInt(array.length);
                for (double element : array) {
                    out.writeDouble(element);
                }
                break;
            }
            case STRING: {
                String[] array = (String[])value;
                out.writeCompactInt(array.length);
                for (String element : array) {
                    out.writeUTFString(element);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type.");
            }
        }
    }

    private static Object readPrimitiveArray(BufferedInput in, CompactType type, int length) throws IOException {
        switch (type) {
            case BOOLEAN: {
                boolean[] array = new boolean[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = in.readBoolean();
                }
                return array;
            }
            case BYTE: {
                byte[] array = new byte[length];
                in.readFully(array);
                return array;
            }
            case CHAR: {
                char[] array = new char[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = (char)in.readUTFChar();
                }
                return array;
            }
            case SHORT: {
                short[] array = new short[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = (short)in.readCompactInt();
                }
                return array;
            }
            case INT: {
                int[] array = new int[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = in.readCompactInt();
                }
                return array;
            }
            case LONG: {
                long[] array = new long[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = in.readCompactLong();
                }
                return array;
            }
            case FLOAT: {
                float[] array = new float[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = in.readFloat();
                }
                return array;
            }
            case DOUBLE: {
                double[] array = new double[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = in.readDouble();
                }
                return array;
            }
            case STRING: {
                String[] array = new String[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = in.readUTFString();
                }
                return array;
            }
        }
        throw new IllegalArgumentException("Unknown primitive type.");
    }

    private static void writePrimitiveValue(BufferedOutput out, CompactType type, Object value) throws IOException {
        switch (type) {
            case VOID: {
                break;
            }
            case BOOLEAN: {
                out.writeBoolean((Boolean)value);
                break;
            }
            case BYTE: {
                out.writeByte(((Byte)value).byteValue());
                break;
            }
            case CHAR: {
                out.writeUTFChar(((Character)value).charValue());
                break;
            }
            case SHORT: {
                out.writeCompactInt(((Short)value).shortValue());
                break;
            }
            case INT: {
                out.writeCompactInt((Integer)value);
                break;
            }
            case LONG: {
                out.writeCompactLong((Long)value);
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                out.writeDouble((Double)value);
                break;
            }
            case STRING: {
                out.writeUTFString((String)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type.");
            }
        }
    }

    private static Object readPrimitiveValue(BufferedInput in, CompactType type) throws IOException {
        switch (type) {
            case VOID: {
                return null;
            }
            case BOOLEAN: {
                return in.readBoolean();
            }
            case BYTE: {
                return in.readByte();
            }
            case CHAR: {
                return Character.valueOf((char)in.readUTFChar());
            }
            case SHORT: {
                return (short)in.readCompactInt();
            }
            case INT: {
                return in.readCompactInt();
            }
            case LONG: {
                return in.readCompactLong();
            }
            case FLOAT: {
                return Float.valueOf(in.readFloat());
            }
            case DOUBLE: {
                return in.readDouble();
            }
            case STRING: {
                return in.readUTFString();
            }
        }
        throw new IllegalArgumentException("Unknown primitive type.");
    }

    private static CompactType getCompactType(Class<?> clazz) {
        CompactType type = TYPES_MAP.get(clazz);
        if (type != null) {
            return type;
        }
        if (clazz.isArray()) {
            return CompactSerializer.getCompactType(clazz.getComponentType());
        }
        throw new IllegalArgumentException("Cannot compactly serialize " + clazz + ".");
    }

    static {
        TYPES_MAP.put(Void.TYPE, CompactType.VOID);
        TYPES_MAP.put(Boolean.TYPE, CompactType.BOOLEAN);
        TYPES_MAP.put(Byte.TYPE, CompactType.BYTE);
        TYPES_MAP.put(Character.TYPE, CompactType.CHAR);
        TYPES_MAP.put(Short.TYPE, CompactType.SHORT);
        TYPES_MAP.put(Integer.TYPE, CompactType.INT);
        TYPES_MAP.put(Long.TYPE, CompactType.LONG);
        TYPES_MAP.put(Float.TYPE, CompactType.FLOAT);
        TYPES_MAP.put(Double.TYPE, CompactType.DOUBLE);
        TYPES_MAP.put(String.class, CompactType.STRING);
        TYPES_MAP.put(boolean[].class, CompactType.BOOLEAN);
        TYPES_MAP.put(byte[].class, CompactType.BYTE);
        TYPES_MAP.put(char[].class, CompactType.CHAR);
        TYPES_MAP.put(short[].class, CompactType.SHORT);
        TYPES_MAP.put(int[].class, CompactType.INT);
        TYPES_MAP.put(long[].class, CompactType.LONG);
        TYPES_MAP.put(float[].class, CompactType.FLOAT);
        TYPES_MAP.put(double[].class, CompactType.DOUBLE);
        TYPES_MAP.put(String[].class, CompactType.STRING);
    }

    private static enum CompactType {
        VOID,
        BOOLEAN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING;

    }
}

