/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import java.util.HashMap;
import java.util.Map;

public class ClassUtil {
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private static final Map<Class<?>, String> PRIMITIVE_TAGS = new HashMap();

    private ClassUtil() {
    }

    private static void putPrimitive(Class<?> c) {
        PRIMITIVE_TYPES.put(c.getName(), c);
    }

    private static void putPrimitiveTag(Class<?> c) {
        String name = c.getName();
        assert (name.startsWith("[") && name.length() == 2);
        PRIMITIVE_TAGS.put(c.getComponentType(), name.substring(1));
    }

    static boolean isPrimitiveType(String name) {
        return PRIMITIVE_TYPES.containsKey(name);
    }

    public static Class<?> getTypeClass(String type, ClassLoader cl) throws ClassNotFoundException {
        int dims = 0;
        while (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
            ++dims;
        }
        Class<?> c = PRIMITIVE_TYPES.get(type);
        if (c != null) {
            if (dims == 0) {
                return c;
            }
            type = PRIMITIVE_TAGS.get(c);
            if (type == null) {
                throw new ClassNotFoundException("Array of void does not exist");
            }
        } else if (dims != 0) {
            type = "L" + type + ";";
        }
        for (int i = 0; i < dims; ++i) {
            type = "[" + type;
        }
        return Class.forName(type, false, cl);
    }

    static ClassLoader resolveContextClassLoader(ClassLoader cl) {
        if (cl != null) {
            return cl;
        }
        try {
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            if (context != null) {
                return context;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtil.class.getClassLoader();
    }

    static {
        ClassUtil.putPrimitive(Boolean.TYPE);
        ClassUtil.putPrimitive(Byte.TYPE);
        ClassUtil.putPrimitive(Short.TYPE);
        ClassUtil.putPrimitive(Character.TYPE);
        ClassUtil.putPrimitive(Integer.TYPE);
        ClassUtil.putPrimitive(Long.TYPE);
        ClassUtil.putPrimitive(Float.TYPE);
        ClassUtil.putPrimitive(Double.TYPE);
        ClassUtil.putPrimitive(Void.TYPE);
        ClassUtil.putPrimitiveTag(boolean[].class);
        ClassUtil.putPrimitiveTag(byte[].class);
        ClassUtil.putPrimitiveTag(short[].class);
        ClassUtil.putPrimitiveTag(char[].class);
        ClassUtil.putPrimitiveTag(int[].class);
        ClassUtil.putPrimitiveTag(long[].class);
        ClassUtil.putPrimitiveTag(float[].class);
        ClassUtil.putPrimitiveTag(double[].class);
    }
}

