/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import com.devexperts.util.SystemProperties;
import java.io.IOException;

public class ChunkedOutput
extends BufferedOutput {
    protected static final int MAX_COPY_BYTES = SystemProperties.getIntProperty(ChunkedOutput.class, "maxCopyBytes", 256);
    private final ChunkPool pool;
    private ChunkList chunks;

    public ChunkedOutput() {
        this(ChunkPool.DEFAULT);
    }

    public ChunkedOutput(ChunkPool pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    public void clear() {
        this.totalPositionBase = 0L;
        this.resetBuffer();
        ChunkList chunks = this.chunks;
        if (chunks == null) {
            return;
        }
        this.chunks = null;
        chunks.recycle(this);
    }

    public ChunkList getOutput(Object owner) {
        if (this.chunks == null) {
            return null;
        }
        this.completeOrRecycleLastChunk();
        this.totalPositionBase += (long)this.position;
        this.resetBuffer();
        ChunkList result = this.chunks;
        this.chunks = null;
        result.handOver(this, owner);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
    }

    public long discard(long n) {
        if (n <= 0L) {
            return 0L;
        }
        if (this.chunks == null) {
            return 0L;
        }
        long remaining = n;
        Chunk c = this.chunks.get(this.chunks.size() - 1);
        while (remaining >= (long)(this.position - c.getOffset())) {
            remaining -= (long)(this.position - c.getOffset());
            this.totalPositionBase += (long)c.getOffset();
            this.chunks.pollLast(this).recycle(this);
            if (this.chunks.isEmpty()) {
                this.chunks.recycle(this);
                this.chunks = null;
                this.resetBuffer();
                return n - remaining;
            }
            c = this.chunks.get(this.chunks.size() - 1);
            this.buffer = c.getBytes();
            this.position = this.limit = c.getOffset() + c.getLength();
            this.totalPositionBase -= (long)c.getOffset();
        }
        this.position = (int)((long)this.position - remaining);
        return n;
    }

    @Override
    public void writeFromChunk(Chunk chunk, Object owner) throws IOException {
        if (chunk.getLength() <= MAX_COPY_BYTES || chunk.getPool() != this.pool) {
            super.writeFromChunk(chunk, owner);
            return;
        }
        this.ensureChunks();
        this.completeOrRecycleLastChunk();
        chunk.handOver(owner, this);
        this.chunks.add(chunk, this);
        this.totalPositionBase += (long)chunk.getLength();
        this.setCompletedBuffer(chunk);
    }

    @Override
    public void writeAllFromChunkList(ChunkList chunks, Object owner) throws IOException {
        Chunk chunk;
        if (chunks.getPool() == this.pool && this.chunks == null) {
            chunks.handOver(owner, this);
            this.chunks = chunks;
            if (!chunks.isEmpty()) {
                int lastIndex = chunks.size() - 1;
                Chunk c = chunks.get(lastIndex);
                this.buffer = c.getBytes();
                this.position = c.getOffset() + c.getLength();
                this.limit = this.buffer.length;
                this.totalPositionBase += chunks.getTotalLength() - (long)this.position;
                chunks.setChunkRange(lastIndex, c.getOffset(), this.limit - c.getOffset(), this);
            }
            return;
        }
        while ((chunk = chunks.poll(owner)) != null) {
            this.writeFromChunk(chunk, owner);
        }
        chunks.recycle(owner);
    }

    @Override
    protected void needSpace() throws IOException {
        this.checkEOB();
        this.flush();
        this.ensureChunks();
        Chunk c = this.pool.getChunk(this);
        this.chunks.add(c, this);
        this.totalPositionBase += (long)(this.position - c.getOffset());
        this.buffer = c.getBytes();
        this.position = c.getOffset();
        this.limit = this.position + c.getLength();
    }

    public String toString() {
        return "ChunkedOutput{totalPosition=" + this.totalPosition() + ",buffer.length=" + this.buffer.length + ",position=" + this.position + ",limit=" + this.position + ",chunks=" + this.chunks + "}";
    }

    private void ensureChunks() {
        if (this.chunks == null) {
            this.chunks = this.pool.getChunkList(this);
        }
    }

    private void completeOrRecycleLastChunk() {
        if (this.chunks.isEmpty()) {
            return;
        }
        Chunk c = this.chunks.get(this.chunks.size() - 1);
        if (this.position > c.getOffset()) {
            this.chunks.setChunkRange(this.chunks.size() - 1, c.getOffset(), this.position - c.getOffset(), this);
            this.limit = this.position;
        } else {
            this.chunks.pollLast(this).recycle(this);
            if (this.chunks.isEmpty()) {
                this.totalPositionBase += (long)this.position;
                this.resetBuffer();
            } else {
                this.setCompletedBuffer(this.chunks.get(this.chunks.size() - 1));
            }
        }
    }

    private void setCompletedBuffer(Chunk c) {
        this.totalPositionBase += (long)(this.position - c.getOffset() - c.getLength());
        this.buffer = c.getBytes();
        this.limit = this.position = c.getOffset() + c.getLength();
    }

    private void resetBuffer() {
        this.buffer = EMPTY_BYTE_ARRAY;
        this.position = 0;
        this.limit = 0;
    }
}

