/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.IOUtil;

public final class ChunkedInput
extends BufferedInput {
    private final ChunkList chunks;
    private int index;
    private static final Chunk EMPTY_CHUNK = Chunk.wrap(EMPTY_BYTE_ARRAY, null);

    public ChunkedInput() {
        this(ChunkPool.DEFAULT);
    }

    public ChunkedInput(ChunkPool pool) {
        this.chunks = pool.getChunkList(this);
    }

    public void clear() {
        this.buffer = EMPTY_BYTE_ARRAY;
        this.position = 0;
        this.limit = 0;
        this.totalPositionBase = 0L;
        this.markPosition = -1L;
        this.index = this.chunks.size();
        this.recycleUpToIndex();
    }

    public void addToInput(byte[] bytes, int offset, int length) {
        if (this.needsAdvanceBuffer()) {
            this.advanceBuffer();
        }
        this.chunks.add(bytes, offset, length);
        if (this.needsAdvanceBuffer()) {
            this.setBuffer(this.chunks.get(this.index));
        }
    }

    public void addToInput(Chunk chunk, Object owner) {
        if (chunk.getLength() > 0) {
            chunk.handOver(owner, this);
            this.chunks.add(chunk, this);
            if (this.index == this.chunks.size() - 1) {
                this.setBuffer(chunk);
            }
        } else {
            chunk.recycle(owner);
        }
    }

    public void addAllToInput(ChunkList chunkList, Object owner) {
        if (chunkList.isReadOnly()) {
            int n = chunkList.size();
            for (int i = 0; i < n; ++i) {
                this.addToInput(chunkList.get(i), null);
            }
        } else {
            Chunk c;
            while ((c = chunkList.poll(owner)) != null) {
                this.addToInput(c, owner);
            }
            chunkList.recycle(owner);
        }
    }

    @Override
    public boolean hasAvailable() {
        return this.position < this.limit || this.index + 1 < this.chunks.size();
    }

    @Override
    public boolean hasAvailable(int bytes) {
        long result = this.limit - this.position;
        if (result >= (long)bytes) {
            return true;
        }
        int n = this.chunks.size();
        for (int i = this.index + 1; i < n; ++i) {
            if ((result += (long)this.chunks.get(i).getLength()) < (long)bytes) continue;
            return true;
        }
        return false;
    }

    @Override
    public int available() {
        long result = this.limit - this.position;
        int n = this.chunks.size();
        for (int i = this.index + 1; i < n; ++i) {
            result += (long)this.chunks.get(i).getLength();
        }
        return (int)Math.min(result, Integer.MAX_VALUE);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int result;
        int n;
        IOUtil.checkRange(b, off, len);
        for (result = 0; result < len; result += n) {
            if (this.position >= this.limit && this.readData() <= 0) {
                return result > 0 ? result : -1;
            }
            n = Math.min(len - result, this.limit - this.position);
            System.arraycopy(this.buffer, this.position, b, off + result, n);
            this.position += n;
        }
        return result;
    }

    @Override
    public void mark() {
        super.mark();
        this.recycleUpToMark();
    }

    @Override
    public void unmark() {
        super.unmark();
        this.recycleUpToMark();
    }

    @Override
    public void rewind(long n) throws IllegalStateException {
        this.checkRewind(n);
        while (n > 0L) {
            if (this.index >= this.chunks.size() || this.position <= this.chunks.get(this.index).getOffset()) {
                Chunk c = this.chunks.get(--this.index);
                long totalPosition = this.totalPosition();
                this.buffer = c.getBytes();
                this.position = this.limit = c.getOffset() + c.getLength();
                this.totalPositionBase = totalPosition - (long)this.position;
            }
            int k = (int)Math.min(n, (long)(this.position - this.chunks.get(this.index).getOffset()));
            this.position -= k;
            n -= (long)k;
        }
    }

    public String toString() {
        return "ChunkedInput{totalPosition=" + this.totalPosition() + ",markPosition=" + this.markPosition + ",buffer.length=" + this.buffer.length + ",position=" + this.position + ",limit=" + this.position + ",chunks=" + this.chunks + "}";
    }

    private void setBuffer(Chunk c) {
        long totalPosition = this.totalPosition();
        this.buffer = c.getBytes();
        this.position = c.getOffset();
        this.limit = this.position + c.getLength();
        this.totalPositionBase = totalPosition - (long)this.position;
    }

    private void advanceBuffer() {
        assert (this.needsAdvanceBuffer());
        this.setBuffer(++this.index < this.chunks.size() ? this.chunks.get(this.index) : EMPTY_CHUNK);
    }

    private boolean needsAdvanceBuffer() {
        return this.position == this.limit && this.index < this.chunks.size();
    }

    private void recycleUpToIndex() {
        while (this.index > 0) {
            this.chunks.poll(this).recycle(this);
            --this.index;
        }
    }

    private void recycleUpToMark() {
        if (this.markPosition < 0L) {
            this.recycleUpToIndex();
            return;
        }
        if (this.index == 0) {
            return;
        }
        int curIndex = this.index;
        long curChunkStartPosition = this.totalPositionBase;
        if (this.index < this.chunks.size()) {
            curChunkStartPosition += (long)this.chunks.get(this.index).getOffset();
        }
        while (curChunkStartPosition > this.markPosition) {
            curChunkStartPosition -= (long)this.chunks.get(--curIndex).getLength();
        }
        while (curIndex > 0) {
            this.chunks.poll(this).recycle(this);
            --this.index;
            --curIndex;
        }
    }

    @Override
    protected int readData() {
        this.checkEOB();
        if (this.index >= this.chunks.size()) {
            return -1;
        }
        this.advanceBuffer();
        if (this.markPosition < 0L) {
            this.recycleUpToIndex();
        }
        return this.index >= this.chunks.size() ? -1 : this.limit - this.position;
    }
}

