/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.ThreadLocalPool;
import java.lang.ref.WeakReference;

public class ChunkPool {
    public static final ChunkPool DEFAULT = new ChunkPool("com.devexperts.io", 3, 4096, 1024, 8192, 1024);
    static final WeakReference<ChunkPool> EMPTY_REFERENCE = new WeakReference<Object>(null);
    final WeakReference<ChunkPool> reference = new WeakReference<ChunkPool>(this);
    private final Object internalOwner = new Object();
    private final ThreadLocalPool<Chunk> chunkPool;
    private final ThreadLocalPool<ChunkList> chunkListPool;
    private final int chunkSize;
    private final int recyclableChunkListCapacity;

    public ChunkPool(String poolName, int threadLocalCapacity, int chunkPoolCapacity, int chunkListPoolCapacity, int chunkSize, int recyclableChunkListCapacity) {
        this.chunkPool = new ThreadLocalPool(poolName + ".Chunk", threadLocalCapacity, chunkPoolCapacity);
        this.chunkListPool = new ThreadLocalPool(poolName + ".ChunkList", threadLocalCapacity, chunkListPoolCapacity);
        this.chunkSize = SystemProperties.getIntProperty(poolName + ".chunkSize", chunkSize);
        this.recyclableChunkListCapacity = SystemProperties.getIntProperty(poolName + ".recyclableChunkListCapacity", recyclableChunkListCapacity);
        if (this.chunkSize < 1) {
            throw new IllegalArgumentException("chunk size must be positive");
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Chunk getChunk(Object owner) {
        Chunk chunk = this.chunkPool.poll();
        if (chunk == null) {
            return this.createNewChunk(owner);
        }
        chunk.offset = 0;
        chunk.length = chunk.bytes.length;
        chunk.handOver(this.internalOwner, owner);
        return chunk;
    }

    public ChunkList getChunkList(Object owner) {
        ChunkList chunkList = this.chunkListPool.poll();
        if (chunkList == null) {
            return this.createNewChunkList(owner);
        }
        chunkList.tail = 0;
        chunkList.head = 0;
        chunkList.handOver(this.internalOwner, owner);
        return chunkList;
    }

    public ChunkList copyToChunkList(byte[] bytes, int offset, int length, Object owner) {
        ChunkList result = this.getChunkList(owner);
        result.add(bytes, offset, length);
        return result;
    }

    protected Chunk createNewChunk(Object owner) {
        return new Chunk(this, new byte[this.chunkSize], owner);
    }

    protected ChunkList createNewChunkList(Object owner) {
        return new ChunkList(this, owner);
    }

    protected void recycleChunk(Chunk chunk, Object owner) {
        if (chunk.poolReference.get() != this) {
            throw new IllegalArgumentException("chunk belongs to another pool");
        }
        if (chunk.bytes.length != this.chunkSize) {
            throw new IllegalArgumentException("chunk to be pooled has wrong length");
        }
        chunk.checkOwner(owner);
        chunk.handOver(owner, this.internalOwner);
        chunk.length = -1;
        chunk.offset = -1;
        this.chunkPool.offer(chunk);
    }

    protected void recycleChunkList(ChunkList chunkList, Object owner) {
        if (chunkList.poolReference.get() != this) {
            throw new IllegalArgumentException("chunk list belongs to another pool");
        }
        if (!chunkList.isEmpty()) {
            throw new IllegalStateException("chunk list to be pooled is not empty");
        }
        chunkList.checkOwner(owner);
        chunkList.handOver(owner, this.internalOwner);
        chunkList.tail = -1;
        chunkList.head = -1;
        if (chunkList.chunkArray.length <= this.recyclableChunkListCapacity) {
            this.chunkListPool.offer(chunkList);
        }
    }

    public String toString() {
        return "ChunkPool{chunkSize=" + this.chunkSize + ",recyclableChunkListCapacity=" + this.recyclableChunkListCapacity + ",chunkPool.size=" + this.chunkPool.size() + ",chunkListPool.size=" + this.chunkListPool.size() + "}";
    }
}

