/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkUtil;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChunkList
implements Iterable<Chunk> {
    public static final ChunkList EMPTY = new ChunkList(null);
    private static final Iterator<Chunk> EMPTY_ITERATOR;
    private final Object internalOwner = new Object();
    private Object owner;
    protected final WeakReference<ChunkPool> poolReference;
    protected Chunk[] chunkArray;
    protected int head;
    protected int tail;
    private ChunkIterator pooledIterator;

    public static ChunkList wrap(byte[] bytes, Object owner) {
        return ChunkList.wrap(bytes, 0, bytes.length, owner);
    }

    public static ChunkList wrap(byte[] bytes, int offset, int length, Object owner) {
        ChunkList chunks = new ChunkList(owner);
        chunks.add(Chunk.wrap(bytes, offset, length, owner), owner);
        return chunks;
    }

    public ChunkList(Object owner) {
        this(null, owner);
    }

    protected ChunkList(ChunkPool pool, Object owner) {
        this.poolReference = pool != null ? pool.reference : ChunkPool.EMPTY_REFERENCE;
        this.chunkArray = new Chunk[ChunkUtil.INITIAL_CHUNK_LIST_CAPACITY];
        this.owner = owner;
    }

    public ChunkPool getPool() {
        return (ChunkPool)this.poolReference.get();
    }

    public int size() {
        return this.tail - this.head;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public Chunk get(int index) {
        this.checkRange(index);
        return this.chunkArray[this.head + index];
    }

    public long getTotalLength() {
        long result = 0L;
        for (int i = this.head; i < this.tail; ++i) {
            result += (long)this.chunkArray[i].getLength();
        }
        return result;
    }

    @Override
    public Iterator<Chunk> iterator() {
        if (this.isEmpty()) {
            return EMPTY_ITERATOR;
        }
        ChunkIterator it = this.pooledIterator;
        if (it == null || this.isReadOnly()) {
            return new ChunkIterator();
        }
        if (it.index != -1) {
            throw new IllegalStateException();
        }
        this.pooledIterator = null;
        it.index = this.head;
        return it;
    }

    public void add(Chunk chunk, Object owner) {
        this.checkOwner(owner);
        if (chunk == null) {
            throw new NullPointerException("chunk is null");
        }
        this.ensureTailSpace(1);
        chunk.handOver(owner, this.internalOwner);
        this.chunkArray[this.tail++] = chunk;
    }

    private void ensureTailSpace(int space) {
        if (space <= this.chunkArray.length - this.tail) {
            return;
        }
        int cap = this.tail - this.head + space;
        if (cap < 0) {
            throw new IllegalArgumentException("Capacity overflow");
        }
        Chunk[] tmp = cap < this.chunkArray.length >> 1 ? this.chunkArray : new Chunk[Math.max((int)Math.min((long)this.chunkArray.length * 2L + 1L, Integer.MAX_VALUE), cap)];
        System.arraycopy(this.chunkArray, this.head, tmp, 0, this.tail - this.head);
        this.chunkArray = tmp;
        this.tail -= this.head;
        this.head = 0;
    }

    public void addAll(ChunkList chunks, Object owner) {
        if (chunks == this) {
            throw new IllegalArgumentException("can not add itself");
        }
        this.checkOwner(owner);
        this.ensureTailSpace(chunks.size());
        if (chunks.isReadOnly()) {
            System.arraycopy(chunks.chunkArray, chunks.head, this.chunkArray, this.tail, chunks.size());
            this.tail += chunks.size();
        } else {
            chunks.checkOwner(owner);
            for (int i = chunks.head; i < chunks.tail; ++i) {
                Chunk c = chunks.chunkArray[i];
                c.handOver(chunks.internalOwner, this.internalOwner);
                chunks.chunkArray[i] = null;
                this.chunkArray[this.tail++] = c;
            }
            chunks.tail = 0;
            chunks.head = 0;
            chunks.recycle(owner);
        }
    }

    public void add(byte[] bytes, int offset, int length) {
        if ((offset | length | offset + length | bytes.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            Chunk chunk = ((ChunkPool)this.poolReference.get()).getChunk(this.owner);
            int n = Math.min(length, chunk.getLength());
            System.arraycopy(bytes, offset, chunk.getBytes(), chunk.getOffset(), n);
            offset += n;
            length -= n;
            chunk.setLength(n, this.owner);
            this.add(chunk, this.owner);
        }
    }

    public Chunk poll(Object owner) {
        this.checkOwner(owner);
        if (this.isEmpty()) {
            return null;
        }
        Chunk c = this.chunkArray[this.head];
        this.chunkArray[this.head++] = null;
        if (this.head == this.tail) {
            this.tail = 0;
            this.head = 0;
        }
        c.handOver(this.internalOwner, owner);
        return c;
    }

    public Chunk pollLast(Object owner) {
        this.checkOwner(owner);
        if (this.isEmpty()) {
            return null;
        }
        Chunk c = this.chunkArray[--this.tail];
        this.chunkArray[this.tail] = null;
        if (this.head == this.tail) {
            this.tail = 0;
            this.head = 0;
        }
        c.handOver(this.internalOwner, owner);
        return c;
    }

    public void setChunkRange(int index, int offset, int length, Object owner) {
        this.checkOwner(owner);
        this.checkRange(index);
        this.chunkArray[this.head + index].setRange(offset, length, this.internalOwner);
    }

    public boolean isReadOnly() {
        return this.owner == ChunkUtil.READ_ONLY_OWNER;
    }

    public void markReadOnly(Object owner) {
        for (int i = this.head; i < this.tail; ++i) {
            this.chunkArray[i].markReadOnly(this.internalOwner);
        }
        this.handOver(owner, ChunkUtil.READ_ONLY_OWNER);
    }

    public void handOver(Object oldOwner, Object newOwner) {
        if (this.owner == ChunkUtil.READ_ONLY_OWNER) {
            return;
        }
        if (this.owner != oldOwner) {
            throw new IllegalStateException("invalid owner, expected " + ChunkUtil.ownerString(oldOwner) + ", found " + ChunkUtil.ownerString(this.owner));
        }
        this.owner = newOwner;
    }

    public void recycle(Object owner) {
        if (this.isReadOnly()) {
            return;
        }
        this.checkOwner(owner);
        for (int i = this.head; i < this.tail; ++i) {
            this.chunkArray[i].recycle(this.internalOwner);
            this.chunkArray[i] = null;
        }
        this.tail = 0;
        this.head = 0;
        ChunkPool pool = (ChunkPool)this.poolReference.get();
        if (pool != null) {
            pool.recycleChunkList(this, owner);
        } else {
            this.handOver(owner, ChunkUtil.GARBAGE_OWNER);
            this.tail = -1;
            this.head = -1;
        }
    }

    protected void checkOwner(Object owner) {
        if (this.owner != owner) {
            throw new IllegalStateException(this.owner == ChunkUtil.READ_ONLY_OWNER ? "chunk list is read-only" : "invalid owner");
        }
    }

    protected void checkRange(int index) {
        if (index < 0 || index >= this.tail - this.head) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String toString() {
        return "ChunkList{chunkArray.length=" + this.chunkArray.length + ",size=" + this.size() + ",totalLength=" + this.getTotalLength() + ",pool=" + this.poolReference.get() + "}";
    }

    static {
        EMPTY.markReadOnly(null);
        EMPTY_ITERATOR = Collections.emptySet().iterator();
    }

    private class ChunkIterator
    implements Iterator<Chunk> {
        int index;

        ChunkIterator() {
            this.index = ChunkList.this.head;
        }

        @Override
        public boolean hasNext() {
            if (this.index < ChunkList.this.head) {
                throw new IllegalStateException();
            }
            if (this.index < ChunkList.this.tail) {
                return true;
            }
            this.index = -1;
            if (!ChunkList.this.isReadOnly()) {
                ChunkList.this.pooledIterator = this;
            }
            return false;
        }

        @Override
        public Chunk next() {
            if (this.index < ChunkList.this.head) {
                throw new IllegalStateException();
            }
            if (this.index < ChunkList.this.tail) {
                return ChunkList.this.chunkArray[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

