/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkUtil;
import java.lang.ref.WeakReference;

public class Chunk {
    private Object owner;
    protected final WeakReference<ChunkPool> poolReference;
    protected final byte[] bytes;
    protected int offset;
    protected int length;

    public static Chunk wrap(byte[] bytes, Object owner) {
        return Chunk.wrap(bytes, 0, bytes.length, owner);
    }

    public static Chunk wrap(byte[] bytes, int offset, int length, Object owner) {
        Chunk c = new Chunk(null, bytes, owner);
        c.setRange(offset, length, owner);
        return c;
    }

    protected Chunk(ChunkPool pool, byte[] bytes, Object owner) {
        this.poolReference = pool != null ? pool.reference : ChunkPool.EMPTY_REFERENCE;
        this.bytes = bytes;
        this.length = bytes.length;
        this.owner = owner;
    }

    public ChunkPool getPool() {
        return (ChunkPool)this.poolReference.get();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length, Object owner) {
        this.setRange(this.offset, length, owner);
    }

    public void setRange(int offset, int length, Object owner) {
        this.checkOwner(owner);
        if ((offset | length | offset + length | this.bytes.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = offset;
        this.length = length;
    }

    public boolean isReadOnly() {
        return this.owner == ChunkUtil.READ_ONLY_OWNER;
    }

    public void markReadOnly(Object owner) {
        this.handOver(owner, ChunkUtil.READ_ONLY_OWNER);
    }

    public void handOver(Object oldOwner, Object newOwner) {
        if (this.owner == ChunkUtil.READ_ONLY_OWNER) {
            return;
        }
        if (this.owner != oldOwner) {
            throw new IllegalStateException("invalid owner, expected " + ChunkUtil.ownerString(oldOwner) + ", found " + ChunkUtil.ownerString(this.owner));
        }
        this.owner = newOwner;
    }

    public void recycle(Object owner) {
        if (this.isReadOnly()) {
            return;
        }
        ChunkPool pool = (ChunkPool)this.poolReference.get();
        if (pool != null) {
            pool.recycleChunk(this, owner);
        } else {
            this.handOver(owner, ChunkUtil.GARBAGE_OWNER);
            this.length = -1;
            this.offset = -1;
        }
    }

    protected void checkOwner(Object owner) {
        if (this.owner != owner) {
            throw new IllegalStateException(this.owner == ChunkUtil.READ_ONLY_OWNER ? "chunk is read-only" : "invalid owner");
        }
    }

    public String toString() {
        return "Chunk{bytes.length=" + this.bytes.length + ",offset=" + this.offset + ",length=" + this.length + ",pool=" + this.poolReference.get() + "}";
    }
}

