/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVWriter
implements Closeable,
Flushable {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char[] CRLF = new char[]{'\r', '\n'};
    private final Writer writer;
    private final char separator;
    private final char quote;
    private boolean needCRLF;
    private boolean insideRecord;
    private int lineNumber = 1;
    private int recordNumber = 1;
    private char[] quoteBuf;

    public CSVWriter(Writer writer) {
        this(writer, ',', '\"');
    }

    public CSVWriter(Writer writer, char separator, char quote) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (separator == '\r' || separator == '\n') {
            throw new IllegalArgumentException("separator is CR or LF");
        }
        if (quote == '\r' || quote == '\n' || quote == separator) {
            throw new IllegalArgumentException("quote is CR, LF or same as separator");
        }
        this.writer = writer;
        this.separator = separator;
        this.quote = quote;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public void writeField(String field) throws IOException {
        char[] cArray;
        if (this.needCRLF) {
            this.writer.write(CRLF);
            this.needCRLF = false;
            ++this.lineNumber;
        }
        if (this.insideRecord) {
            this.writer.write(this.separator);
        }
        this.insideRecord = true;
        if (field == null || field.isEmpty()) {
            return;
        }
        if (field.indexOf(this.separator) < 0 && field.indexOf(this.quote) < 0 && field.indexOf(13) < 0 && field.indexOf(10) < 0) {
            this.writer.write(field);
            return;
        }
        int capacity = field.length() * 2 + 2;
        if (capacity > 512) {
            cArray = new char[capacity];
        } else if (this.quoteBuf != null) {
            cArray = this.quoteBuf;
        } else {
            this.quoteBuf = new char[512];
            cArray = this.quoteBuf;
        }
        char[] buf = cArray;
        int n = 0;
        buf[n++] = this.quote;
        for (int i = 0; i < field.length(); ++i) {
            char c = field.charAt(i);
            if (c == '\r' || c == '\n' && buf[n - 1] != '\r') {
                ++this.lineNumber;
            }
            if (c == this.quote) {
                buf[n++] = this.quote;
            }
            buf[n++] = c;
        }
        buf[n++] = this.quote;
        this.writer.write(buf, 0, n);
    }

    public void writeRecord(String[] record) throws IOException {
        if (record != null) {
            for (String field : record) {
                this.writeField(field);
            }
        }
        if (!this.insideRecord) {
            throw new IllegalArgumentException("records without fields are not allowed");
        }
        this.needCRLF = true;
        this.insideRecord = false;
        ++this.recordNumber;
    }

    public void writeAll(List<String[]> records) throws IOException {
        for (String[] record : records) {
            this.writeRecord(record);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

