/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.CSVFormatException;
import com.devexperts.util.StringCache;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
implements Closeable {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int INITIAL_CAPACITY = 8192;
    private static final int MAX_ARRAY_SIZE = 2147483547;
    private final Reader reader;
    private final char separator;
    private final char quote;
    private final StringCache strings = new StringCache();
    private char[] buf = new char[8192];
    private int position;
    private int limit;
    private boolean eol;
    private boolean eof;
    private int lineNumber = 1;
    private int recordNumber = 1;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"');
    }

    public CSVReader(Reader reader, char separator, char quote) {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        if (separator == '\r' || separator == '\n') {
            throw new IllegalArgumentException("separator is CR or LF");
        }
        if (quote == '\r' || quote == '\n' || quote == separator) {
            throw new IllegalArgumentException("quote is CR, LF or same as separator");
        }
        this.reader = reader;
        this.separator = separator;
        this.quote = quote;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public boolean isRecordEnded() {
        return this.eol || this.eof;
    }

    public String readField() throws IOException {
        return this.readField("");
    }

    public String readField(String expectedFieldValue) throws IOException {
        if (this.eol || this.eof) {
            return null;
        }
        int pos = this.position;
        int firstLine = this.lineNumber;
        int quoteCount = 0;
        while (true) {
            char c;
            if (pos >= this.limit) {
                pos -= this.position;
                this.read();
                if ((pos += this.position) >= this.limit) {
                    return this.finishEof(pos, firstLine, quoteCount, expectedFieldValue);
                }
            }
            if ((c = this.buf[pos]) == this.quote) {
                if (quoteCount == 0 && pos > this.position) {
                    throw this.fail("unquoted field has quote character", firstLine);
                }
                ++quoteCount;
                ++pos;
                continue;
            }
            if (c == this.separator) {
                if ((quoteCount & 1) == 0) {
                    return this.good(pos, quoteCount, 1, expectedFieldValue);
                }
            } else if (c == '\r') {
                if ((quoteCount & 1) == 0) {
                    this.eol = true;
                    return this.good(pos, quoteCount, 0, expectedFieldValue);
                }
                ++this.lineNumber;
            } else if (c == '\n') {
                if ((quoteCount & 1) == 0) {
                    this.eol = true;
                    return this.good(pos, quoteCount, 0, expectedFieldValue);
                }
                if (this.buf[pos - 1] != '\r') {
                    ++this.lineNumber;
                }
            }
            if (quoteCount >= 2 && (quoteCount & 1) == 0) {
                throw this.fail("quoted field has unpaired quote character", firstLine);
            }
            ++pos;
        }
    }

    private String finishEof(int pos, int firstLine, int quoteCount, String expectedFieldValue) throws CSVFormatException {
        if ((quoteCount & 1) != 0) {
            throw this.fail("quoted field does not have terminating quote character", firstLine);
        }
        this.eol = true;
        this.eof = true;
        return this.good(pos, quoteCount, 0, expectedFieldValue);
    }

    private String good(int fieldEnd, int quoteCount, int separatorSize, String expectedFieldValue) {
        int quoteSize = -quoteCount >>> 31;
        int pos = this.position + quoteSize;
        int end = fieldEnd - quoteSize;
        this.position = fieldEnd + separatorSize;
        if (quoteCount > 2) {
            end = this.unquote(pos, end);
        }
        if (expectedFieldValue.length() == end - pos && this.contentEquals(expectedFieldValue, pos)) {
            return expectedFieldValue;
        }
        return this.strings.get(this.buf, pos, end - pos);
    }

    private int unquote(int pos, int end) {
        int n;
        for (n = pos; n < end && this.buf[n] != this.quote; ++n) {
        }
        for (int i = n; i < end; ++i) {
            this.buf[n++] = this.buf[i];
            if (this.buf[n++] != this.quote) continue;
            ++i;
        }
        return n;
    }

    private boolean contentEquals(String expectedFieldValue, int pos) {
        int i = expectedFieldValue.length();
        while (--i >= 0) {
            if (expectedFieldValue.charAt(i) == this.buf[pos + i]) continue;
            return false;
        }
        return true;
    }

    private CSVFormatException fail(String message, int firstLine) {
        message = firstLine == this.lineNumber ? message + " (line " + firstLine + ")" : message + " (lines from " + firstLine + " to " + this.lineNumber + ")";
        this.lineNumber = firstLine;
        return new CSVFormatException(message);
    }

    private void read() throws IOException {
        int n;
        if (this.limit - this.position > this.buf.length >> 1 && this.buf.length < 2147483547) {
            this.growAndMove();
        } else if (this.position > this.buf.length - this.limit) {
            this.move();
        }
        if (this.limit >= this.buf.length) {
            throw new IllegalStateException("field is too long");
        }
        while ((n = this.reader.read(this.buf, this.limit, this.buf.length - this.limit)) == 0) {
        }
        if (n > 0) {
            this.limit += n;
        }
    }

    private void growAndMove() {
        char[] tmp = new char[(int)Math.min((long)this.buf.length * 2L, 2147483547L)];
        System.arraycopy(this.buf, this.position, tmp, 0, this.limit - this.position);
        this.limit -= this.position;
        this.position = 0;
        this.buf = tmp;
    }

    private void move() {
        System.arraycopy(this.buf, this.position, this.buf, 0, this.limit - this.position);
        this.limit -= this.position;
        this.position = 0;
    }

    public String[] readRecord() throws IOException {
        ArrayList<String> fields = new ArrayList<String>();
        return this.readRecord(fields) < 0 ? null : fields.toArray(new String[fields.size()]);
    }

    public int readRecord(List<String> fields) throws IOException {
        int n = 0;
        while (true) {
            if (n < fields.size()) {
                String expected = fields.get(n);
                String field = this.readField(expected);
                if (field == null) break;
                if (field != expected) {
                    fields.set(n, field);
                }
            } else {
                String field = this.readField("");
                if (field == null) break;
                fields.add(field);
            }
            ++n;
        }
        if (this.eol) {
            this.eol = false;
            boolean skipLF = false;
            while (!this.eof) {
                if (this.position >= this.limit) {
                    this.read();
                    if (this.position >= this.limit) {
                        this.eof = true;
                        break;
                    }
                }
                if (skipLF) {
                    if (this.buf[this.position] != '\n') break;
                    ++this.position;
                    break;
                }
                ++this.lineNumber;
                if (this.buf[this.position++] == '\n') break;
                skipLF = true;
            }
            ++this.recordNumber;
            return n;
        }
        return -1;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> records = new ArrayList<String[]>();
        String[] record = this.readRecord();
        while (record != null) {
            records.add(record);
            record = this.readRecord();
        }
        return records;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

