/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.util.ArrayUtil;
import java.io.IOException;

public class ByteArrayOutput
extends BufferedOutput {
    private static final int MIN_CAPACITY = 64;

    @Override
    protected final void needSpace() throws IOException {
        if (this.position == Integer.MAX_VALUE) {
            throw new IOException("Buffer overflow");
        }
        this.ensureCapacity(this.position + 1);
    }

    public ByteArrayOutput() {
    }

    public ByteArrayOutput(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size");
        }
        if (size > 0) {
            this.limit = size;
            this.buffer = new byte[this.limit];
        }
    }

    public ByteArrayOutput(byte[] buffer) {
        this.buffer = buffer;
        this.limit = buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] newBuffer) {
        if (newBuffer == null) {
            newBuffer = EMPTY_BYTE_ARRAY;
        }
        this.buffer = newBuffer;
        this.position = 0;
        this.limit = this.buffer.length;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        if (newLimit < 0 || newLimit > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
    }

    public void clear() {
        this.totalPositionBase = 0L;
        this.position = 0;
        this.limit = this.buffer.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        IOUtil.checkRange(b, off, len);
        if (len == 0) {
            return;
        }
        if (this.buffer.length == 0) {
            this.setBuffer(new byte[len]);
        } else {
            this.ensureCapacity(this.position + len);
        }
        System.arraycopy(b, off, this.buffer, this.position, len);
        this.position += len;
    }

    public void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, Math.max(64, requiredCapacity));
        }
        this.limit = this.buffer.length;
    }

    public byte[] toByteArray() {
        if (this.position == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] data = new byte[this.position];
        System.arraycopy(this.buffer, 0, data, 0, this.position);
        return data;
    }

    public String toString() {
        return this.position == 0 ? "" : new String(this.buffer, 0, this.position);
    }
}

