/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.util.ArrayUtil;
import java.io.IOException;

public class ByteArrayInput
extends BufferedInput {
    private static final int MIN_CAPACITY = 1024;

    protected int readData(int length) throws IOException {
        this.checkEOB();
        return -1;
    }

    @Override
    protected int readData() throws IOException {
        return this.readData(1);
    }

    public ByteArrayInput() {
    }

    public ByteArrayInput(byte[] buf) {
        this.setBuffer(buf);
    }

    public ByteArrayInput(byte[] buf, int offset, int length) {
        this.setInput(buf, offset, length);
    }

    public void setInput(byte[] buf, int offset, int length) {
        this.setBuffer(buf);
        this.setLimit(offset + length);
        this.setPosition(offset);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] newBuffer) {
        if (newBuffer == null) {
            newBuffer = EMPTY_BYTE_ARRAY;
        }
        this.buffer = newBuffer;
        this.position = 0;
        this.limit = this.buffer.length;
        this.totalPositionBase = 0L;
        this.markPosition = -1L;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        if ((long)this.position < this.markPosition) {
            this.markPosition = -1L;
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        if (newLimit < 0 || newLimit > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if ((long)this.position < this.markPosition) {
            this.markPosition = -1L;
        }
    }

    public void setTotalPosition(long totalPosition) {
        if (totalPosition < 0L) {
            throw new IllegalArgumentException();
        }
        this.totalPositionBase = totalPosition - (long)this.position;
    }

    public void clear() {
        this.position = 0;
        this.limit = this.buffer.length;
        this.totalPositionBase = 0L;
        this.markPosition = -1L;
    }

    public void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, Math.max(1024, requiredCapacity));
        }
    }

    @Override
    public void rewind(long n) {
        this.checkRewind(n);
        this.position = (int)((long)this.position - n);
    }
}

