/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public abstract class BufferedOutput
extends OutputStream
implements ObjectOutput {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected byte[] buffer = EMPTY_BYTE_ARRAY;
    protected int position;
    protected int limit;
    protected long totalPositionBase;

    protected BufferedOutput() {
    }

    protected abstract void needSpace() throws IOException;

    protected final void checkEOB() {
        if (this.position != this.limit) {
            throw new IllegalStateException(this.position < this.limit ? "buffer has unprocessed data" : "buffer position is beyond limit");
        }
    }

    public final long totalPosition() {
        return this.totalPositionBase + (long)this.position;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.position >= this.limit) {
            this.needSpace();
        }
        this.buffer[this.position++] = (byte)b;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        IOUtil.checkRange(b, off, len);
        while (len > 0) {
            if (this.position >= this.limit) {
                this.needSpace();
            }
            int n = Math.min(len, this.limit - this.position);
            System.arraycopy(b, off, this.buffer, this.position, n);
            this.position += n;
            off += n;
            len -= n;
        }
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        if (this.position >= this.limit) {
            this.needSpace();
        }
        this.buffer[this.position++] = v ? (byte)1 : 0;
    }

    @Override
    public final void writeByte(int v) throws IOException {
        if (this.position >= this.limit) {
            this.needSpace();
        }
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public final void writeShort(int v) throws IOException {
        if (this.limit - this.position < 2) {
            this.writeByte(v >>> 8);
            this.writeByte(v);
            return;
        }
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public final void writeChar(int v) throws IOException {
        if (this.limit - this.position < 2) {
            this.writeByte(v >>> 8);
            this.writeByte(v);
            return;
        }
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public final void writeInt(int v) throws IOException {
        if (this.limit - this.position < 4) {
            this.writeShort(v >>> 16);
            this.writeShort(v);
            return;
        }
        this.buffer[this.position++] = (byte)(v >>> 24);
        this.buffer[this.position++] = (byte)(v >>> 16);
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public final void writeLong(long v) throws IOException {
        if (this.limit - this.position < 8) {
            this.writeInt((int)(v >>> 32));
            this.writeInt((int)v);
            return;
        }
        this.buffer[this.position++] = (byte)(v >>> 56);
        this.buffer[this.position++] = (byte)(v >>> 48);
        this.buffer[this.position++] = (byte)(v >>> 40);
        this.buffer[this.position++] = (byte)(v >>> 32);
        this.buffer[this.position++] = (byte)(v >>> 24);
        this.buffer[this.position++] = (byte)(v >>> 16);
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(str.charAt(i));
        }
    }

    @Override
    public final void writeChars(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(str.charAt(i));
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int i;
        int len = str.length();
        int utfLen = 0;
        for (i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c <= '\u07ff') {
                utfLen += 2;
                continue;
            }
            utfLen += 3;
        }
        if (utfLen < len || utfLen > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utfLen);
        for (i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                this.writeByte(c);
                continue;
            }
            if (c <= '\u07ff') {
                this.writeUTF2Unchecked(c);
                continue;
            }
            this.writeUTF3Unchecked(c);
        }
    }

    @Override
    public final void writeObject(Object obj) throws IOException {
        IOUtil.writeObject(this, obj);
    }

    public final void writeMarshalled(Marshalled<?> marshalled) throws IOException {
        Marshaller<?> marshaller = marshalled.getMarshaller();
        byte[] bytes = marshalled.getBytes();
        if (bytes == null) {
            marshaller.writeMarshalledLength(this, -1);
            return;
        }
        marshaller.writeMarshalledLength(this, bytes.length);
        this.write(bytes);
    }

    public final void writeCompactInt(int v) throws IOException {
        if (v >= 0) {
            if (v < 64) {
                this.writeByte(v);
            } else if (v < 8192) {
                this.writeShort(0x8000 | v);
            } else if (v < 0x100000) {
                this.writeByte(0xC0 | v >> 16);
                this.writeShort(v);
            } else if (v < 0x8000000) {
                this.writeInt(0xE0000000 | v);
            } else {
                this.writeByte(240);
                this.writeInt(v);
            }
        } else if (v >= -64) {
            this.writeByte(0x7F & v);
        } else if (v >= -8192) {
            this.writeShort(0xBFFF & v);
        } else if (v >= -1048576) {
            this.writeByte(0xDF & v >> 16);
            this.writeShort(v);
        } else if (v >= -134217728) {
            this.writeInt(0xEFFFFFFF & v);
        } else {
            this.writeByte(247);
            this.writeInt(v);
        }
    }

    public final void writeCompactLong(long v) throws IOException {
        if (v == (long)((int)v)) {
            this.writeCompactInt((int)v);
            return;
        }
        int hi = (int)(v >>> 32);
        if (hi >= 0) {
            if (hi < 4) {
                this.writeByte(0xF0 | hi);
            } else if (hi < 512) {
                this.writeShort(0xF800 | hi);
            } else if (hi < 65536) {
                this.writeByte(252);
                this.writeShort(hi);
            } else if (hi < 0x800000) {
                this.writeInt(0xFE000000 | hi);
            } else {
                this.writeByte(255);
                this.writeInt(hi);
            }
        } else if (hi >= -4) {
            this.writeByte(0xF7 & hi);
        } else if (hi >= -512) {
            this.writeShort(0xFBFF & hi);
        } else if (hi >= -65536) {
            this.writeByte(253);
            this.writeShort(hi);
        } else if (hi >= -8388608) {
            this.writeInt(0xFEFFFFFF & hi);
        } else {
            this.writeByte(255);
            this.writeInt(hi);
        }
        this.writeInt((int)v);
    }

    public final void writeByteArray(byte[] bytes) throws IOException {
        if (bytes == null) {
            this.writeCompactInt(-1);
            return;
        }
        this.writeCompactInt(bytes.length);
        this.write(bytes);
    }

    public final void writeUTFChar(int codePoint) throws IOException {
        if (codePoint < 0) {
            throw new UTFDataFormatException();
        }
        if (codePoint <= 127) {
            this.writeByte(codePoint);
        } else if (codePoint <= 2047) {
            this.writeUTF2Unchecked(codePoint);
        } else if (codePoint <= 65535) {
            this.writeUTF3Unchecked(codePoint);
        } else if (codePoint <= 0x10FFFF) {
            this.writeUTF4Unchecked(codePoint);
        } else {
            throw new UTFDataFormatException();
        }
    }

    public final void writeUTFString(String str) throws IOException {
        char c;
        if (str == null) {
            this.writeCompactInt(-1);
            return;
        }
        int len = str.length();
        long utfLen = 0L;
        int i = 0;
        while (i < len) {
            if ((c = str.charAt(i++)) <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c <= '\u07ff') {
                utfLen += 2L;
                continue;
            }
            if (Character.isHighSurrogate(c) && i < len && Character.isLowSurrogate(str.charAt(i))) {
                ++i;
                utfLen += 4L;
                continue;
            }
            utfLen += 3L;
        }
        this.writeCompactLong(utfLen);
        i = 0;
        while (i < len) {
            if ((c = str.charAt(i++)) <= '\u007f') {
                this.writeByte(c);
                continue;
            }
            if (c <= '\u07ff') {
                this.writeUTF2Unchecked(c);
                continue;
            }
            if (Character.isHighSurrogate(c) && i < len && Character.isLowSurrogate(str.charAt(i))) {
                this.writeUTF4Unchecked(Character.toCodePoint(c, str.charAt(i++)));
                continue;
            }
            this.writeUTF3Unchecked(c);
        }
    }

    public long writeFromInputStream(InputStream in, long length) throws IOException {
        long result = 0L;
        while (result < length) {
            if (this.position >= this.limit) {
                this.needSpace();
            }
            int n = (int)Math.min(length - result, (long)(this.limit - this.position));
            if ((n = in.read(this.buffer, this.position, n)) <= 0) {
                return result;
            }
            result += (long)n;
            this.position += n;
        }
        return result;
    }

    public void writeFromDataInput(DataInput in, long length) throws IOException {
        while (length > 0L) {
            if (this.position >= this.limit) {
                this.needSpace();
            }
            int n = (int)Math.min(length, (long)(this.limit - this.position));
            in.readFully(this.buffer, this.position, n);
            length -= (long)n;
            this.position += n;
        }
    }

    public void writeFromByteBuffer(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            if (this.position >= this.limit) {
                this.needSpace();
            }
            int n = Math.min(buffer.remaining(), this.limit - this.position);
            buffer.get(this.buffer, this.position, n);
            this.position += n;
        }
    }

    public void writeFromChunk(Chunk chunk, Object owner) throws IOException {
        this.write(chunk.getBytes(), chunk.getOffset(), chunk.getLength());
        chunk.recycle(owner);
    }

    public void writeAllFromChunkList(ChunkList chunks, Object owner) throws IOException {
        for (int i = 0; i < chunks.size(); ++i) {
            Chunk chunk = chunks.get(i);
            this.write(chunk.getBytes(), chunk.getOffset(), chunk.getLength());
        }
        chunks.recycle(owner);
    }

    private void writeUTF2Unchecked(int codePoint) throws IOException {
        this.writeShort(0xC080 | codePoint << 2 & 0x1F00 | codePoint & 0x3F);
    }

    private void writeUTF3Unchecked(int codePoint) throws IOException {
        this.writeByte(0xE0 | codePoint >>> 12);
        this.writeShort(0x8080 | codePoint << 2 & 0x3F00 | codePoint & 0x3F);
    }

    private void writeUTF4Unchecked(int codePoint) throws IOException {
        this.writeInt(0xF0808080 | codePoint << 6 & 0x7000000 | codePoint << 4 & 0x3F0000 | codePoint << 2 & 0x3F00 | codePoint & 0x3F);
    }
}

