/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.IOUtil;
import java.io.IOException;

public final class BufferedInputPart
extends BufferedInput {
    private BufferedInput in;
    private int start;
    private long availableSurplus;

    public BufferedInputPart() {
    }

    public BufferedInputPart(BufferedInput in, long length) {
        this.setInput(in, length);
    }

    public void setInput(BufferedInput in, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length=" + length);
        }
        if (in.markPosition < 0L) {
            throw new IllegalStateException("underlying input is not marked");
        }
        this.in = in;
        this.initBuffer(length);
        this.markPosition = -1L;
    }

    public void syncInputPosition() {
        this.in.position = this.position;
    }

    public void resetInput() {
        if (this.in == null) {
            return;
        }
        this.in = null;
        this.buffer = EMPTY_BYTE_ARRAY;
        this.position = 0;
        this.limit = 0;
        this.totalPositionBase = 0L;
        this.markPosition = -1L;
        this.start = 0;
        this.availableSurplus = 0L;
    }

    @Override
    public void close() {
        this.resetInput();
    }

    @Override
    public boolean hasAvailable() throws IOException {
        if (this.position < this.limit) {
            return true;
        }
        if (this.availableSurplus > 0L) {
            this.syncInputPosition();
            if (this.in.hasAvailable()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAvailable(int bytes) throws IOException {
        if (this.limit - this.position >= bytes) {
            return true;
        }
        if ((long)(this.limit - this.position) + this.availableSurplus < (long)bytes) {
            return false;
        }
        this.syncInputPosition();
        return this.in.hasAvailable(bytes);
    }

    @Override
    public int available() throws IOException {
        if (this.availableSurplus == 0L) {
            return this.limit - this.position;
        }
        this.syncInputPosition();
        return (int)Math.min((long)this.in.available(), (long)(this.limit - this.position) + this.availableSurplus);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IOUtil.checkRange(b, off, len);
        if (len == 0) {
            return 0;
        }
        if (len <= this.limit - this.position) {
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position += len;
            return len;
        }
        long available = (long)(this.limit - this.position) + this.availableSurplus;
        if (available == 0L) {
            return -1;
        }
        this.syncInputPosition();
        int result = this.in.read(b, off, (int)Math.min((long)len, available));
        this.initBuffer(available - (long)Math.max(result, 0));
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long available = (long)(this.limit - this.position) + this.availableSurplus;
        if ((n = Math.min(n, available)) <= (long)(this.limit - this.position)) {
            this.position = (int)((long)this.position + n);
        } else {
            this.syncInputPosition();
            n = this.in.skip(n);
            this.initBuffer(available - n);
        }
        return n;
    }

    @Override
    public void rewind(long n) {
        this.checkRewind(n);
        if (n <= (long)(this.position - this.start)) {
            this.position = (int)((long)this.position - n);
        } else {
            long available = (long)(this.limit - this.position) + this.availableSurplus;
            this.syncInputPosition();
            this.in.rewind(n);
            this.initBuffer(available + n);
        }
    }

    @Override
    protected int readData() throws IOException {
        this.checkEOB();
        if (this.availableSurplus <= 0L) {
            return -1;
        }
        this.syncInputPosition();
        int result = this.in.readData();
        this.initBuffer(this.availableSurplus);
        return result;
    }

    @Override
    protected void checkEncapsulatedLength(long length, long min, long max) throws IOException {
        if (length < min || length > max || length > (long)(this.limit - this.position) + this.availableSurplus) {
            throw new IOException("Illegal length: " + length);
        }
    }

    private void initBuffer(long length) {
        this.buffer = this.in.buffer;
        this.position = this.in.position;
        this.limit = (long)(this.in.limit - this.position) < length ? this.in.limit : (int)((long)this.position + length);
        this.start = this.position;
        this.availableSurplus = length + (long)this.position - (long)this.limit;
        this.totalPositionBase = this.in.totalPositionBase;
    }
}

