/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.io.SerialClassContext;
import com.devexperts.util.ArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public abstract class BufferedInput
extends InputStream
implements ObjectInput {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected byte[] buffer = EMPTY_BYTE_ARRAY;
    protected int position;
    protected int limit;
    protected long totalPositionBase;
    protected long markPosition = -1L;
    private static final EOFException EOF_EXCEPTION = new EOFException("End of buffer.");
    private char[] charBuffer;

    protected BufferedInput() {
    }

    protected void needData() throws IOException {
        if (this.position >= this.limit && this.readData() <= 0) {
            this.throwEOFException();
        }
    }

    protected abstract int readData() throws IOException;

    protected void throwEOFException() throws EOFException {
        throw EOF_EXCEPTION;
    }

    protected final void checkEOB() {
        if (this.position != this.limit) {
            throw new IllegalStateException(this.position < this.limit ? "buffer has unprocessed data" : "buffer position is beyond limit");
        }
    }

    protected void checkEncapsulatedLength(long length, long min, long max) throws IOException {
        if (length < min || length > max) {
            throw new IOException("Illegal length: " + length);
        }
    }

    @Override
    public final int read() throws IOException {
        if (this.position >= this.limit && this.readData() <= 0) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IOUtil.checkRange(b, off, len);
        if (len == 0) {
            return 0;
        }
        if (this.position >= this.limit && this.readData() <= 0) {
            return -1;
        }
        len = Math.min(len, this.limit - this.position);
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining;
        int skipping;
        for (remaining = n; remaining > 0L && (this.position < this.limit || this.readData() > 0); remaining -= (long)skipping) {
            skipping = (int)Math.min(remaining, (long)(this.limit - this.position));
            this.position += skipping;
        }
        return n - remaining;
    }

    public boolean hasAvailable() throws IOException {
        return this.hasAvailable(1);
    }

    public boolean hasAvailable(int bytes) throws IOException {
        return this.available() >= bytes;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        IOUtil.checkRange(b, off, len);
        while (len > 0) {
            int n = this.read(b, off, len);
            if (n <= 0) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        if (this.position >= this.limit) {
            this.needData();
        }
        return this.buffer[this.position++] != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.position >= this.limit) {
            this.needData();
        }
        return this.buffer[this.position++];
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        if (this.position >= this.limit) {
            this.needData();
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        if (this.limit - this.position < 2) {
            return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }
        return (short)(this.buffer[this.position++] << 8 | this.buffer[this.position++] & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.limit - this.position < 2) {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }
        return (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        if (this.limit - this.position < 2) {
            return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }
        return (char)(this.buffer[this.position++] << 8 | this.buffer[this.position++] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        if (this.limit - this.position < 4) {
            return this.readUnsignedShort() << 16 | this.readUnsignedShort();
        }
        return this.buffer[this.position++] << 24 | (this.buffer[this.position++] & 0xFF) << 16 | (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        if (this.limit - this.position < 8) {
            return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        return ((long)this.buffer[this.position++] & 0xFFL) << 56 | ((long)this.buffer[this.position++] & 0xFFL) << 48 | ((long)this.buffer[this.position++] & 0xFFL) << 40 | ((long)this.buffer[this.position++] & 0xFFL) << 32 | ((long)this.buffer[this.position++] & 0xFFL) << 24 | ((long)this.buffer[this.position++] & 0xFFL) << 16 | ((long)this.buffer[this.position++] & 0xFFL) << 8 | (long)this.buffer[this.position++] & 0xFFL;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        int c;
        if (this.position >= this.limit && this.readData() <= 0) {
            return null;
        }
        char[] chars = this.getCharBuffer(128);
        int count = 0;
        while ((this.position < this.limit || this.readData() > 0) && (c = this.buffer[this.position++] & 0xFF) != 10) {
            if (c == 13) {
                if (this.position >= this.limit && this.readData() <= 0 || this.buffer[this.position] != 10) break;
                ++this.position;
                break;
            }
            if (count >= chars.length) {
                chars = ArrayUtil.grow(chars, 0);
            }
            chars[count++] = (char)c;
            if (count < Integer.MAX_VALUE) continue;
            break;
        }
        return new String(chars, 0, count);
    }

    @Override
    public final String readUTF() throws IOException {
        int utfLen = this.readUnsignedShort();
        if (utfLen == 0) {
            return "";
        }
        this.checkEncapsulatedLength(utfLen, 0L, Integer.MAX_VALUE);
        char[] chars = this.getCharBuffer(utfLen);
        return String.valueOf(chars, 0, this.readUTFBody(utfLen, chars, 0));
    }

    @Override
    public final Object readObject() throws IOException {
        return IOUtil.readObject(this);
    }

    public final Object readObject(ClassLoader cl) throws IOException {
        return IOUtil.readObject((DataInput)this, cl);
    }

    public final Object readObject(SerialClassContext serialContext) throws IOException {
        return IOUtil.readObject((DataInput)this, serialContext);
    }

    public final <T> Marshalled<T> readMarshalled(Marshaller<T> marshaller) throws IOException {
        return this.readMarshalled(marshaller, SerialClassContext.getDefaultSerialContext(null));
    }

    public final <T> Marshalled<T> readMarshalled(Marshaller<T> marshaller, SerialClassContext serialContext) throws IOException {
        long length = marshaller.readMarshalledLength(this);
        this.checkEncapsulatedLength(length, -1L, Integer.MAX_VALUE);
        if (serialContext == null) {
            serialContext = SerialClassContext.getDefaultSerialContext(null);
        }
        if (length == -1L) {
            return Marshalled.forBytes(null, marshaller, serialContext);
        }
        if (length == 0L) {
            return Marshalled.forBytes(EMPTY_BYTE_ARRAY, marshaller, serialContext);
        }
        byte[] bytes = new byte[(int)length];
        this.readFully(bytes);
        return Marshalled.forBytes(bytes, marshaller, serialContext);
    }

    public final int readCompactInt() throws IOException {
        int n = this.readUnsignedByte();
        if (n < 128) {
            return n << 25 >> 25;
        }
        if (n < 192) {
            return (n << 8 | this.readUnsignedByte()) << 18 >> 18;
        }
        if (n < 224) {
            return (n << 16 | this.readUnsignedShort()) << 11 >> 11;
        }
        if (n < 240) {
            return (n << 24 | this.readUnsignedByte() << 16 | this.readUnsignedShort()) << 4 >> 4;
        }
        while (((n <<= 1) & 0x10) != 0) {
            this.readUnsignedByte();
        }
        return this.readInt();
    }

    public final long readCompactLong() throws IOException {
        int n = this.readUnsignedByte();
        if (n < 128) {
            return n << 25 >> 25;
        }
        if (n < 192) {
            return (n << 8 | this.readUnsignedByte()) << 18 >> 18;
        }
        if (n < 224) {
            return (n << 16 | this.readUnsignedShort()) << 11 >> 11;
        }
        if (n < 240) {
            return (n << 24 | this.readUnsignedByte() << 16 | this.readUnsignedShort()) << 4 >> 4;
        }
        n = n < 248 ? n << 29 >> 29 : (n < 252 ? (n << 8 | this.readUnsignedByte()) << 22 >> 22 : (n < 254 ? (n << 16 | this.readUnsignedShort()) << 15 >> 15 : (n < 255 ? this.readByte() << 16 | this.readUnsignedShort() : this.readInt())));
        return (long)n << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final byte[] readByteArray() throws IOException {
        long length = this.readCompactLong();
        this.checkEncapsulatedLength(length, -1L, Integer.MAX_VALUE);
        if (length == -1L) {
            return null;
        }
        if (length == 0L) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[(int)length];
        this.readFully(bytes);
        return bytes;
    }

    public final int readUTFChar() throws IOException {
        byte c = this.readByte();
        if (c >= 0) {
            return (char)c;
        }
        if ((c & 0xE0) == 192) {
            return this.readUTF2(c);
        }
        if ((c & 0xF0) == 224) {
            return this.readUTF3(c);
        }
        if ((c & 0xF8) == 240) {
            return this.readUTF4(c);
        }
        throw new UTFDataFormatException();
    }

    public final String readUTFString() throws IOException {
        long utfLen = this.readCompactLong();
        this.checkEncapsulatedLength(utfLen, -1L, 0x1FFFFFFFCL);
        if (utfLen == -1L) {
            return null;
        }
        if (utfLen == 0L) {
            return "";
        }
        char[] chars = this.getCharBuffer((int)Math.min(utfLen, Integer.MAX_VALUE));
        return String.valueOf(chars, 0, this.readUTFBody(utfLen, chars, 0));
    }

    public final int readUTFBody(long utfLength, char[] chars, int offset) throws IOException {
        int index = offset;
        while (utfLength > 0L) {
            byte c = this.readByte();
            if (c >= 0) {
                --utfLength;
                chars[index++] = (char)c;
                continue;
            }
            if ((c & 0xE0) == 192) {
                utfLength -= 2L;
                chars[index++] = this.readUTF2(c);
                continue;
            }
            if ((c & 0xF0) == 224) {
                utfLength -= 3L;
                chars[index++] = this.readUTF3(c);
                continue;
            }
            if ((c & 0xF8) == 240) {
                utfLength -= 4L;
                index += Character.toChars(this.readUTF4(c), chars, index);
                continue;
            }
            throw new UTFDataFormatException();
        }
        if (utfLength < 0L) {
            throw new UTFDataFormatException();
        }
        return index - offset;
    }

    public final long totalPosition() {
        return this.totalPositionBase + (long)this.position;
    }

    public final void seek(long totalPosition) throws IOException {
        if (totalPosition < 0L) {
            throw new IllegalArgumentException();
        }
        long n = totalPosition - this.totalPosition();
        if (n < 0L) {
            this.rewind(-n);
        }
        while (n > 0L) {
            long skipped = this.skip(n);
            if (skipped <= 0L) {
                throw new EOFException();
            }
            n -= skipped;
        }
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    public void mark() {
        this.markPosition = this.totalPosition();
    }

    public void unmark() {
        this.markPosition = -1L;
    }

    @Override
    public final void mark(int readLimit) {
        this.mark((long)readLimit);
    }

    public final void mark(long readLimit) {
        if (readLimit >= 0L) {
            this.mark();
        } else {
            this.unmark();
        }
    }

    @Override
    public final void reset() throws IllegalStateException {
        if (this.markPosition < 0L) {
            throw new IllegalStateException("mark is invalid");
        }
        this.rewind(this.totalPosition() - this.markPosition);
    }

    public abstract void rewind(long var1) throws IllegalStateException;

    protected final void checkRewind(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n is negative");
        }
        if (this.markPosition < 0L) {
            throw new IllegalStateException("mark is invalid");
        }
        if (n > this.totalPosition() - this.markPosition) {
            throw new IllegalStateException("cannot rewind past mark");
        }
    }

    public long readToOutputStream(OutputStream out, long length) throws IOException {
        long result;
        int n;
        for (result = 0L; result < length; result += (long)n) {
            if (this.position >= this.limit && this.readData() <= 0) {
                return result;
            }
            n = (int)Math.min(length - result, (long)(this.limit - this.position));
            out.write(this.buffer, this.position, n);
            this.position += n;
        }
        return result;
    }

    public long readToDataOutput(DataOutput out, long length) throws IOException {
        long result;
        int n;
        for (result = 0L; result < length; result += (long)n) {
            if (this.position >= this.limit && this.readData() <= 0) {
                return result;
            }
            n = (int)Math.min(length - result, (long)(this.limit - this.position));
            out.write(this.buffer, this.position, n);
            this.position += n;
        }
        return result;
    }

    public void readToByteBuffer(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            if (this.position >= this.limit && this.readData() <= 0) {
                return;
            }
            int n = Math.min(buffer.remaining(), this.limit - this.position);
            buffer.put(this.buffer, this.position, n);
            this.position += n;
        }
    }

    @Deprecated
    boolean readToCaptureBytes(CaptureBytes out, int length) {
        if (length <= this.limit - this.position) {
            out.captureBytes(this.buffer, this.position, length);
            this.position += length;
            return true;
        }
        return false;
    }

    private char[] getCharBuffer(int capacity) {
        if (capacity > 256) {
            return new char[capacity];
        }
        return this.charBuffer != null ? this.charBuffer : (this.charBuffer = new char[256]);
    }

    private char readUTF2(int first) throws IOException {
        byte second = this.readByte();
        if ((second & 0xC0) != 128) {
            throw new UTFDataFormatException();
        }
        return (char)((first & 0x1F) << 6 | second & 0x3F);
    }

    private char readUTF3(int first) throws IOException {
        short tail = this.readShort();
        if ((tail & 0xC0C0) != 32896) {
            throw new UTFDataFormatException();
        }
        return (char)((first & 0xF) << 12 | (tail & 0x3F00) >> 2 | tail & 0x3F);
    }

    private int readUTF4(int first) throws IOException {
        byte second = this.readByte();
        short tail = this.readShort();
        if ((second & 0xC0) != 128 || (tail & 0xC0C0) != 32896) {
            throw new UTFDataFormatException();
        }
        int codePoint = (first & 7) << 18 | (second & 0x3F) << 12 | (tail & 0x3F00) >> 2 | tail & 0x3F;
        if (codePoint > 0x10FFFF) {
            throw new UTFDataFormatException();
        }
        return codePoint;
    }

    static {
        if (EOF_EXCEPTION.getStackTrace().length > 1) {
            EOF_EXCEPTION.setStackTrace(new StackTraceElement[]{EOF_EXCEPTION.getStackTrace()[0]});
        }
    }

    @Deprecated
    static interface CaptureBytes {
        public void captureBytes(byte[] var1, int var2, int var3);
    }
}

