/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.internal.transport;

import com.fxcm.messaging.util.HostReader;
import com.fxcm.messaging.util.web.HttpParameter;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.Vector;

public class SSOHelper
extends HostReader {
    public SSOHelper(Properties aProperties) {
        this.setProxyParameters(aProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyServer"), (int)this.getLongProperty(aProperties, "com.fxcm.messaging.IConnectionManager.ProxyPort", 80L), aProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyUserID"), aProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyPassword"), this.getBooleanProperty(aProperties, "com.fxcm.messaging.IConnectionManager.ProxyHTTP11", false));
    }

    public String retrieveHostsXML(String aHostDescriptorURL, String aTerminal, String aSAMLAssertion, String aStationName) {
        Vector<HttpParameter> params = new Vector<HttpParameter>();
        params.add(new HttpParameter("ID", String.valueOf(System.currentTimeMillis())));
        params.add(new HttpParameter("MV", "4"));
        params.add(new HttpParameter("AT", "SAML"));
        params.add(new HttpParameter("DATA", URLEncoder.encode(aSAMLAssertion)));
        params.add(new HttpParameter("PN", aTerminal));
        params.add(new HttpParameter("SN", aStationName != null ? aStationName : ""));
        return this.getHttpContent(aHostDescriptorURL, params, true);
    }

    protected long getLongProperty(Properties aProperties, String aName, long aDefault) {
        long ret = aDefault;
        String res = aProperties.getProperty(aName);
        if (res != null && res.length() > 0) {
            try {
                ret = Long.parseLong(res);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected boolean getBooleanProperty(Properties aProperties, String aName, boolean aDefault) {
        boolean ret = aDefault;
        String res = aProperties.getProperty(aName);
        if (res != null && res.length() > 0) {
            ret = "true".equals(res);
        }
        return ret;
    }
}

