/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.internal.transport;

import com.fxcm.GenericException;
import com.fxcm.external.api.transport.FXCMLoginProperties;
import com.fxcm.external.api.transport.IGateway;
import com.fxcm.external.api.transport.exception.SessionNotEstablishedException;
import com.fxcm.external.api.transport.listeners.IGenericMessageListener;
import com.fxcm.external.api.transport.listeners.IStatusMessageListener;
import com.fxcm.external.api.transport.sso.SSOLoginProperties;
import com.fxcm.external.api.util.OrdStatusRequestType;
import com.fxcm.fix.PosReqTypeFactory;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.custom.BatchRequest;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.fix.other.UserRequest;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.fix.posttrade.CollateralInquiry;
import com.fxcm.fix.posttrade.RequestForPositions;
import com.fxcm.fix.pretrade.MarketDataRequest;
import com.fxcm.fix.pretrade.QuoteRequest;
import com.fxcm.fix.pretrade.QuoteResponse;
import com.fxcm.fix.pretrade.SecurityListRequest;
import com.fxcm.fix.pretrade.SecurityStatusRequest;
import com.fxcm.fix.pretrade.TradingSessionStatusRequest;
import com.fxcm.fix.trade.OrderCancelReplaceRequest;
import com.fxcm.fix.trade.OrderCancelRequest;
import com.fxcm.fix.trade.OrderList;
import com.fxcm.fix.trade.OrderMassStatusRequest;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.fix.trade.OrderStatusRequest;
import com.fxcm.internal.transport.SSOHelper;
import com.fxcm.messaging.ConnectionManagerEx;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.ISessionStatus;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.IUserSession;
import com.fxcm.messaging.IUserSessionStatusListener;
import com.fxcm.messaging.IUserTransportableListener;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.IConnectionManager;
import com.fxcm.messaging.util.fix.FIXConnectionManager;
import com.fxcm.messaging.util.fix.FIXUserSession;
import com.fxcm.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FXCMGateway
implements IUserTransportableListener,
IUserSessionStatusListener,
IGateway {
    private static final int WAIT_RESPONSE_TO = 180000;
    private final List<IGenericMessageListener> mGenericMessageListeners;
    private boolean mLoggedIn;
    private final Log mLogger = LogFactory.getLog(FXCMGateway.class);
    private IUserSession mPriceSession;
    private FXCMLoginProperties mProps;
    private final List<IStatusMessageListener> mStatusMessageListeners;
    private boolean mTradingSessionRetrieved;
    private final TransportMutex mTransportMutex;
    private IUserSession mUserSession;

    public FXCMGateway() {
        this.mGenericMessageListeners = new ArrayList<IGenericMessageListener>();
        this.mStatusMessageListeners = new ArrayList<IStatusMessageListener>();
        this.mTransportMutex = new TransportMutex();
    }

    private void close(IUserSession aUserSession) {
        if (aUserSession != null) {
            try {
                aUserSession.close();
            }
            catch (GenericException e) {
                this.mLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (this.mUserSession == aUserSession) {
                this.mUserSession = null;
            } else if (this.mPriceSession == aUserSession) {
                this.mPriceSession = null;
            }
            aUserSession.removeMessageListener((IUserTransportableListener)this);
            aUserSession.removeSessionStatusListener((IUserSessionStatusListener)this);
            ConnectionManagerEx.cleanup((IUserSession)aUserSession);
        }
    }

    private String configure() throws IOException {
        this.mProps.addProperty("com.fxcm.messaging.IConnectionManager.ClassName", "com.fxcm.messaging.util.fix.FIXConnectionManager");
        ConnectionManagerEx.init((Properties)this.mProps.getProperties());
        return this.getAppInfo();
    }

    private void fillExtraFields(ITransportable aTransportable) throws GenericException {
        String nextRequestID = aTransportable.getRequestID();
        if (nextRequestID == null) {
            nextRequestID = this.mUserSession.getNextRequestID();
        }
        if (aTransportable instanceof QuoteRequest) {
            ((QuoteRequest)aTransportable).setQuoteReqID(nextRequestID);
            ((QuoteRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((QuoteRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof OrderCancelReplaceRequest) {
            ((OrderCancelReplaceRequest)aTransportable).setClOrdID(nextRequestID);
            ((OrderCancelReplaceRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((OrderCancelReplaceRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof OrderCancelRequest) {
            ((OrderCancelRequest)aTransportable).setClOrdID(nextRequestID);
            ((OrderCancelRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((OrderCancelRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof OrderSingle) {
            ((OrderSingle)aTransportable).setClOrdID(nextRequestID);
            ((OrderSingle)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((OrderSingle)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof OrderMassStatusRequest) {
            ((OrderMassStatusRequest)aTransportable).setMassStatusReqID(nextRequestID);
            ((OrderMassStatusRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((OrderMassStatusRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof RequestForPositions) {
            ((RequestForPositions)aTransportable).setPosReqID(nextRequestID);
            ((RequestForPositions)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((RequestForPositions)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof CollateralInquiry) {
            ((CollateralInquiry)aTransportable).setCollInquiryID(nextRequestID);
            ((CollateralInquiry)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((CollateralInquiry)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof TradingSessionStatusRequest) {
            ((TradingSessionStatusRequest)aTransportable).setTradSesReqID(nextRequestID);
            ((TradingSessionStatusRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((TradingSessionStatusRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof OrderStatusRequest) {
            ((OrderStatusRequest)aTransportable).setOrderStatusReqID(nextRequestID);
            ((OrderStatusRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((OrderStatusRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof QuoteResponse) {
            ((QuoteResponse)aTransportable).setQuoteRespID(nextRequestID);
            ((QuoteResponse)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((QuoteResponse)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof SecurityStatusRequest) {
            ((SecurityStatusRequest)aTransportable).setSecurityStatusReqID(nextRequestID);
            ((SecurityStatusRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((SecurityStatusRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof SecurityListRequest) {
            ((SecurityListRequest)aTransportable).setSecurityReqID(nextRequestID);
            ((SecurityListRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((SecurityListRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof MarketDataRequest) {
            ((MarketDataRequest)aTransportable).setMDReqID(nextRequestID);
            ((MarketDataRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((MarketDataRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof OrderList) {
            OrderSingle[] orders;
            OrderList orderList = (OrderList)aTransportable;
            orderList.setTradingSessionID(this.mUserSession.getTradingSession().getID());
            orderList.setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
            orderList.setListID(nextRequestID);
            for (OrderSingle order : orders = orderList.getOrders()) {
                order.setClOrdID(this.mUserSession.getNextRequestID());
                order.setTradingSessionID(this.mUserSession.getTradingSession().getID());
                order.setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
            }
        } else if (aTransportable instanceof UserRequest) {
            ((UserRequest)aTransportable).setUserRequestID(nextRequestID);
            ((UserRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((UserRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof FXCMRequest) {
            ((FXCMRequest)aTransportable).setTestReqID(nextRequestID);
            ((FXCMRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((FXCMRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else if (aTransportable instanceof BatchRequest) {
            ((BatchRequest)aTransportable).setMDReqID(nextRequestID);
            ((BatchRequest)aTransportable).setTradingSessionID(this.mUserSession.getTradingSession().getID());
            ((BatchRequest)aTransportable).setTradingSessionSubID(this.mUserSession.getTradingSession().getSubID());
        } else {
            this.mLogger.error((Object)("UNKNOWN TYPE: CAN'T FILL EXTRA INFO: " + aTransportable));
        }
    }

    @Override
    public ISessionStatus getCurrentStatus() {
        try {
            return this.mUserSession.getCurrentStatus();
        }
        catch (Exception e) {
            throw new SessionNotEstablishedException("UserSession not established. Need to Login", e.getCause());
        }
    }

    @Override
    public String getSessionID() {
        try {
            return this.mUserSession.getSessionID();
        }
        catch (Exception e) {
            throw new SessionNotEstablishedException("UserSession not established. Need to Login", e.getCause());
        }
    }

    @Override
    public TradingSessionDesc getTradingSession() {
        try {
            return this.mUserSession.getTradingSession();
        }
        catch (Exception e) {
            throw new SessionNotEstablishedException("UserSession not established. Need to Login", e.getCause());
        }
    }

    @Override
    public TradingSessionDesc[] getTradingSessions(FXCMLoginProperties aProps) throws Exception {
        this.mProps = aProps;
        if (this.mProps != null) {
            String appInfo = this.configure();
            if (aProps instanceof SSOLoginProperties) {
                SSOLoginProperties ssoProps = (SSOLoginProperties)aProps;
                SSOHelper ssoHelper = new SSOHelper(this.mProps.getProperties());
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("retrieve HostsXML from " + ssoProps.getServer()));
                }
                String hostsXML = ssoHelper.retrieveHostsXML(ssoProps.getServer(), ssoProps.getTerminal(), ssoProps.getSAMLAssertion(), appInfo);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Open token = " + ssoProps.getOpenToken()));
                }
                this.mUserSession = ConnectionManagerEx.createUserSessionOpenToken(null, (String)hostsXML, (String)ssoProps.getTerminal(), (String)ssoProps.getServiceName(), (String)ssoProps.getOpenToken(), (String)appInfo);
            } else {
                this.mUserSession = ConnectionManagerEx.createUserSession((String)this.mProps.getServer(), (String)this.mProps.getTerminal(), (String)this.mProps.getServiceName(), (String)this.mProps.getUserName(), (String)this.mProps.getPassword(), (String)appInfo);
            }
            try {
                if (!this.mUserSession.loadStationDescriptor()) {
                    this.close(this.mUserSession);
                    throw new Exception("Problem getting station descriptor");
                }
                return this.getTradingSessionDescs();
            }
            catch (Exception aException) {
                this.close(this.mUserSession);
                throw aException;
            }
        }
        throw new Exception("Received null FXCMLoginProperties");
    }

    @Override
    public int getUserKind() {
        try {
            return this.mUserSession.getUserKind();
        }
        catch (Exception e) {
            throw new SessionNotEstablishedException("UserSession not established. Need to Login", e.getCause());
        }
    }

    @Override
    public boolean isConnected() {
        return this.mUserSession != null && !this.mUserSession.isClosed() && this.mUserSession.isValid();
    }

    @Override
    public void login(FXCMLoginProperties aProps) throws Exception {
        this.mProps = aProps;
        if (this.mProps != null) {
            String appInfo = this.configure();
            this.mUserSession = ConnectionManagerEx.createUserSession((String)this.mProps.getServer(), (String)this.mProps.getTerminal(), (String)this.mProps.getServiceName(), (String)this.mProps.getUserName(), (String)this.mProps.getPassword(), (String)appInfo);
            this.mUserSession.setMessageListener((IUserTransportableListener)this);
            this.mUserSession.setSessionStatusListener((IUserSessionStatusListener)this);
            try {
                if (!this.mUserSession.loadStationDescriptor()) {
                    this.close(this.mUserSession);
                    throw new Exception("Problem getting station descriptor");
                }
                TradingSessionDesc tsds = this.getTradingSessionDescs()[0];
                this.mUserSession.setTradingSession(tsds);
                String extraParams = Util.parseParams((Map)aProps.getProperties());
                if (!this.mUserSession.open(extraParams)) {
                    this.close(this.mUserSession);
                    throw new Exception("Not connected, can't send out initial queries. Could not establish UserSession.");
                }
                String priceTerminal = tsds.getProperty("PRICE_TERMINAL");
                this.openPriceTerminal(priceTerminal);
                this.mLoggedIn = true;
            }
            catch (Exception aException) {
                this.close(this.mUserSession);
                throw aException;
            }
        } else {
            throw new Exception("Received null FXCMLoginProperties");
        }
    }

    @Override
    public void logout() {
        this.mTransportMutex.interruptWaiting();
        this.close(this.mPriceSession);
        this.close(this.mUserSession);
        this.mGenericMessageListeners.clear();
        this.mStatusMessageListeners.clear();
        this.mLoggedIn = false;
    }

    @Override
    public void openSession(TradingSessionDesc aTradingSessionDesc) throws Exception {
        this.openSession(aTradingSessionDesc, null);
    }

    @Override
    public void openSession(TradingSessionDesc aTradingSessionDesc, Properties aProperties) throws Exception {
        if (this.mLoggedIn) {
            throw new Exception("Can not open more than one session at a time.");
        }
        String extraParams = Util.parseParams((Map)aProperties);
        this.mUserSession.setTradingSession(aTradingSessionDesc);
        this.mUserSession.setMessageListener((IUserTransportableListener)this);
        this.mUserSession.setSessionStatusListener((IUserSessionStatusListener)this);
        try {
            if (!this.mUserSession.open(extraParams)) {
                this.close(this.mUserSession);
                throw new Exception("Not connected, can't send out initial queries. Could not establish UserSession.");
            }
            String priceTerminal = aTradingSessionDesc.getProperty("PRICE_TERMINAL");
            this.openPriceTerminal(priceTerminal);
            this.mLoggedIn = true;
        }
        catch (Exception aException) {
            aException.printStackTrace();
            this.close(this.mUserSession);
            throw aException;
        }
    }

    @Override
    public void registerGenericMessageListener(IGenericMessageListener aListener) {
        this.mGenericMessageListeners.add(aListener);
    }

    @Override
    public void registerStatusMessageListener(IStatusMessageListener aListener) {
        this.mStatusMessageListeners.add(aListener);
    }

    @Override
    public void relogin() throws Exception {
        if (this.mProps == null || !this.mLoggedIn) {
            throw new Exception("Not logged in or login properties not available from original login, cannot relogin without logging in first.");
        }
        this.close(this.mPriceSession);
        this.close(this.mUserSession);
        this.mLoggedIn = false;
        this.login(this.mProps);
    }

    @Override
    public void removeGenericMessageListener(IGenericMessageListener aListener) {
        this.mGenericMessageListeners.remove(aListener);
    }

    @Override
    public void removeStatusMessageListener(IStatusMessageListener aListener) {
        this.mStatusMessageListeners.remove(aListener);
    }

    @Override
    public String requestAccountByName(String aAccountName) {
        String reqID = null;
        try {
            CollateralInquiry ci = new CollateralInquiry();
            ci.getParties().setFXCMAcctID(1L);
            ci.setAccount(aAccountName);
            reqID = this.sendMessage((ITransportable)ci);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestAccounts() {
        String reqID = null;
        try {
            reqID = this.sendMessage((ITransportable)new CollateralInquiry());
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestAccounts(String aLoginID) {
        String reqID = null;
        try {
            CollateralInquiry ci = new CollateralInquiry();
            if (aLoginID != null) {
                ci.getParties().setFXCMTraderLoginId(aLoginID);
            }
            reqID = this.sendMessage((ITransportable)ci);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestAccounts(long aFXCMAcctID) {
        String reqID = null;
        try {
            CollateralInquiry ci = new CollateralInquiry();
            ci.getParties().setFXCMAcctID(aFXCMAcctID);
            reqID = this.sendMessage((ITransportable)ci);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestClosedPositions() {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setPosReqType(PosReqTypeFactory.TRADES);
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestClosedPositions(String aLoginID) {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setPosReqType(PosReqTypeFactory.TRADES);
            if (aLoginID != null) {
                message.getParties().setFXCMTraderLoginId(aLoginID);
            }
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestClosedPositions(long aFXCMAcctID) {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setPosReqType(PosReqTypeFactory.TRADES);
            message.getParties().setFXCMAcctID(aFXCMAcctID);
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestClosedPositions(int aFXCMMaxNoResults, UTCDate aFXCMStartDate, UTCTimeOnly aFXCMStartTime, UTCDate aFXCMEndDate, UTCTimeOnly aFXCMEndTime) {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setFXCMMaxNoResults(aFXCMMaxNoResults);
            message.setFXCMStartDate(aFXCMStartDate);
            message.setFXCMStartTime(aFXCMStartTime);
            message.setFXCMEndDate(aFXCMEndDate);
            message.setFXCMEndTime(aFXCMEndTime);
            message.setPosReqType(PosReqTypeFactory.TRADES);
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOpenOrders() {
        String reqID = null;
        try {
            reqID = this.sendMessage((ITransportable)new OrderMassStatusRequest());
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOpenOrders(String aLoginID) {
        String reqID = null;
        try {
            OrderMassStatusRequest omsr = new OrderMassStatusRequest();
            if (aLoginID != null) {
                omsr.getParties().setFXCMTraderLoginId(aLoginID);
            }
            reqID = this.sendMessage((ITransportable)omsr);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOpenOrders(long aFXCMAcctID) {
        String reqID = null;
        try {
            OrderMassStatusRequest omsr = new OrderMassStatusRequest();
            omsr.getParties().setFXCMAcctID(aFXCMAcctID);
            reqID = this.sendMessage((ITransportable)omsr);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOpenPositions() {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setPosReqType(PosReqTypeFactory.POSITIONS);
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOpenPositions(String aLoginID) {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setPosReqType(PosReqTypeFactory.POSITIONS);
            if (aLoginID != null) {
                message.getParties().setFXCMTraderLoginId(aLoginID);
            }
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOpenPositions(long aFXCMAcctID) {
        String reqID = null;
        try {
            RequestForPositions message = new RequestForPositions();
            message.setPosReqType(PosReqTypeFactory.POSITIONS);
            message.getParties().setFXCMAcctID(aFXCMAcctID);
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestOrderStatus(String aId, OrdStatusRequestType aOrdStatusRequestType, String aAccount) {
        String reqID = null;
        try {
            OrderStatusRequest message = new OrderStatusRequest();
            if (aOrdStatusRequestType == OrdStatusRequestType.ORDERID) {
                message.setOrderID(aId);
            } else if (aOrdStatusRequestType == OrdStatusRequestType.CLORDID) {
                message.setClOrdID(aId);
            } else if (aOrdStatusRequestType == OrdStatusRequestType.SECONDARYCLORDID) {
                message.setSecondaryClOrdID(aId);
            }
            message.setAccount(aAccount);
            reqID = this.sendMessage((ITransportable)message);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String requestTradingSessionStatus() {
        String reqID = null;
        try {
            this.mTradingSessionRetrieved = true;
            TradingSessionStatusRequest tsr = new TradingSessionStatusRequest();
            reqID = this.sendMessage((ITransportable)tsr);
        }
        catch (Exception e) {
            this.mLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return reqID;
    }

    @Override
    public String sendMessage(ITransportable aTransportable) throws Exception {
        this.fillExtraFields(aTransportable);
        IMessage msg = aTransportable.toMessage(this.mUserSession.getSessionID(), this.mUserSession.getMessageFactory());
        this.mUserSession.send(msg);
        return aTransportable.getRequestID();
    }

    @Override
    public void setMsgFlags(long aMsgFlags) throws SessionNotEstablishedException {
        if (this.mUserSession == null || !this.mLoggedIn) {
            throw new SessionNotEstablishedException("UserSession not established. Need to Login");
        }
        this.mUserSession.setMsgFlags(aMsgFlags);
        if (this.mPriceSession != null) {
            this.mPriceSession.setMsgFlags(aMsgFlags);
        }
    }

    private TradingSessionDesc[] getTradingSessionDescs() throws Exception {
        TradingSessionDesc[] tsds;
        try {
            tsds = this.mUserSession.retrieveTradingSessions();
        }
        catch (GenericException aException) {
            this.close(this.mUserSession);
            throw aException;
        }
        if (tsds == null || tsds.length == 0) {
            this.close(this.mUserSession);
            throw new Exception("Problem retrieving trading session");
        }
        return tsds;
    }

    private boolean openPriceTerminal(String priceTerminal) throws Exception {
        boolean ret = true;
        String appInfo = this.getAppInfo();
        UserRequest ur = new UserRequest();
        ur.setUserRequestType(9);
        ur.setParam("aRemoteAppCode", appInfo);
        ur.setUserRequestID(this.mUserSession.getNextRequestID());
        UserResponse resp = (UserResponse)this.sendRequestAndWaitResponse((ITransportable)ur, ur.getRequestID());
        String ssoToken = resp.getUserStatusText();
        this.mPriceSession = ssoToken != null ? ConnectionManagerEx.createUserSessionSso((String)this.mProps.getServer(), null, (String)priceTerminal, null, (String)this.mProps.getUserName(), (String)ssoToken, (String)appInfo, (IConnectionManager)new FIXConnectionManager()) : ConnectionManagerEx.createUserSession((String)this.mProps.getServer(), (String)priceTerminal, null, null, (String)appInfo);
        this.mPriceSession.setMsgFlags(0L);
        if (!this.mPriceSession.loadStationDescriptor()) {
            throw new GenericException("Problem getting station descriptor for price session");
        }
        ((FIXUserSession)this.mPriceSession).setTransmitTradingSession(this.getTradingSession());
        if (ssoToken != null) {
            ret = this.mPriceSession.open("SID=" + this.getSessionID());
        } else {
            this.mPriceSession.attach(this.getSessionID(), null);
        }
        this.mPriceSession.setMessageListener((IUserTransportableListener)this);
        this.mPriceSession.setSessionStatusListener((IUserSessionStatusListener)this);
        return ret;
    }

    private String getAppInfo() throws IOException {
        String appInfo = this.mProps.getProperties().getProperty("com.fxcm.messaging.IConnectionManager.AppInfo");
        try {
            if (appInfo == null) {
                appInfo = new Exception().getStackTrace()[1].getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITransportable sendRequestAndWaitResponse(ITransportable aRequest, String aReqID) throws Exception {
        TransportMutex transportMutex = this.mTransportMutex;
        synchronized (transportMutex) {
            try {
                if (this.mTransportMutex.getRequestID() != null) {
                    ITransportable iTransportable = null;
                    return iTransportable;
                }
                this.mTransportMutex.setRequestID(aReqID);
                this.mTransportMutex.setResponse(null);
                this.mTransportMutex.setWaitingThread(Thread.currentThread());
                this.sendMessage(aRequest);
                this.mTransportMutex.wait(180000L);
                ITransportable iTransportable = this.mTransportMutex.getResponse();
                return iTransportable;
            }
            finally {
                this.mTransportMutex.setRequestID(null);
                this.mTransportMutex.setWaitingThread(null);
            }
        }
    }

    public void update(IUserSession aSession, ISessionStatus aNewStatus) {
        if (aSession == this.mUserSession) {
            if (aNewStatus.getStatusCode() == 1) {
                this.close(this.mPriceSession);
            } else if (aNewStatus.getStatusCode() == -1) {
                this.mTransportMutex.interruptWaiting();
                this.close(this.mPriceSession);
            } else if (aNewStatus.getStatusCode() == 6 && this.mLoggedIn) {
                new Thread(() -> {
                    this.close(this.mPriceSession);
                    this.mUserSession.setMsgFlags(0L);
                }).start();
            }
            for (IStatusMessageListener mStatusMessageListener : this.mStatusMessageListeners) {
                mStatusMessageListener.messageArrived(aNewStatus);
            }
        } else if (aSession == this.mPriceSession && aNewStatus.getStatusCode() == -1) {
            this.mTransportMutex.interruptWaiting();
            this.close(this.mPriceSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IUserSession aSession, ITransportable aTransportable) {
        TransportMutex transportMutex = this.mTransportMutex;
        synchronized (transportMutex) {
            String sRequestID = this.mTransportMutex.getRequestID();
            if (sRequestID != null && sRequestID.equals(aTransportable.getRequestID())) {
                this.mTransportMutex.setResponse(aTransportable);
                this.mTransportMutex.notifyAll();
            }
        }
        if (this.mLoggedIn && this.mTradingSessionRetrieved) {
            for (IGenericMessageListener listener : this.mGenericMessageListeners) {
                listener.messageArrived(aTransportable);
            }
        }
    }

    private static class TransportMutex {
        protected String mRequestID;
        protected ITransportable mResponse;
        protected Thread mWaitingThread;

        TransportMutex() {
        }

        String getRequestID() {
            return this.mRequestID;
        }

        void setRequestID(String aRequestID) {
            this.mRequestID = aRequestID;
            this.mResponse = null;
        }

        ITransportable getResponse() {
            return this.mResponse;
        }

        void setResponse(ITransportable aResponse) {
            this.mResponse = aResponse;
        }

        void interruptWaiting() {
            if (this.mWaitingThread != null) {
                this.mWaitingThread.interrupt();
            }
        }

        void setWaitingThread(Thread aThread) {
            this.mWaitingThread = aThread;
        }
    }
}

