/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.external.api.util;

import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.QuoteRespTypeFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.pretrade.QuoteResponse;
import com.fxcm.fix.trade.OrderCancelReplaceRequest;
import com.fxcm.fix.trade.OrderCancelRequest;
import com.fxcm.fix.trade.OrderSingle;
import java.util.Date;

public class MessageGenerator {
    public static OrderSingle generateAcceptOrder(String aQuoteID, String aCustomText) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(null, null, 0.0, 0.0, null, null, aCustomText);
        os.setOrdType(OrdTypeFactory.PREVIOUSLY_QUOTED);
        os.setQuoteID(aQuoteID);
        return os;
    }

    public static OrderSingle generateCloseMarketOrder(String aOpenPosID, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        OrderSingle orderSingle = MessageGenerator.generateCloseOrder(0.0, aOpenPosID, aAccount, aAmount, aSide, aCurrency, aClCustomText, 0);
        orderSingle.setOrdType(OrdTypeFactory.MARKET);
        orderSingle.setTimeInForce(TimeInForceFactory.GOOD_TILL_CANCEL);
        return orderSingle;
    }

    public static OrderSingle generateCloseOrder(String aQuoteID, double aPrice, String aOpenPosID, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        return MessageGenerator.generateCloseOrder(aQuoteID, aPrice, aOpenPosID, aAccount, aAmount, aSide, aCurrency, aClCustomText, 0);
    }

    public static OrderSingle generateCloseOrder(double aPrice, String aOpenPosID, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        return MessageGenerator.generateCloseOrder(aPrice, aOpenPosID, aAccount, aAmount, aSide, aCurrency, aClCustomText, 0);
    }

    public static OrderSingle generateCloseOrder(String aQuoteID, double aPrice, String aOpenPosID, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aAtMarketPoints) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, aQuoteID, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(OrdTypeFactory.PREVIOUSLY_QUOTED);
        os.setTimeInForce(TimeInForceFactory.IMMEDIATE_OR_CANCEL);
        os.setFXCMPosID(aOpenPosID);
        if (aAtMarketPoints > 0) {
            os.setOrdType(OrdTypeFactory.STOP_LIMIT);
            PegInstruction peg = new PegInstruction();
            peg.setPegPriceType(4);
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue((double)aAtMarketPoints);
            os.setPegInstructions(peg);
        }
        return os;
    }

    public static OrderSingle generateCloseOrder(double aPrice, String aOpenPosID, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aAtMarketPoints) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, null, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(OrdTypeFactory.PREVIOUSLY_QUOTED);
        os.setTimeInForce(TimeInForceFactory.IMMEDIATE_OR_CANCEL);
        os.setFXCMPosID(aOpenPosID);
        if (aAtMarketPoints > 0) {
            os.setOrdType(OrdTypeFactory.STOP_LIMIT);
            PegInstruction peg = new PegInstruction();
            peg.setPegPriceType(4);
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue((double)aAtMarketPoints);
            os.setPegInstructions(peg);
        }
        return os;
    }

    private static OrderSingle generateDefaultOrderSingle(String aAccount, String aQuoteID, double aAmount, double aRate, ISide aSide, String aCurrency, String aClCustomText) {
        OrderSingle os = new OrderSingle();
        os.setAccount(aAccount);
        os.setQuoteID(aQuoteID);
        os.setOrderQty(aAmount);
        os.setPrice(aRate);
        os.setSide(aSide);
        os.setInstrument(new Instrument(aCurrency));
        os.setSecondaryClOrdID(aClCustomText);
        return os;
    }

    public static OrderSingle generateMarketOrder(String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, null, aAmount, 0.0, aSide, aCurrency, aClCustomText);
        os.setOrdType(OrdTypeFactory.MARKET);
        os.setTimeInForce(TimeInForceFactory.GOOD_TILL_CANCEL);
        return os;
    }

    public static OrderSingle generateOpenOrder(String aQuoteID, double aPrice, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        return MessageGenerator.generateOpenOrder(aQuoteID, aPrice, aAccount, aAmount, aSide, aCurrency, aClCustomText, 0);
    }

    public static OrderSingle generateOpenOrder(double aPrice, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        return MessageGenerator.generateOpenOrder(aPrice, aAccount, aAmount, aSide, aCurrency, aClCustomText, 0);
    }

    public static OrderSingle generateOpenOrder(String aQuoteID, double aPrice, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aAtMarketPoints) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, aQuoteID, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(OrdTypeFactory.PREVIOUSLY_QUOTED);
        os.setTimeInForce(TimeInForceFactory.IMMEDIATE_OR_CANCEL);
        if (aAtMarketPoints > 0) {
            os.setOrdType(OrdTypeFactory.STOP_LIMIT);
            PegInstruction peg = new PegInstruction();
            peg.setPegPriceType(4);
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue((double)aAtMarketPoints);
            os.setPegInstructions(peg);
        }
        return os;
    }

    public static OrderSingle generateOpenOrder(double aPrice, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aAtMarketPoints) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, null, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(OrdTypeFactory.LIMIT);
        os.setTimeInForce(TimeInForceFactory.IMMEDIATE_OR_CANCEL);
        if (aAtMarketPoints > 0) {
            os.setOrdType(OrdTypeFactory.STOP_LIMIT);
            PegInstruction peg = new PegInstruction();
            peg.setPegPriceType(4);
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue((double)aAtMarketPoints);
            os.setPegInstructions(peg);
        }
        return os;
    }

    public static OrderCancelRequest generateOrderCancelRequest(String aClCustomText, String aOrderID, ISide aSide, String aAccount) {
        OrderCancelRequest ocr = new OrderCancelRequest();
        ocr.setSecondaryClOrdID(aClCustomText);
        ocr.setOrderID(aOrderID);
        ocr.setSide(aSide);
        ocr.setAccount(aAccount);
        ocr.setTransactTime(new UTCTimestamp(new Date()));
        return ocr;
    }

    public static OrderCancelReplaceRequest generateOrderReplaceRequest(String aClCustomText, String aOrderID, ISide aSide, IOrdType aOrdType, double aPrice, String aAccount) {
        return MessageGenerator.generateOrderReplaceRequest(aClCustomText, aOrderID, aSide, aOrdType, aPrice, 0, aAccount);
    }

    public static OrderCancelReplaceRequest generateOrderReplaceRequest(String aClCustomText, String aOrderID, ISide aSide, IOrdType aOrdType, double aPrice, int aTrailing, String aAccount) {
        OrderCancelReplaceRequest ocr = new OrderCancelReplaceRequest();
        ocr.setSecondaryClOrdID(aClCustomText);
        ocr.setOrderID(aOrderID);
        ocr.setSide(aSide);
        ocr.setOrdType(aOrdType);
        ocr.setPrice(aPrice);
        ocr.setTransactTime(new UTCTimestamp(new Date()));
        ocr.setAccount(aAccount);
        if (aTrailing > 0 && OrdTypeFactory.STOP == aOrdType) {
            PegInstruction peg = new PegInstruction();
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue(aPrice);
            peg.setFXCMPegFluctuatePts(aTrailing);
            ocr.setPegInstructions(peg);
        }
        return ocr;
    }

    public static QuoteResponse generatePassResponse(String aQuoteID) {
        QuoteResponse qr = new QuoteResponse();
        qr.setQuoteID(aQuoteID);
        qr.setQuoteRespType(QuoteRespTypeFactory.PASS);
        return qr;
    }

    public static OrderSingle generateStopLimitClose(double aPrice, String aPosID, IOrdType aOrderType, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        return MessageGenerator.generateStopLimitClose(aPrice, aPosID, aOrderType, aAccount, aAmount, aSide, aCurrency, aClCustomText, 0);
    }

    public static OrderSingle generateStopLimitClose(double aPrice, String aPosID, IOrdType aOrderType, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aTrailing) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, null, aAmount, 0.0, aSide, aCurrency, aClCustomText);
        os.setOrdType(aOrderType);
        os.setFXCMPosID(aPosID);
        if (OrdTypeFactory.STOP == aOrderType) {
            os.setStopPx(aPrice);
        } else {
            os.setPrice(aPrice);
        }
        if (aTrailing > 0) {
            PegInstruction peg = new PegInstruction();
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue(aPrice);
            peg.setFXCMPegFluctuatePts(aTrailing);
            os.setPegInstructions(peg);
        }
        return os;
    }

    public static OrderSingle generateStopLimitEntry(String aQuoteID, double aPrice, IOrdType aOrderType, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, aQuoteID, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(aOrderType);
        return os;
    }

    public static OrderSingle generateStopLimitEntry(double aPrice, IOrdType aOrderType, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, null, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(aOrderType);
        return os;
    }

    public static OrderSingle generateStopLimitEntry(String aQuoteID, double aPrice, IOrdType aOrderType, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aTrailing) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, aQuoteID, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(aOrderType);
        if (aTrailing > 0) {
            PegInstruction peg = new PegInstruction();
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setPegOffsetValue(aPrice);
            peg.setFXCMPegFluctuatePts(aTrailing);
            os.setPegInstructions(peg);
        }
        return os;
    }

    public static OrderSingle generateStopLimitEntry(double aPrice, IOrdType aOrderType, String aAccount, double aAmount, ISide aSide, String aCurrency, String aClCustomText, int aTrailing) {
        OrderSingle os = MessageGenerator.generateDefaultOrderSingle(aAccount, null, aAmount, aPrice, aSide, aCurrency, aClCustomText);
        os.setOrdType(aOrderType);
        if (aTrailing > 0) {
            PegInstruction peg = new PegInstruction();
            peg.setPegMoveType(0);
            peg.setPegOffsetType(1);
            peg.setFXCMPegFluctuatePts(aTrailing);
            os.setPegInstructions(peg);
        }
        return os;
    }
}

