/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.external.api.transport;

import com.fxcm.util.logging.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class FXCMLoginProperties {
    private String mConfigFile;
    private final Log mLogger;
    private String mPassword;
    private Properties mProperties;
    private String mServer;
    private String mServiceName;
    private String mTerminal;
    private String mUserName;

    public FXCMLoginProperties(String aUserName, String aPassword, String aTerminal, String aServer) {
        this.mServer = aServer;
        this.mPassword = aPassword;
        this.mTerminal = aTerminal;
        this.mUserName = aUserName;
        this.mProperties = new Properties();
        this.mLogger = Utils.getLog((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FXCMLoginProperties(String aUserName, String aPassword, String aTerminal, String aServer, String aConfigFile) {
        block8: {
            this.mServer = aServer;
            this.mPassword = aPassword;
            this.mTerminal = aTerminal;
            this.mUserName = aUserName;
            this.mConfigFile = aConfigFile;
            this.mProperties = new Properties();
            this.mLogger = Utils.getLog((Object)this);
            try {
                if (this.mConfigFile == null) break block8;
                this.addProperty("quickfix.cfg", this.mConfigFile);
                try (FileInputStream inStream = null;){
                    inStream = new FileInputStream(this.mConfigFile);
                    this.mProperties.load(inStream);
                }
            }
            catch (IOException e) {
                this.mLogger.error((Object)this, (Throwable)e);
            }
        }
    }

    public void addProperty(Object aKey, Object aValue) {
        this.mProperties.put(aKey, aValue);
    }

    public String getPassword() {
        return this.mPassword;
    }

    public Properties getProperties() throws IOException {
        return this.mProperties;
    }

    public void setProperties(Properties aProperties) {
        this.mProperties = aProperties;
    }

    public String getServer() {
        return this.mServer;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(String aServiceName) {
        this.mServiceName = aServiceName;
    }

    public String getTerminal() {
        return this.mTerminal;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FXCMLoginProperties");
        sb.append("{mConfigFile='").append(this.mConfigFile).append('\'');
        sb.append(", mPassword='").append(this.mPassword).append('\'');
        sb.append(", mProperties=").append(this.mProperties);
        sb.append(", mServer='").append(this.mServer).append('\'');
        sb.append(", mTerminal='").append(this.mTerminal).append('\'');
        sb.append(", mUserName='").append(this.mUserName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

