/*
 * Decompiled with CFR 0.152.
 */
import com.fxcm.external.api.transport.FXCMLoginProperties;
import com.fxcm.external.api.transport.GatewayFactory;
import com.fxcm.external.api.transport.IGateway;
import com.fxcm.external.api.transport.listeners.IGenericMessageListener;
import com.fxcm.external.api.transport.listeners.IStatusMessageListener;
import com.fxcm.external.api.util.MessageAnalyzer;
import com.fxcm.external.api.util.MessageGenerator;
import com.fxcm.external.api.util.OrdStatusRequestType;
import com.fxcm.fix.ContingencyTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.ISide;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.admin.Logout;
import com.fxcm.fix.other.BusinessMessageReject;
import com.fxcm.fix.other.UserRequest;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.fix.posttrade.ClosedPositionReport;
import com.fxcm.fix.posttrade.CollateralInquiry;
import com.fxcm.fix.posttrade.CollateralInquiryAck;
import com.fxcm.fix.posttrade.CollateralReport;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.fix.posttrade.RequestForPositionsAck;
import com.fxcm.fix.pretrade.MarketDataRequest;
import com.fxcm.fix.pretrade.MarketDataRequestReject;
import com.fxcm.fix.pretrade.MarketDataSnapshot;
import com.fxcm.fix.pretrade.Quote;
import com.fxcm.fix.pretrade.QuoteRequest;
import com.fxcm.fix.pretrade.QuoteResponse;
import com.fxcm.fix.pretrade.SecurityList;
import com.fxcm.fix.pretrade.SecurityListRequest;
import com.fxcm.fix.pretrade.SecurityStatus;
import com.fxcm.fix.pretrade.SecurityStatusRequest;
import com.fxcm.fix.pretrade.TradingSessionStatus;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderCancelReplaceRequest;
import com.fxcm.fix.trade.OrderCancelRequest;
import com.fxcm.fix.trade.OrderList;
import com.fxcm.fix.trade.OrderMassStatusRequest;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.messaging.ISessionStatus;
import com.fxcm.messaging.ITransportable;
import com.fxcm.util.Util;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TreeMap;

public class QATest {
    private String mAccountMassID;
    private final String mConfigFile;
    private IGateway mFxcmGateway;
    private String mOpenOrderMassID;
    private String mOpenPositionMassID;
    private final String mPassword;
    private final String mServer;
    private final String mStation;
    private IStatusMessageListener mStatusListener;
    private final String mUsername;

    public QATest(String aUsername, String aPassword, String aStation, String aServer, String aConfigFile) {
        this.mServer = aServer;
        this.mUsername = aUsername;
        this.mPassword = aPassword;
        this.mStation = aStation;
        this.mConfigFile = aConfigFile;
    }

    private boolean doResult(MessageTestHandler aMessageTestHandler) {
        new Thread(() -> this.setup(aMessageTestHandler, false)).start();
        int expiration = 20;
        while (!aMessageTestHandler.isSuccess() && expiration > 0) {
            try {
                Thread.sleep(1000L);
                --expiration;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (aMessageTestHandler.isSuccess()) {
            System.out.println("done waiting.\nstatus = " + aMessageTestHandler.isSuccess());
        } else {
            System.err.println("done waiting.\nstatus = " + aMessageTestHandler.isSuccess());
        }
        this.mFxcmGateway.removeGenericMessageListener(aMessageTestHandler);
        this.mFxcmGateway.removeStatusMessageListener(this.mStatusListener);
        this.mFxcmGateway.logout();
        return aMessageTestHandler.isSuccess();
    }

    private void handleMessage(ITransportable aMessage, List<CollateralReport> aAccounts, MessageTestHandler aMessageTestHandler) {
        if (aMessage instanceof CollateralReport) {
            CollateralReport cr = (CollateralReport)aMessage;
            if (QATest.safeEquals(this.mAccountMassID, cr.getRequestID()) && aAccounts != null) {
                aAccounts.add(cr);
            }
            aMessageTestHandler.process(cr);
        } else if (aMessage instanceof CollateralInquiryAck) {
            aMessageTestHandler.process((CollateralInquiryAck)aMessage);
        } else if (aMessage instanceof ExecutionReport) {
            aMessageTestHandler.process((ExecutionReport)aMessage);
        } else if (aMessage instanceof ClosedPositionReport) {
            aMessageTestHandler.process((ClosedPositionReport)aMessage);
        } else if (aMessage instanceof PositionReport) {
            aMessageTestHandler.process((PositionReport)aMessage);
        } else if (aMessage instanceof BusinessMessageReject) {
            aMessageTestHandler.process((BusinessMessageReject)aMessage);
        } else if (aMessage instanceof RequestForPositionsAck) {
            aMessageTestHandler.process((RequestForPositionsAck)aMessage);
        } else if (aMessage instanceof TradingSessionStatus) {
            aMessageTestHandler.process((TradingSessionStatus)aMessage);
        } else if (aMessage instanceof SecurityStatus) {
            aMessageTestHandler.process((SecurityStatus)aMessage);
        } else if (aMessage instanceof Quote) {
            aMessageTestHandler.process((Quote)aMessage);
        } else if (aMessage instanceof MarketDataSnapshot) {
            aMessageTestHandler.process((MarketDataSnapshot)aMessage);
        } else if (aMessage instanceof SecurityList) {
            aMessageTestHandler.process((SecurityList)aMessage);
        } else if (aMessage instanceof UserResponse) {
            aMessageTestHandler.process((UserResponse)aMessage);
        } else if (aMessage instanceof Logout) {
            aMessageTestHandler.process((Logout)aMessage);
        } else if (aMessage instanceof MarketDataRequestReject) {
            aMessageTestHandler.process((MarketDataRequestReject)aMessage);
        }
    }

    private static void runTest(String[] aArgs) {
        String aCommand = aArgs[4];
        String arg5 = null;
        if (aArgs.length > 5) {
            arg5 = aArgs[5];
        }
        System.out.print("Argument = " + aCommand + ", ");
        QATest qaTest = new QATest(aArgs[0], aArgs[1], aArgs[2], aArgs[3], arg5);
        if ("CPQO".equalsIgnoreCase(aCommand)) {
            qaTest.testCreatePreviouslyQuotedOrder();
        } else if ("SSLMO".equalsIgnoreCase(aCommand)) {
            qaTest.testSetSLMarketOrder();
        } else if ("USLMO".equalsIgnoreCase(aCommand)) {
            qaTest.testUpdateSLMarketOrder();
        } else if ("DSLMO".equalsIgnoreCase(aCommand)) {
            qaTest.testDeleteSLMarketOrder();
        } else if ("CEO".equalsIgnoreCase(aCommand)) {
            qaTest.testCreateEntryOrder(false);
        } else if ("SSLEO".equalsIgnoreCase(aCommand)) {
            qaTest.testSetSLEntryOrder();
        } else if ("USLEO".equalsIgnoreCase(aCommand)) {
            qaTest.testUpdateSLEntryOrder();
        } else if ("DSLEO".equalsIgnoreCase(aCommand)) {
            qaTest.testDeleteSLEntryOrder();
        } else if ("DEO".equalsIgnoreCase(aCommand)) {
            qaTest.testDeleteEntryOrder();
        } else if ("CLOSEPQO".equalsIgnoreCase(aCommand)) {
            qaTest.testClosePreviouslyQuotedOrder();
        } else if ("URQEO".equalsIgnoreCase(aCommand)) {
            qaTest.testUpdateRateQtyEntryOrder();
        } else if ("LISTEN".equalsIgnoreCase(aCommand)) {
            qaTest.testListen();
        } else if ("PURGE".equalsIgnoreCase(aCommand)) {
            qaTest.testPurgeAll();
        } else if ("RECONNECT".equalsIgnoreCase(aCommand)) {
            qaTest.testReconnect();
        } else if ("OCM".equalsIgnoreCase(aCommand)) {
            qaTest.testOpenCloseMarket();
        } else if ("IRC".equalsIgnoreCase(aCommand)) {
            qaTest.testInterestRateChange();
        } else if ("ABC".equalsIgnoreCase(aCommand)) {
            qaTest.testAccountBalanceChange();
        } else if ("RMO".equalsIgnoreCase(aCommand)) {
            qaTest.testRejectMarketOrder();
        } else if ("ADIR".equalsIgnoreCase(aCommand)) {
            qaTest.testAcceptDealerInterventionRequote();
        } else if ("RDIR".equalsIgnoreCase(aCommand)) {
            qaTest.testRejectDealerInterventionRequote();
        } else if ("OSR".equalsIgnoreCase(aCommand)) {
            qaTest.testOrderStatusRequest();
        } else if ("HS".equalsIgnoreCase(aCommand)) {
            qaTest.testHistoricalSnapshot();
        } else if ("CTMO".equalsIgnoreCase(aCommand)) {
            qaTest.testCreateTrueMarketOrder();
        } else if ("RFQ".equalsIgnoreCase(aCommand)) {
            qaTest.testRFQ();
        } else if ("SSR".equalsIgnoreCase(aCommand)) {
            qaTest.testSecurityStatusRequest();
        } else if ("SLR".equalsIgnoreCase(aCommand)) {
            qaTest.testSecurityListRequest();
        } else if ("CLOSETMO".equalsIgnoreCase(aCommand)) {
            qaTest.testCloseTrueMarketOrder();
        } else if ("ALL".equalsIgnoreCase(aCommand)) {
            qaTest.testAll();
        } else if ("MDR".equalsIgnoreCase(aCommand)) {
            qaTest.testMarketDataRequest();
        } else if ("MDH".equalsIgnoreCase(aCommand)) {
            qaTest.testMarketDataHistory();
        } else if ("OPENRANGE".equalsIgnoreCase(aCommand)) {
            qaTest.testOpenRangeOrder();
        } else if ("CLOSERANGE".equalsIgnoreCase(aCommand)) {
            qaTest.testCloseRangeOrder();
        } else if ("OL".equalsIgnoreCase(aCommand)) {
            qaTest.testOrderList();
        } else if ("OTOCO".equalsIgnoreCase(aCommand)) {
            qaTest.testOTOCO();
        } else if ("OCO".equalsIgnoreCase(aCommand)) {
            qaTest.testOCO();
        } else if ("COCO".equalsIgnoreCase(aCommand)) {
            qaTest.testComplexOCO();
        } else if ("OPENLIMIT".equalsIgnoreCase(aCommand)) {
            qaTest.testOpenLimit();
        } else if ("CLOSELIMIT".equalsIgnoreCase(aCommand)) {
            qaTest.testCloseLimit();
        } else if ("USERSTATUS".equalsIgnoreCase(aCommand)) {
            qaTest.testUserStatus();
        } else if ("OH".equalsIgnoreCase(aCommand)) {
            qaTest.testOrderHistory();
        } else if ("OTO".equalsIgnoreCase(aCommand)) {
            qaTest.testOTO();
        } else if ("IFTHEN".equalsIgnoreCase(aCommand)) {
            qaTest.testIfThen();
        } else if ("IFTHENOCO".equalsIgnoreCase(aCommand)) {
            qaTest.testIfThenOCO();
        } else if ("NQC".equalsIgnoreCase(aCommand)) {
            qaTest.testNetQuantityClose();
        } else if ("NQSL".equalsIgnoreCase(aCommand)) {
            qaTest.testNetQuantityStopLimit();
        } else if ("ATMARKET".equalsIgnoreCase(aCommand)) {
            qaTest.testAtMarketPointsOrder();
        } else if ("LSTE".equalsIgnoreCase(aCommand)) {
            qaTest.testCreateTrailingEntryOrder();
        } else if ("FSSLTEO".equalsIgnoreCase(aCommand)) {
            qaTest.testFixedSetSLTEntryOrder();
        } else if ("DSSLTEO".equalsIgnoreCase(aCommand)) {
            qaTest.testDynamicSetSLTEntryOrder();
        } else if ("FPSSLTEO".equalsIgnoreCase(aCommand)) {
            qaTest.testFixedPtsSetSLTEntryOrder();
        } else if ("DPSSLTEO".equalsIgnoreCase(aCommand)) {
            qaTest.testDynamicPtsSetSLTEntryOrder();
        } else if ("ELS".equalsIgnoreCase(aCommand)) {
            qaTest.testELS();
        } else if ("ELSPEG".equalsIgnoreCase(aCommand)) {
            qaTest.testELSPeg();
        } else if ("DAY".equalsIgnoreCase(aCommand)) {
            qaTest.testCreateEntryOrder(true);
        } else if ("GTD".equalsIgnoreCase(aCommand)) {
            qaTest.testCreateGTDOrder();
        } else if ("EQUITY".equalsIgnoreCase(aCommand)) {
            qaTest.testRequestEquity();
        } else if ("REO".equalsIgnoreCase(aCommand)) {
            qaTest.testRangeEntryOrder();
        } else {
            System.out.println("Unknown Command: " + aCommand);
        }
    }

    public static boolean safeEquals(String aString1, String aString2) {
        return aString1 != null && aString2 != null && aString1.equals(aString2);
    }

    private void setup(IGenericMessageListener aGenericListener, boolean aPrintStatus) {
        try {
            if (this.mFxcmGateway == null) {
                this.mFxcmGateway = GatewayFactory.createGateway();
            }
            this.mFxcmGateway.registerGenericMessageListener(aGenericListener);
            this.mStatusListener = new DefaultStatusListener(aPrintStatus);
            this.mFxcmGateway.registerStatusMessageListener(this.mStatusListener);
            if (!this.mFxcmGateway.isConnected()) {
                System.out.println("client: login");
                FXCMLoginProperties properties = new FXCMLoginProperties(this.mUsername, this.mPassword, this.mStation, this.mServer, this.mConfigFile);
                this.mFxcmGateway.login(properties);
            }
            this.mFxcmGateway.requestTradingSessionStatus();
            this.mAccountMassID = this.mFxcmGateway.requestAccounts();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean testAcceptDealerInterventionRequote() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private boolean mOrder = true;
            private String mRequoteID;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        String requestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: order requestid = " + requestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                if (aPositionReport.getClOrdID().equals(this.mRequoteID)) {
                    System.out.println("aPositionReport = " + aPositionReport);
                    QATest.this.mFxcmGateway.logout();
                    System.out.println("completed successfully");
                }
            }

            @Override
            public void process(Quote aQuote) {
                System.out.println("aQuote = " + aQuote);
                if (aQuote.getQuoteID().startsWith("Requote-")) {
                    try {
                        OrderSingle orderSingle = MessageGenerator.generateAcceptOrder(aQuote.getQuoteID(), "accept requote");
                        this.mRequoteID = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testAccountBalanceChange() {
        System.out.println(Util.getCurrentlyExecutingMethod());
        class GenericListener
        extends MessageTestHandler {
            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                System.out.println("client: collateral report cash outstanding = " + aCollateralReport.getCashOutstanding());
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    private static Boolean runTest(boolean aStatus) {
        return aStatus;
    }

    public void testAll() {
        Boolean value;
        Object[] keys;
        Date start = new Date(System.currentTimeMillis());
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        map.put("CLOSEPQO", QATest.runTest(this.testClosePreviouslyQuotedOrder()));
        map.put("CEO", QATest.runTest(this.testCreateEntryOrder(false)));
        map.put("CPQO", QATest.runTest(this.testCreatePreviouslyQuotedOrder()));
        map.put("CTMO", QATest.runTest(this.testCreateTrueMarketOrder()));
        map.put("DEO", QATest.runTest(this.testDeleteEntryOrder()));
        map.put("DSLEO", QATest.runTest(this.testDeleteSLEntryOrder()));
        map.put("DSLMO", QATest.runTest(this.testDeleteSLMarketOrder()));
        map.put("HS", QATest.runTest(this.testHistoricalSnapshot()));
        map.put("OSR", QATest.runTest(this.testOrderStatusRequest()));
        map.put("SLR", QATest.runTest(this.testSecurityListRequest()));
        map.put("SSR", QATest.runTest(this.testSecurityStatusRequest()));
        map.put("SSLEO", QATest.runTest(this.testSetSLEntryOrder()));
        map.put("SSLMO", QATest.runTest(this.testSetSLMarketOrder()));
        map.put("URQEO", QATest.runTest(this.testUpdateRateQtyEntryOrder()));
        map.put("USLEO", QATest.runTest(this.testUpdateSLEntryOrder()));
        map.put("USLMO", QATest.runTest(this.testUpdateSLMarketOrder()));
        map.put("CLOSETMO", QATest.runTest(this.testCloseTrueMarketOrder()));
        map.put("MDR", QATest.runTest(this.testMarketDataRequest()));
        map.put("MDH", QATest.runTest(this.testMarketDataHistory()));
        map.put("USERSTATUS", QATest.runTest(this.testUserStatus()));
        map.put("OL", QATest.runTest(this.testOrderList()));
        map.put("OPENRANGE", QATest.runTest(this.testOpenRangeOrder()));
        map.put("CLOSERANGE", QATest.runTest(this.testCloseRangeOrder()));
        map.put("OPENLIMIT", QATest.runTest(this.testOpenLimit()));
        map.put("CLOSELIMIT", QATest.runTest(this.testCloseLimit()));
        map.put("OH", QATest.runTest(this.testOrderHistory()));
        map.put("OTO", QATest.runTest(this.testOTO()));
        map.put("OCO", QATest.runTest(this.testOCO()));
        map.put("COCO", QATest.runTest(this.testComplexOCO()));
        map.put("NQC", QATest.runTest(this.testNetQuantityClose()));
        map.put("NQSL", QATest.runTest(this.testNetQuantityStopLimit()));
        map.put("ATMARKET", QATest.runTest(this.testAtMarketPointsOrder()));
        map.put("LSTE", QATest.runTest(this.testCreateTrailingEntryOrder()));
        map.put("FSSLTEO", QATest.runTest(this.testFixedSetSLTEntryOrder()));
        map.put("DSSLTEO", QATest.runTest(this.testDynamicSetSLTEntryOrder()));
        map.put("FPSSLTEO", QATest.runTest(this.testFixedPtsSetSLTEntryOrder()));
        map.put("DPSSLTEO", QATest.runTest(this.testDynamicPtsSetSLTEntryOrder()));
        map.put("ELS", QATest.runTest(this.testELS()));
        map.put("ELSPEG", QATest.runTest(this.testELSPeg()));
        map.put("DAY", QATest.runTest(this.testCreateEntryOrder(true)));
        map.put("GTD", QATest.runTest(this.testCreateGTDOrder()));
        map.put("REO", QATest.runTest(this.testRangeEntryOrder()));
        map.put("IFTHEN", QATest.runTest(this.testIfThen()));
        map.put("IFTHENOCO", QATest.runTest(this.testIfThenOCO()));
        System.out.println("\nstart = " + start);
        for (Object key : keys = map.keySet().toArray()) {
            value = (Boolean)map.get(key);
            if (!value.booleanValue()) continue;
            System.out.print("SUCCESS ");
            System.out.println(key);
            map.remove(key);
        }
        for (Object key : keys = map.keySet().toArray()) {
            value = (Boolean)map.get(key);
            if (value.booleanValue()) continue;
            System.err.print("FAILURE ");
            System.err.println(key);
        }
        System.out.println("end = " + new Date(System.currentTimeMillis()) + "\n");
    }

    public boolean testCloseLimit() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag = true;
            private String mRequestId;
            private String mLimitReqID;
            private PositionReport mPositionReport;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if ("EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol()) && this.mPositionReport != null) {
                        try {
                            System.out.println("client: trying to set a close limit on the position in 2 seconds");
                            OrderSingle order = MessageGenerator.generateCloseOrder(aMarketDataSnapshot.getBidClose(), this.mPositionReport.getFXCMPosID(), this.mPositionReport.getAccount(), this.mPositionReport.getPositionQty().getQty(), SideFactory.SELL, this.mPositionReport.getInstrument().getSymbol(), cem);
                            order.setOrdType(OrdTypeFactory.LIMIT);
                            order.setTimeInForce(TimeInForceFactory.IMMEDIATE_OR_CANCEL);
                            this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                            System.out.println("client: close limit order reqId = " + this.mLimitReqID);
                            this.mPositionReport = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (this.mFlag && QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID())) {
                    this.mPositionReport = aPositionReport;
                    this.mFlag = false;
                    MarketDataRequest mdr = new MarketDataRequest();
                    mdr.addRelatedSymbol((Instrument)this.mTradingSessionStatus.getSecurity("EUR/USD"));
                    mdr.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SUBSCRIBE);
                    mdr.setMDEntryTypeSet(7);
                    try {
                        QATest.this.mFxcmGateway.sendMessage((ITransportable)mdr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                super.process(aClosedPositionReport);
                if (QATest.safeEquals(aClosedPositionReport.getFXCMCloseClOrdID(), this.mLimitReqID)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testClosePreviouslyQuotedOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private PositionReport mPositionReport;

            GenericListener() {
            }

            @Override
            public void process(PositionReport aPositionReport) {
                System.out.println("client: incoming pos report = " + aPositionReport);
                if (QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID())) {
                    this.mPositionReport = aPositionReport;
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                super.process(aClosedPositionReport);
                if (aClosedPositionReport.getFXCMCloseClOrdID().equals(this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty()) {
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(aMarketDataSnapshot.getQuoteID(), aMarketDataSnapshot.getAskClose(), acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    } else {
                        String snapSym = aMarketDataSnapshot.getInstrument().getSymbol();
                        if (this.mPositionReport != null && snapSym.equals(this.mPositionReport.getInstrument().getSymbol())) {
                            System.out.println("client: closing the open position");
                            OrderSingle delOrder = MessageGenerator.generateCloseOrder(aMarketDataSnapshot.getQuoteID(), aMarketDataSnapshot.getBidClose(), this.mPositionReport.getFXCMPosID(), this.mPositionReport.getAccount(), this.mPositionReport.getPositionQty().getQty(), SideFactory.SELL, this.mPositionReport.getInstrument().getSymbol(), cem);
                            delOrder.setTimeInForce(TimeInForceFactory.FILL_OR_KILL);
                            this.mPositionReport = null;
                            this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)delOrder);
                            System.out.println("client: del reqId = " + this.mRequestId);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCloseRangeOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(PositionReport aPositionReport) {
                System.out.println("client: incoming pos report = " + aPositionReport);
                if (QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID()) && this.mFlag) {
                    try {
                        ISide side = aPositionReport.getPositionQty().getSide() == SideFactory.BUY ? SideFactory.SELL : SideFactory.BUY;
                        this.mFlag = false;
                        System.out.println("client: closing the open position in 2 seconds.");
                        OrderSingle delOrder = MessageGenerator.generateCloseOrder(0.0, aPositionReport.getFXCMPosID(), aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), side, aPositionReport.getInstrument().getSymbol(), cem);
                        delOrder.setOrdType(OrdTypeFactory.STOP_LIMIT);
                        if (side == SideFactory.BUY) {
                            delOrder.setPrice(this.add(aPositionReport.getSettlPrice(), -0.001, aPositionReport.getInstrument().getSymbol()));
                            delOrder.setStopPx(this.add(aPositionReport.getSettlPrice(), 0.001, aPositionReport.getInstrument().getSymbol()));
                        } else {
                            delOrder.setPrice(this.add(aPositionReport.getSettlPrice(), 0.001, aPositionReport.getInstrument().getSymbol()));
                            delOrder.setStopPx(this.add(aPositionReport.getSettlPrice(), -0.001, aPositionReport.getInstrument().getSymbol()));
                        }
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)delOrder);
                        System.out.println("client: del reqId = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                super.process(aClosedPositionReport);
                if (aClosedPositionReport.getFXCMCloseClOrdID().equals(this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCloseTrueMarketOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(PositionReport aPositionReport) {
                System.out.println("client: incoming pos report = " + aPositionReport);
                if (QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID()) && this.mFlag) {
                    try {
                        ISide side = aPositionReport.getPositionQty().getSide() == SideFactory.BUY ? SideFactory.SELL : SideFactory.BUY;
                        this.mFlag = false;
                        System.out.println("client: closing the open position in 2 seconds.");
                        OrderSingle delOrder = MessageGenerator.generateCloseMarketOrder(aPositionReport.getFXCMPosID(), aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), side, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)delOrder);
                        System.out.println("client: del reqId = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                super.process(aClosedPositionReport);
                if (aClosedPositionReport.getFXCMCloseClOrdID().equals(this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCreateEntryOrder(final boolean aIsDay) {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private final boolean mIsDay = aIsDay;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty() && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        this.mOrder = false;
                        OrderSingle os2 = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, "EUR/USD", cem);
                        if (this.mIsDay) {
                            os2.setTimeInForce(TimeInForceFactory.DAY);
                        }
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os2);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(aExecutionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCreateGTDOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty()) {
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        this.mOrder = false;
                        OrderSingle os2 = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, "EUR/USD", cem);
                        os2.setTimeInForce(TimeInForceFactory.GOOD_TILL_DATE);
                        Calendar calendar = GregorianCalendar.getInstance();
                        calendar.add(5, 1);
                        os2.setExpireTime((UTCTimestamp)new UTCDate(calendar.getTime()));
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os2);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(aExecutionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCreateTrailingEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty()) {
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        this.mOrder = false;
                        OrderSingle os = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, "EUR/USD", cem, 10);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                        OrderSingle os2 = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, "EUR/USD", cem, 10);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os2);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(aExecutionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCreatePreviouslyQuotedOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("client: incoming mds = " + aMarketDataSnapshot);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(aMarketDataSnapshot.getQuoteID(), aMarketDataSnapshot.getAskClose(), acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        orderSingle.setTimeInForce(TimeInForceFactory.FILL_OR_KILL);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testCreateTrueMarketOrder() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                if (this.mOrder) {
                    this.mOrder = false;
                    OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.SELL, "EUR/USD", "true market order test");
                    orderSingle.setTimeInForce(TimeInForceFactory.FILL_OR_KILL);
                    try {
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                super.process(aClosedPositionReport);
                if (QATest.safeEquals(aClosedPositionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testNetQuantityClose() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mCloseRequestId;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                if (this.mOrder) {
                    this.mOrder = false;
                    try {
                        for (int i = 0; i < 5; ++i) {
                            this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", "NQTEST-OPEN" + i));
                            System.out.println("client: open order requestid = " + this.mRequestId);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(aExecutionReport.getClOrdID(), this.mCloseRequestId) && aExecutionReport.getOrdStatus() == OrdStatusFactory.FILLED) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aPositionReport.getAccount(), 0.0, SideFactory.SELL, "EUR/USD", "NQTEST-CLOSE");
                    orderSingle.setOrderPercent(100.0);
                    try {
                        this.mRequestId = null;
                        this.mCloseRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: close order requestid = " + this.mCloseRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testNetQuantityStopLimit() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                if (this.mOrder && !this.mAccounts.isEmpty()) {
                    this.mOrder = false;
                    OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", "true market order test");
                    try {
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(this.mRequestId, aExecutionReport.getRequestID())) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID())) {
                    try {
                        System.out.println("client: net qty stop/limit requestId = " + this.mRequestId);
                        OrderList ol = new OrderList();
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aPositionReport.getSettlPrice(), -0.005, aPositionReport.getInstrument().getSymbol()), OrdTypeFactory.STOP, aPositionReport.getAccount(), 0.0, SideFactory.SELL, aPositionReport.getInstrument().getSymbol(), "entry order - contingency - stop loss");
                        stop.setOrderPercent(100.0);
                        ol.addOrder(stop);
                        OrderSingle limit = MessageGenerator.generateStopLimitEntry(this.add(aPositionReport.getSettlPrice(), 0.005, aPositionReport.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, aPositionReport.getAccount(), 0.0, SideFactory.SELL, aPositionReport.getInstrument().getSymbol(), "entry order - contingency - limit profit");
                        limit.setOrderPercent(100.0);
                        ol.addOrder(limit);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testDeleteEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private boolean mOpen = true;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                System.out.println("client: inc exe rpt = " + aExe);
                if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, aExe.getRequestID())) {
                    try {
                        if (!aExe.getFXCMOrdStatus().isDeleted() && this.mOpen) {
                            this.mOpen = false;
                            System.out.println("client: got an entry order, waiting 2 seconds.");
                            OrderCancelRequest ocr = new OrderCancelRequest();
                            System.out.println("client: deleting the entry order");
                            ocr.setSecondaryClOrdID("text custom text delete order");
                            ocr.setOrderID(aExe.getOrderID());
                            ocr.setOrigClOrdID(aExe.getClOrdID());
                            ocr.setSide(aExe.getSide());
                            ocr.setInstrument(aExe.getInstrument());
                            ocr.setAccount(aExe.getAccount());
                            ocr.setOrderQty(aExe.getOrderQty());
                            this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ocr);
                            System.out.println("client: del reqId = " + this.mRequestId);
                        } else if (aExe.getFXCMOrdStatus().isDeleted()) {
                            this.setSuccess(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testDeleteSLEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mLimitId;
            private String mStopId;
            private String mRequestId;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, aExe.getRequestID())) {
                        System.out.println("\nclient: trying to set a stop on the entry order");
                        OrderSingle order = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), -0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: stop  order reqId = " + this.mStopId);
                        System.out.println("\nclient: trying to set a limit on the entry order");
                        order = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), 0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: limit order reqId = " + this.mLimitId);
                    } else if (MessageAnalyzer.isStopLimitCloseOrder(aExe) && (QATest.safeEquals(this.mStopId, aExe.getRequestID()) || QATest.safeEquals(this.mLimitId, aExe.getRequestID()))) {
                        if (aExe.getFXCMOrdStatus().isDeleted()) {
                            if (MessageAnalyzer.isLimitOrder(aExe)) {
                                this.mGotLimitDelete = true;
                                if (this.mGotStoptDelete) {
                                    this.setSuccess(true);
                                }
                            } else {
                                this.mGotStoptDelete = true;
                                if (this.mGotLimitDelete) {
                                    this.setSuccess(true);
                                }
                            }
                        } else if (aExe.getOrdStatus().isActive()) {
                            if (MessageAnalyzer.isLimitOrder(aExe)) {
                                System.out.println("\nclient: deleting a limit order");
                                OrderCancelRequest ocr = MessageGenerator.generateOrderCancelRequest("test custom text delete limit", aExe.getOrderID(), aExe.getSide(), aExe.getAccount());
                                ocr.setOrderID(aExe.getOrderID());
                                ocr.setOrigClOrdID(aExe.getClOrdID());
                                ocr.setSide(aExe.getSide());
                                ocr.setInstrument(aExe.getInstrument());
                                ocr.setAccount(aExe.getAccount());
                                ocr.setOrderQty(aExe.getOrderQty());
                                this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ocr);
                            } else {
                                System.out.println("\nclient: deleting a stop order");
                                OrderCancelRequest ocr = MessageGenerator.generateOrderCancelRequest("test custom text delete stop", aExe.getOrderID(), aExe.getSide(), aExe.getAccount());
                                ocr.setOrderID(aExe.getOrderID());
                                ocr.setOrigClOrdID(aExe.getClOrdID());
                                ocr.setSide(aExe.getSide());
                                ocr.setInstrument(aExe.getInstrument());
                                ocr.setAccount(aExe.getAccount());
                                ocr.setOrderQty(aExe.getOrderQty());
                                this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ocr);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testDeleteSLMarketOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mLimitId;
            private String mStopId;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                if (QATest.safeEquals(this.mStopId, aExe.getRequestID()) || QATest.safeEquals(this.mLimitId, aExe.getRequestID())) {
                    System.out.println("client: inc exe rpt = " + aExe);
                    try {
                        if (MessageAnalyzer.isStopLimitCloseOrder(aExe)) {
                            if (aExe.getFXCMOrdStatus().isDeleted()) {
                                if (MessageAnalyzer.isLimitOrder(aExe)) {
                                    this.mGotLimitDelete = true;
                                    if (this.mGotStoptDelete) {
                                        this.setSuccess(true);
                                    }
                                } else {
                                    this.mGotStoptDelete = true;
                                    if (this.mGotLimitDelete) {
                                        this.setSuccess(true);
                                    }
                                }
                            } else if (aExe.getOrdStatus().isActive()) {
                                if (MessageAnalyzer.isLimitOrder(aExe)) {
                                    System.out.println("client: deleting a limit order");
                                    OrderCancelRequest ocr = MessageGenerator.generateOrderCancelRequest("test custom text delete limit", aExe.getOrderID(), aExe.getSide(), aExe.getAccount());
                                    ocr.setOrderID(aExe.getOrderID());
                                    ocr.setOrigClOrdID(aExe.getClOrdID());
                                    ocr.setSide(aExe.getSide());
                                    ocr.setInstrument(aExe.getInstrument());
                                    ocr.setAccount(aExe.getAccount());
                                    ocr.setOrderQty(aExe.getOrderQty());
                                    this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ocr);
                                } else {
                                    System.out.println("client: deleting a stop order");
                                    OrderCancelRequest ocr = MessageGenerator.generateOrderCancelRequest("test custom text delete stop", aExe.getOrderID(), aExe.getSide(), aExe.getAccount());
                                    ocr.setOrderID(aExe.getOrderID());
                                    ocr.setOrigClOrdID(aExe.getClOrdID());
                                    ocr.setSide(aExe.getSide());
                                    ocr.setInstrument(aExe.getInstrument());
                                    ocr.setAccount(aExe.getAccount());
                                    ocr.setOrderQty(aExe.getOrderQty());
                                    this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ocr);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID())) {
                    System.out.println("client: inc pos report = " + aPositionReport);
                    try {
                        System.out.println("\nclient: trying to set a stop on the open position");
                        OrderSingle order = MessageGenerator.generateStopLimitClose(this.add(aPositionReport.getSettlPrice(), -0.008, aPositionReport.getInstrument().getSymbol()), aPositionReport.getFXCMPosID(), OrdTypeFactory.STOP, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), SideFactory.BUY, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: stop  order reqId = " + this.mStopId + "\n\n");
                        System.out.println("\nclient: trying to set a limit on the open position");
                        order = MessageGenerator.generateStopLimitClose(this.add(aPositionReport.getSettlPrice(), 0.008, aPositionReport.getInstrument().getSymbol()), aPositionReport.getFXCMPosID(), OrdTypeFactory.LIMIT, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), SideFactory.BUY, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: limit order reqId = " + this.mLimitId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testHistoricalSnapshot() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final Date mStartDate;
            private String mClosedID;
            private final UTCDate mFxcmStartDate;
            private final UTCTimeOnly mFxcmStartTime;
            private final int mFxcmMaxNoResults = 300;
            private int mTotalReports;

            GenericListener() {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -1);
                System.out.println("calendar.getTime() = " + calendar.getTime());
                this.mStartDate = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0).getTime();
                this.mFxcmStartDate = new UTCDate(this.mStartDate);
                this.mFxcmStartTime = new UTCTimeOnly(this.mStartDate);
            }

            @Override
            public void process(RequestForPositionsAck aRequestForPositionsAck) {
                if (QATest.safeEquals(this.mClosedID, aRequestForPositionsAck.getRequestID())) {
                    this.mTotalReports += aRequestForPositionsAck.getTotalNumPosReports();
                    System.out.println("aRequestForPositionsAck.getTotalNumPosReports() = " + aRequestForPositionsAck.getTotalNumPosReports());
                    if (aRequestForPositionsAck.getTotalNumPosReports() == 0) {
                        this.setSuccess(true);
                        System.out.println("Total Reports Received = " + this.mTotalReports);
                    }
                }
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
                Calendar calendar = Calendar.getInstance();
                Date date = calendar.getTime();
                UTCDate fxcmEndDate = new UTCDate(date);
                UTCTimeOnly fxcmEndTime = new UTCTimeOnly(date);
                System.out.println("fxcmStartDate = " + this.mFxcmStartDate);
                System.out.println("fxcmStartTime = " + this.mFxcmStartTime);
                System.out.println("fxcmEndDate = " + fxcmEndDate);
                System.out.println("fxcmEndTime = " + fxcmEndTime);
                this.mClosedID = QATest.this.mFxcmGateway.requestClosedPositions(300, this.mFxcmStartDate, this.mFxcmStartTime, fxcmEndDate, fxcmEndTime);
                System.out.println("closedID = " + this.mClosedID);
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                if (QATest.safeEquals(this.mClosedID, aClosedPositionReport.getRequestID()) && aClosedPositionReport.isLastRptRequested()) {
                    super.process(aClosedPositionReport);
                    UTCDate fxcmEndDate = new UTCDate(aClosedPositionReport.getFXCMPosCloseTime());
                    UTCTimeOnly fxcmEndTime = new UTCTimeOnly(aClosedPositionReport.getFXCMPosCloseTime());
                    System.out.println("fxcmStartDate = " + this.mFxcmStartDate);
                    System.out.println("fxcmStartTime = " + this.mFxcmStartTime);
                    System.out.println("fxcmEndDate = " + fxcmEndDate);
                    System.out.println("fxcmEndTime = " + fxcmEndTime);
                    this.mClosedID = QATest.this.mFxcmGateway.requestClosedPositions(300, this.mFxcmStartDate, this.mFxcmStartTime, fxcmEndDate, fxcmEndTime);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testInterestRateChange() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            GenericListener() {
            }

            @Override
            public void process(SecurityStatus aSecurityStatus) {
                super.process(aSecurityStatus);
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testListen() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                System.out.println("client inc: aMarketDataSnapshot = " + aMarketDataSnapshot);
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testRequestEquity() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            boolean proc = true;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                if (QATest.safeEquals(QATest.this.mAccountMassID, aCollateralReport.getRequestID()) && this.proc) {
                    this.proc = false;
                    System.out.println("1 aCollateralReport.getEndCash() = " + aCollateralReport.getEndCash());
                    CollateralInquiry ci = new CollateralInquiry();
                    ci.setAccount(aCollateralReport.getAccount());
                    try {
                        QATest.this.mFxcmGateway.sendMessage((ITransportable)ci);
                    }
                    catch (Exception aE) {
                        aE.printStackTrace();
                    }
                } else if (aCollateralReport.getRequestID() != null) {
                    System.out.println("2 aCollateralReport.getEndCash() = " + aCollateralReport.getEndCash());
                } else {
                    System.out.println("3 aCollateralReport.getEndCash() = " + aCollateralReport.getEndCash());
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testMarketDataRequest() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private String mMarketDataRequestID;

            GenericListener() {
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                try {
                    MarketDataRequest mdr = new MarketDataRequest();
                    Enumeration securities = aTradingSessionStatus.getSecurities();
                    while (securities.hasMoreElements()) {
                        TradingSecurity o = (TradingSecurity)securities.nextElement();
                        mdr.addRelatedSymbol((Instrument)o);
                    }
                    mdr.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SUBSCRIBE);
                    mdr.setMDEntryTypeSet(7);
                    this.mMarketDataRequestID = QATest.this.mFxcmGateway.sendMessage((ITransportable)mdr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                if (QATest.safeEquals(aMarketDataSnapshot.getRequestID(), this.mMarketDataRequestID)) {
                    System.out.println("client inc: aMarketDataSnapshot = " + aMarketDataSnapshot);
                    if (aMarketDataSnapshot.getFXCMContinuousFlag() == 2) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testMarketDataHistory() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final UTCDate mStartDate;
            private final UTCTimeOnly mStartTime;
            private int mCount;
            private UTCTimestamp mOpenTimestamp;

            GenericListener() {
                GregorianCalendar instance = (GregorianCalendar)GregorianCalendar.getInstance();
                instance.roll(2, -1);
                this.mStartDate = new UTCDate(instance.getTime());
                this.mStartTime = new UTCTimeOnly(instance.getTime());
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
                try {
                    MarketDataRequest mdr = new MarketDataRequest();
                    mdr.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SNAPSHOT);
                    mdr.setResponseFormat("U55");
                    mdr.setFXCMTimingInterval(FXCMTimingIntervalFactory.TICK);
                    mdr.setMDEntryTypeSet(7);
                    mdr.setFXCMStartDate(this.mStartDate);
                    mdr.setFXCMStartTime(this.mStartTime);
                    mdr.addRelatedSymbol((Instrument)this.mTradingSessionStatus.getSecurity("EUR/USD"));
                    QATest.this.mFxcmGateway.sendMessage((ITransportable)mdr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataRequestReject aMarketDataRequestReject) {
                System.out.println("aMarketDataRequestReject = " + aMarketDataRequestReject);
                this.setSuccess(true);
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                if (aMarketDataSnapshot.getRequestID() != null) {
                    ++this.mCount;
                    if (this.mOpenTimestamp == null) {
                        System.out.println(aMarketDataSnapshot);
                        this.mOpenTimestamp = aMarketDataSnapshot.getOpenTimestamp();
                        System.out.println("\n-----------------------------------");
                        System.out.println("first\t= " + aMarketDataSnapshot.getOpenTimestamp() + " = " + aMarketDataSnapshot.getRequestID());
                    }
                    if (aMarketDataSnapshot.getFXCMContinuousFlag() == 2) {
                        System.out.println(aMarketDataSnapshot);
                        System.out.println("\nlast\t= " + aMarketDataSnapshot.getOpenTimestamp() + " = " + aMarketDataSnapshot.getRequestID());
                        MarketDataRequest mdr = new MarketDataRequest();
                        mdr.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SNAPSHOT);
                        mdr.setResponseFormat("U55");
                        mdr.setFXCMTimingInterval(FXCMTimingIntervalFactory.TICK);
                        mdr.setMDEntryTypeSet(7);
                        mdr.setFXCMStartDate(this.mStartDate);
                        mdr.setFXCMStartTime(this.mStartTime);
                        mdr.setFXCMEndDate(new UTCDate(this.mOpenTimestamp));
                        mdr.setFXCMEndTime(new UTCTimeOnly(this.mOpenTimestamp));
                        mdr.addRelatedSymbol((Instrument)this.mTradingSessionStatus.getSecurity("EUR/USD"));
                        System.out.println("FXCMStartDate\t= " + mdr.getFXCMStartDate());
                        System.out.println("FXCMStartTime\t= " + mdr.getFXCMStartTime());
                        System.out.println("FXCMEndDate\t\t= " + mdr.getFXCMEndDate());
                        System.out.println("FXCMEndTime\t\t= " + mdr.getFXCMEndTime());
                        this.mOpenTimestamp = null;
                        System.out.println("-----------------------------------\ntotal mds received = " + this.mCount);
                        System.out.println("\nout >> " + mdr);
                        try {
                            QATest.this.mFxcmGateway.sendMessage((ITransportable)mdr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOCO() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private String mRequestId;
            private final List mOrderRequests = new ArrayList();
            private boolean mOrder = true;
            private final List mAccounts = new ArrayList();

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty() && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderList ol = new OrderList();
                        ol.setContingencyType(ContingencyTypeFactory.OCO);
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "entry order - contingency - stop loss");
                        ol.addOrder(stop);
                        this.mOrderRequests.add(stop.getSecondaryClOrdID());
                        OrderSingle limit = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "entry order - contingency - limit profit");
                        ol.addOrder(limit);
                        this.mOrderRequests.add(limit.getSecondaryClOrdID());
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: submitting OCO order = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                if (this.mOrderRequests.contains(aExecutionReport.getSecondaryClOrdID())) {
                    System.out.println("CLIENT: OL ExecutionReport = " + aExecutionReport);
                    System.out.println("aExecutionReport.getFXCMContingencyID() = " + aExecutionReport.getFXCMContingencyID());
                    System.out.println("aExecutionReport.getListID() = " + aExecutionReport.getListID());
                    System.out.println("aExecutionReport.getRequestID() = " + aExecutionReport.getRequestID());
                    System.out.println("mOrderRequests = " + this.mOrderRequests);
                    this.mOrderRequests.remove(aExecutionReport.getSecondaryClOrdID());
                    if (this.mOrderRequests.isEmpty()) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                if (this.mOrderRequests.contains(aPositionReport.getSecondaryClOrdID())) {
                    System.out.println("CLIENT: OL PositionReport = " + aPositionReport);
                    System.out.println("aPositionReport.getListID() = " + aPositionReport.getListID());
                    System.out.println("aPositionReport.getRequestID() = " + aPositionReport.getRequestID());
                    System.out.println("mOrderRequests = " + this.mOrderRequests);
                    this.mOrderRequests.remove(aPositionReport.getSecondaryClOrdID());
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testComplexOCO() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private boolean mOrder = true;
            private String mNewContingencyID;
            private String mListID1;
            private String mListID2;
            private ExecutionReport mOrder1;
            private ExecutionReport mOrder2;
            private boolean mOCOSuccess;
            private final List mAccounts = new ArrayList();

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        this.mListID1 = this.sendOrder(acct, aMarketDataSnapshot);
                        System.out.println("client: good order requestid = " + this.mListID1);
                        this.mListID2 = this.sendOrder(acct, aMarketDataSnapshot);
                        System.out.println("client: good order requestid = " + this.mListID2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            private String sendOrder(CollateralReport aCollateralReport, MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    OrderList ol = new OrderList();
                    ol.setContingencyType(ContingencyTypeFactory.ELS);
                    OrderSingle primary = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", "primary order");
                    primary.setClOrdLinkID("1");
                    ol.addOrder(primary);
                    OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.SELL, "EUR/USD", "entry order - contingency - stop loss");
                    stop.setClOrdLinkID("2");
                    ol.addOrder(stop);
                    OrderSingle limit = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.SELL, "EUR/USD", "entry order - contingency - limit profit");
                    limit.setClOrdLinkID("2");
                    ol.addOrder(limit);
                    return QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                if (aExecutionReport.getListID() != null) {
                    if (aExecutionReport.getListID().equals(this.mListID1) && "primary order".equals(aExecutionReport.getSecondaryClOrdID())) {
                        this.mOrder1 = aExecutionReport;
                        if (!this.mOCOSuccess) {
                            this.mNewContingencyID = aExecutionReport.getFXCMContingencyID();
                            if (this.mNewContingencyID == null) {
                                this.makeOCO(aExecutionReport);
                            } else {
                                this.makeOCO(this.mOrder2);
                            }
                        }
                    }
                    if (aExecutionReport.getListID().equals(this.mListID2) && "primary order".equals(aExecutionReport.getSecondaryClOrdID())) {
                        this.mOrder2 = aExecutionReport;
                    }
                }
                if (this.mOrder1 != null && this.mOrder2 != null) {
                    if (this.mOrder1.getFXCMContingencyID() != null && this.mOrder2.getFXCMContingencyID() != null && this.mOrder1.getFXCMContingencyID().equals(this.mOrder2.getFXCMContingencyID())) {
                        this.mOCOSuccess = true;
                        this.removeOCO(this.mOrder1);
                        this.removeOCO(this.mOrder2);
                    }
                    if (this.mOCOSuccess && this.mOrder1.getFXCMContingencyID() == null && this.mOrder2.getFXCMContingencyID() == null) {
                        this.setSuccess(true);
                    }
                }
            }

            private void makeOCO(ExecutionReport aExecutionReport) {
                OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest(aExecutionReport.getText(), aExecutionReport.getOrderID(), aExecutionReport.getSide(), aExecutionReport.getOrdType(), aExecutionReport.getPrice(), aExecutionReport.getAccount());
                os.setContingencyType(ContingencyTypeFactory.OCO);
                if (this.mNewContingencyID != null) {
                    os.setFXCMContingencyID(this.mNewContingencyID);
                }
                try {
                    QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            private void removeOCO(ExecutionReport aExecutionReport) {
                OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest(aExecutionReport.getText(), aExecutionReport.getOrderID(), aExecutionReport.getSide(), aExecutionReport.getOrdType(), aExecutionReport.getPrice(), aExecutionReport.getAccount());
                if (this.mNewContingencyID != null) {
                    os.setFXCMContingencyID(this.mNewContingencyID);
                }
                try {
                    QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOpenCloseMarket() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            GenericListener() {
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOpenLimit() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty()) {
                        System.out.println("client: incoming mds = " + aMarketDataSnapshot);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(aMarketDataSnapshot.getAskClose(), acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        orderSingle.setOrdType(OrdTypeFactory.LIMIT);
                        orderSingle.setTimeInForce(TimeInForceFactory.FILL_OR_KILL);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOpenRangeOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && symbol.equals("EUR/USD")) {
                        System.out.println("client: incoming mds = " + aMarketDataSnapshot);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(0.0, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        orderSingle.setOrdType(OrdTypeFactory.STOP_LIMIT);
                        double market = aMarketDataSnapshot.getAskClose();
                        double limitPx = this.add(market, 8.0E-4, aMarketDataSnapshot.getInstrument().getSymbol());
                        double stopPx = this.add(market, -8.0E-4, aMarketDataSnapshot.getInstrument().getSymbol());
                        orderSingle.setPrice(limitPx);
                        orderSingle.setStopPx(stopPx);
                        System.out.println("\ncurrent price = " + market);
                        System.out.println("SENT PX             :: " + orderSingle.getPrice());
                        System.out.println("SENT STOPPX         :: " + orderSingle.getStopPx());
                        System.out.println("");
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    System.out.println("aPositionReport.getSettlPrice() = " + aPositionReport.getSettlPrice());
                    System.out.println("\n\n");
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                System.out.println("\nGOT PX     :: " + aExecutionReport.getPrice());
                System.out.println("GOT STOPPX :: " + aExecutionReport.getStopPx() + "\n");
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testRangeEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && symbol.indexOf("EUR/USD") == 0) {
                        System.out.println("client: incoming mds = " + aMarketDataSnapshot);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(0.0, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        orderSingle.setOrdType(OrdTypeFactory.STOP_LIMIT);
                        orderSingle.setTimeInForce(TimeInForceFactory.GOOD_TILL_CANCEL);
                        double market = aMarketDataSnapshot.getAskClose();
                        double stop = this.add(market, 8.0E-4, aMarketDataSnapshot.getInstrument().getSymbol());
                        double limit = this.add(market, 6.0E-4, aMarketDataSnapshot.getInstrument().getSymbol());
                        orderSingle.setPrice(limit);
                        orderSingle.setStopPx(stop);
                        orderSingle.setTimeInForce(TimeInForceFactory.GOOD_TILL_DATE);
                        Calendar calendar = GregorianCalendar.getInstance();
                        calendar.add(5, 2);
                        orderSingle.setExpireDate(new UTCDate(calendar.getTime()));
                        System.out.println("current price = " + market);
                        System.out.println("SENT PX             :: " + orderSingle.getPrice());
                        System.out.println("SENT STOPPX         :: " + orderSingle.getStopPx());
                        System.out.println("");
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                System.out.println("GOT PX     :: " + aExecutionReport.getPrice());
                System.out.println("GOT STOPPX :: " + aExecutionReport.getStopPx());
                if (QATest.safeEquals(this.mRequestId, aExecutionReport.getRequestID()) && aExecutionReport.getFXCMOrdStatus() == FXCMOrdStatusFactory.WAITING) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testAtMarketPointsOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && !this.mAccounts.isEmpty()) {
                        System.out.println("client: incoming mds = " + aMarketDataSnapshot);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(aMarketDataSnapshot.getAskClose(), acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem, 100);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    System.out.println("aPositionReport.getSettlPrice() = " + aPositionReport.getSettlPrice());
                    System.out.println("\n\n");
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(aExecutionReport.getRequestID(), this.mRequestId)) {
                    System.out.println("aExecutionReport.getPrice() = " + aExecutionReport.getPrice());
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOrderHistory() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mHistoryRequestId;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                if (this.mOrder) {
                    this.mOrder = false;
                    OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", "true market order test");
                    try {
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                DecimalFormat df = new DecimalFormat();
                System.out.println("aExe = " + aExecutionReport);
                System.out.println("********************************************");
                System.out.println("exe.getOrderID() = " + aExecutionReport.getOrderID());
                System.out.println("exe.getOrderStatus() = " + aExecutionReport.getOrdStatus());
                System.out.println("exe.getFXCMPosID() = " + aExecutionReport.getFXCMPosID());
                System.out.println("exe.getAccount() = " + aExecutionReport.getAccount());
                System.out.println("exe.getTransactTime() = " + aExecutionReport.getTransactTime());
                System.out.println("exe.getRequestID() = " + aExecutionReport.getRequestID());
                System.out.println("exe.getExecType() = " + aExecutionReport.getExecType());
                System.out.println("exe.getFXCMOrdStatus() = " + aExecutionReport.getFXCMOrdStatus());
                System.out.println("exe.getOrdStatus() = " + aExecutionReport.getOrdStatus());
                System.out.println("exe.getPrice() = " + aExecutionReport.getPrice());
                System.out.println("exe.getOrderQty() = " + df.format(aExecutionReport.getOrderQty()));
                System.out.println("exe.getCumQty() = " + df.format(aExecutionReport.getCumQty()));
                System.out.println("exe.getLastQty() = " + df.format(aExecutionReport.getLastQty()));
                System.out.println("exe.getLeavesQty() = " + df.format(aExecutionReport.getLeavesQty()));
                System.out.println("exe.getOrderPercent() = " + aExecutionReport.getOrderPercent());
                System.out.println("********************************************\n\n");
                if (QATest.safeEquals(aExecutionReport.getRequestID(), this.mHistoryRequestId) && aExecutionReport.isLastRptRequested()) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getRequestID(), this.mRequestId)) {
                    OrderMassStatusRequest omsr = new OrderMassStatusRequest();
                    omsr.setAccount(aPositionReport.getAccount());
                    omsr.setOrderID(aPositionReport.getOrderID());
                    try {
                        this.mHistoryRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)omsr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOrderList() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private final List mOrderRequests = new ArrayList();

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                if (this.mOrder) {
                    this.mOrder = false;
                    OrderList ol = new OrderList();
                    int total = 10;
                    long seed = System.currentTimeMillis();
                    for (int i = 0; i < total; ++i) {
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", seed + "#order#" + i);
                        this.mOrderRequests.add(orderSingle.getSecondaryClOrdID());
                        ol.addOrder(orderSingle);
                    }
                    try {
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: submitting order list with 10 new orders = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                System.out.println("client inc: aPositionReport = " + aPositionReport);
                if (this.mOrderRequests.remove(aPositionReport.getSecondaryClOrdID()) && this.mOrderRequests.isEmpty()) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOTO() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private boolean mGotStop;
            private boolean mGotLimit;
            private boolean mGotPrimary;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        OrderList ol = new OrderList();
                        ol.setContingencyType(ContingencyTypeFactory.OTO);
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle primary = MessageGenerator.generateMarketOrder(acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "primary order");
                        primary.setClOrdLinkID("1");
                        ol.addOrder(primary);
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.005, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "oto stop");
                        stop.setClOrdLinkID("2");
                        ol.addOrder(stop);
                        OrderSingle limit = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.005, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "oto limit");
                        limit.setClOrdLinkID("2");
                        ol.addOrder(limit);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (aExecutionReport.getListID() != null && aExecutionReport.getListID().equalsIgnoreCase(this.mRequestId)) {
                    if ("primary order".equals(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotPrimary = true;
                    } else if ("oto stop".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotStop = true;
                    } else if ("oto limit".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotLimit = true;
                    }
                    if (this.mGotPrimary && this.mGotStop && this.mGotLimit) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testIfThen() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private boolean mGotStop;
            private boolean mGotLimit;
            private boolean mGotPrimary;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        OrderList ol = new OrderList();
                        ol.setContingencyType(ContingencyTypeFactory.OTO);
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle primary = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.009, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), 0.0, SideFactory.SELL, aMarketDataSnapshot.getInstrument().getSymbol(), "if order");
                        primary.setClOrdLinkID("1");
                        ol.addOrder(primary);
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.002, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "then order");
                        stop.setClOrdLinkID("2");
                        ol.addOrder(stop);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (aExecutionReport.getListID() != null && aExecutionReport.getListID().equalsIgnoreCase(this.mRequestId)) {
                    if ("primary order".equals(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotPrimary = true;
                    } else if ("oto stop".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotStop = true;
                    } else if ("oto limit".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotLimit = true;
                    }
                    if (!this.mGotPrimary || !this.mGotStop || this.mGotLimit) {
                        // empty if block
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testIfThenOCO() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private boolean mGotStop1;
            private boolean mGotStop2;
            private boolean mGotPrimary;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        OrderList ol = new OrderList();
                        ol.setContingencyType(ContingencyTypeFactory.OTOCO);
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle primary = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.009, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), 0.0, SideFactory.SELL, aMarketDataSnapshot.getInstrument().getSymbol(), "if order");
                        primary.setClOrdLinkID("1");
                        ol.addOrder(primary);
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "oto stop1");
                        stop.setClOrdLinkID("2");
                        ol.addOrder(stop);
                        OrderSingle stop2 = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.003, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "oto stop2");
                        stop2.setClOrdLinkID("2");
                        ol.addOrder(stop2);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (aExecutionReport.getListID() != null && aExecutionReport.getListID().equalsIgnoreCase(this.mRequestId)) {
                    if ("primary order".equals(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotPrimary = true;
                    } else if ("oto stop1".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotStop1 = true;
                    } else if ("oto stop2".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotStop2 = true;
                    }
                    if (this.mGotPrimary && this.mGotStop1 && this.mGotStop2) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOTOCO() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private boolean mGotStop1;
            private boolean mGotStop2;
            private boolean mGotPrimary;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        OrderList ol = new OrderList();
                        ol.setContingencyType(ContingencyTypeFactory.OTOCO);
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "primary order");
                        orderSingle.setClOrdLinkID("1");
                        ol.addOrder(orderSingle);
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "oto stop1");
                        stop.setClOrdLinkID("2");
                        ol.addOrder(stop);
                        OrderSingle stop2 = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.003, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "oto stop2");
                        stop2.setClOrdLinkID("2");
                        ol.addOrder(stop2);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (aExecutionReport.getListID() != null && aExecutionReport.getListID().equalsIgnoreCase(this.mRequestId)) {
                    if ("primary order".equals(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotPrimary = true;
                    } else if ("oto stop1".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotStop1 = true;
                    } else if ("oto stop2".equalsIgnoreCase(aExecutionReport.getSecondaryClOrdID())) {
                        this.mGotStop2 = true;
                    }
                    if (this.mGotPrimary && this.mGotStop1 && this.mGotStop2) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testELS() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        OrderList ol = new OrderList();
                        ol.setContingencyType(ContingencyTypeFactory.ELS);
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle primary = MessageGenerator.generateMarketOrder(acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), "primary order");
                        primary.setClOrdLinkID("1");
                        ol.addOrder(primary);
                        OrderSingle stop = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, aMarketDataSnapshot.getInstrument().getSymbol(), "entry order - contingency - stop loss");
                        stop.setClOrdLinkID("2");
                        ol.addOrder(stop);
                        OrderSingle limit = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), 0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, aMarketDataSnapshot.getInstrument().getSymbol(), "entry order - contingency - limit profit");
                        limit.setClOrdLinkID("2");
                        ol.addOrder(limit);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getListID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testELSPeg() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                if (this.mOrder) {
                    this.mOrder = false;
                    OrderList ol = new OrderList();
                    ol.setContingencyType(ContingencyTypeFactory.ELS);
                    OrderSingle primary = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", "primary order");
                    primary.setClOrdLinkID("1");
                    ol.addOrder(primary);
                    OrderSingle stop = MessageGenerator.generateStopLimitEntry(0.0, OrdTypeFactory.STOP, aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.SELL, "EUR/USD", "entry order - contingency - stop loss");
                    stop.setClOrdLinkID("2");
                    PegInstruction pegStop = new PegInstruction();
                    pegStop.setPegPriceType(4);
                    pegStop.setFXCMPegFluctuatePts(10);
                    stop.setPegInstructions(pegStop);
                    stop.setPrice(1.11);
                    ol.addOrder(stop);
                    OrderSingle limit = MessageGenerator.generateStopLimitEntry(0.0, OrdTypeFactory.LIMIT, aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.SELL, "EUR/USD", "entry order - contingency - limit profit");
                    limit.setClOrdLinkID("2");
                    PegInstruction pegLimit = new PegInstruction();
                    pegLimit.setFXCMPegFluctuatePts(10);
                    limit.setPegInstructions(pegLimit);
                    limit.setPrice(1.21);
                    ol.addOrder(limit);
                    try {
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ol);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getListID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testOrderStatusRequest() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mRequestOrder = true;
            private String mRequestId;
            private String mOrdStatReqId;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                super.process(aCollateralReport);
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        this.mOrdStatReqId = QATest.this.mFxcmGateway.requestOrderStatus(this.mRequestId, OrdStatusRequestType.CLORDID, aCollateralReport.getAccount());
                        System.out.println("client: market order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                if (QATest.safeEquals(this.mRequestId, aClosedPositionReport.getRequestID()) && this.mRequestOrder) {
                    System.out.println("aClosedPositionReport = " + aClosedPositionReport);
                    this.mRequestOrder = false;
                    this.mOrdStatReqId = QATest.this.mFxcmGateway.requestOrderStatus(aClosedPositionReport.getClOrdID(), OrdStatusRequestType.CLORDID, aClosedPositionReport.getAccount());
                    System.out.println("mOrdStatReqId = " + this.mOrdStatReqId);
                    System.out.println("\n");
                }
            }

            @Override
            public void process(ExecutionReport aExe) {
                if (QATest.safeEquals(this.mRequestId, aExe.getRequestID()) && this.mRequestOrder && aExe.getOrdStatus() == OrdStatusFactory.FILLED) {
                    System.out.println("\n\nclient: streaming aExecutionReport =\n" + aExe);
                    System.out.println("aExe.getInstrument() = " + aExe.getInstrument());
                    System.out.println("aExe.getTransactTime() = " + aExe.getTransactTime());
                    System.out.println("aExe.getExecType() = " + aExe.getExecType());
                    System.out.println("aExecutionReport.getOrderID() = " + aExe.getOrderID());
                    System.out.println("aExecutionReport.getClOrdID() = " + aExe.getClOrdID());
                    System.out.println("aExecutionReport.getOrdStatusReqID() = " + aExe.getOrdStatusReqID());
                    System.out.println("aExecutionReport.getSecondaryClOrdID() = " + aExe.getSecondaryClOrdID());
                    this.mRequestOrder = false;
                    this.mOrdStatReqId = QATest.this.mFxcmGateway.requestOrderStatus(aExe.getClOrdID(), OrdStatusRequestType.CLORDID, aExe.getAccount());
                    System.out.println("mOrdStatReqId = " + this.mOrdStatReqId);
                    try {
                        OrderSingle close = MessageGenerator.generateCloseMarketOrder(aExe.getFXCMPosID(), aExe.getAccount(), aExe.getCumQty(), SideFactory.SELL, aExe.getInstrument().getSymbol(), "close it");
                        QATest.this.mFxcmGateway.sendMessage((ITransportable)close);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("\n");
                }
                if (QATest.safeEquals(this.mOrdStatReqId, aExe.getOrdStatusReqID())) {
                    System.out.println("\n\nclient: received order status request response =\n" + aExe);
                    System.out.println("aExe.getOrdStatus() = " + aExe.getOrdStatus());
                    System.out.println("aExe.getInstrument() = " + aExe.getInstrument());
                    System.out.println("aExe.getTransactTime() = " + aExe.getTransactTime());
                    System.out.println("aExe.getExecType() = " + aExe.getExecType());
                    System.out.println("aExecutionReport.getOrderID() = " + aExe.getOrderID());
                    System.out.println("aExecutionReport.getClOrdID() = " + aExe.getClOrdID());
                    System.out.println("aExecutionReport.getOrdStatusReqID() = " + aExe.getOrdStatusReqID());
                    System.out.println("aExecutionReport.getSecondaryClOrdID() = " + aExe.getSecondaryClOrdID());
                    System.out.println("aExe = " + aExe);
                    System.out.println("\n");
                    this.setSuccess(true);
                } else {
                    System.out.println(aExe);
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testPurgeAll() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrdersDone;
            private boolean mPositionsDone;
            private String mRequestID;

            GenericListener() {
            }

            @Override
            public void process(RequestForPositionsAck aRequestForPositionsAck) {
                super.process(aRequestForPositionsAck);
                if (QATest.safeEquals(QATest.this.mOpenPositionMassID, aRequestForPositionsAck.getRequestID())) {
                    if (aRequestForPositionsAck.getTotalNumPosReports() == 0) {
                        this.mPositionsDone = true;
                    }
                    if (this.mPositionsDone && this.mOrdersDone) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                this.mTradingSessionStatus = aTradingSessionStatus;
                QATest.this.mOpenPositionMassID = QATest.this.mFxcmGateway.requestOpenPositions();
                QATest.this.mOpenOrderMassID = QATest.this.mFxcmGateway.requestOpenOrders();
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                try {
                    if (QATest.safeEquals(QATest.this.mOpenOrderMassID, aExecutionReport.getRequestID())) {
                        if (MessageAnalyzer.isStopLimitEntryOrder(aExecutionReport) && !aExecutionReport.getFXCMOrdStatus().isDeleted()) {
                            OrderCancelRequest ocr = new OrderCancelRequest();
                            System.out.println("client: deleting the entry order");
                            ocr.setOrderID(aExecutionReport.getOrderID());
                            ocr.setSecondaryClOrdID("text custom text delete order");
                            ocr.setOrigClOrdID(aExecutionReport.getClOrdID());
                            ocr.setSide(aExecutionReport.getSide());
                            ocr.setInstrument(aExecutionReport.getInstrument());
                            ocr.setAccount(aExecutionReport.getAccount());
                            ocr.setOrderQty(aExecutionReport.getOrderQty());
                            String reqId = QATest.this.mFxcmGateway.sendMessage((ITransportable)ocr);
                            System.out.println("client: del reqId = " + reqId);
                        }
                        if (aExecutionReport.isLastRptRequested()) {
                            if (aExecutionReport.getTotNumReports() > 0) {
                                QATest.this.mOpenOrderMassID = QATest.this.mFxcmGateway.requestOpenOrders();
                            } else {
                                this.mOrdersDone = true;
                            }
                        }
                        if (this.mPositionsDone && this.mOrdersDone) {
                            this.setSuccess(true);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                try {
                    if (QATest.safeEquals(QATest.this.mOpenPositionMassID, aPositionReport.getRequestID())) {
                        boolean isFIFO;
                        System.out.println("client: closing the open position");
                        ISide side = aPositionReport.getPositionQty().getSide() == SideFactory.BUY ? SideFactory.SELL : SideFactory.BUY;
                        String id = aPositionReport.getFXCMPosID();
                        boolean bl = isFIFO = "N".equalsIgnoreCase(this.mTradingSessionStatus.getParameterValue("TP_94")) && "N".equalsIgnoreCase(this.mTradingSessionStatus.getParameterValue("TP_172"));
                        if (isFIFO) {
                            id = null;
                        }
                        OrderSingle delOrder = MessageGenerator.generateCloseMarketOrder(id, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), side, aPositionReport.getInstrument().getSymbol(), cem);
                        String requestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)delOrder);
                        if (aPositionReport.isLastRptRequested() && aPositionReport.getTotalNumPosReports() > 0) {
                            this.mRequestID = requestId;
                            System.out.println("client: last requestid = " + requestId);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ClosedPositionReport aClosedPositionReport) {
                super.process(aClosedPositionReport);
                if (this.mRequestID.equals(aClosedPositionReport.getFXCMCloseClOrdID())) {
                    System.out.println("requesting open positions");
                    QATest.this.mOpenPositionMassID = QATest.this.mFxcmGateway.requestOpenPositions();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testReconnect() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mDone;
            private boolean mOrder1 = true;
            private boolean mOrder2;
            private String mRequestId2;
            private String mRequestId1;

            GenericListener() {
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getClOrdID(), this.mRequestId1) && !this.mDone) {
                    System.out.println("attempting relogin");
                    try {
                        QATest.this.mFxcmGateway.relogin();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("done relogin");
                    this.mDone = true;
                    this.mOrder2 = true;
                }
                if (QATest.safeEquals(aPositionReport.getClOrdID(), this.mRequestId2)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                System.out.println(QATest.this.mFxcmGateway.getSessionID() + " " + aMarketDataSnapshot);
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder1) {
                        this.mOrder1 = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId1 = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: order before relogin requestid = " + this.mRequestId1);
                    } else if (this.mOrder2) {
                        this.mOrder2 = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId2 = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: order after relogin  requestid = " + this.mRequestId2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testRejectDealerInterventionRequote() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;

            GenericListener() {
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        String requestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: order requestid = " + requestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(Quote aQuote) {
                super.process(aQuote);
                QuoteResponse msg = MessageGenerator.generatePassResponse(aQuote.getQuoteID());
                try {
                    QATest.this.mFxcmGateway.sendMessage((ITransportable)msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testRejectMarketOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                if (QATest.safeEquals(this.mRequestId, aExecutionReport.getClOrdID())) {
                    super.process(aExecutionReport);
                    if (aExecutionReport.getFXCMOrdStatus() == FXCMOrdStatusFactory.REJECTED) {
                        this.setSuccess(true);
                    }
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("client: incoming mds = " + aMarketDataSnapshot);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateOpenOrder(aMarketDataSnapshot.getQuoteID() + "1", aMarketDataSnapshot.getAskClose(), acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: bad order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testRFQ() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mFirst = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
                this.mTradingSessionStatus = aTradingSessionStatus;
            }

            @Override
            public void process(Quote aQuote) {
                super.process(aQuote);
                try {
                    CollateralReport acct = (CollateralReport)this.getAccounts().get(0);
                    OrderSingle orderSingle = MessageGenerator.generateOpenOrder(aQuote.getQuoteID(), aQuote.getBidPx(), acct.getAccount(), aQuote.getOrderQty(), SideFactory.BUY, aQuote.getInstrument().getSymbol(), cem);
                    this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                    System.out.println("client: good order requestid = " + this.mRequestId);
                    QuoteResponse qr = MessageGenerator.generatePassResponse(aQuote.getQuoteRespID());
                    String delQuoteID = QATest.this.mFxcmGateway.sendMessage((ITransportable)qr);
                    System.out.println("client: delete quote requestid = " + delQuoteID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(aPositionReport.getClOrdID(), this.mRequestId)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                if (this.mFirst && !this.mAccounts.isEmpty()) {
                    try {
                        CollateralReport cr = (CollateralReport)this.getAccounts().get(0);
                        QuoteRequest qr = new QuoteRequest();
                        qr.setAccount(cr.getAccount());
                        qr.setOrderQty2(cr.getQuantity());
                        qr.setInstrument((Instrument)this.mTradingSessionStatus.getSecurity("EUR/CHF"));
                        String reqid = QATest.this.mFxcmGateway.sendMessage((ITransportable)qr);
                        System.out.println("reqid = " + reqid);
                        this.mFirst = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.getAccounts(), this);
            }

            public List getAccounts() {
                return this.mAccounts;
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testSecurityListRequest() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private String mReqID;

            GenericListener() {
            }

            @Override
            public void process(SecurityList aSecurityList) {
                super.process(aSecurityList);
                if (QATest.safeEquals(this.mReqID, aSecurityList.getRequestID())) {
                    System.out.println("securityList = " + aSecurityList);
                    List securities = aSecurityList.getSecurities();
                    for (Object security : securities) {
                        Instrument instrument = (Instrument)security;
                        try {
                            System.out.println(instrument.getSymbol() + " = " + instrument.getFXCMProductID());
                        }
                        catch (NotDefinedException e) {
                            e.printStackTrace();
                        }
                    }
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
                try {
                    SecurityListRequest securityListRequest = new SecurityListRequest(4);
                    this.mReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)securityListRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testSecurityStatusRequest() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private String mReqID;

            GenericListener() {
            }

            @Override
            public void process(SecurityStatus aSecurityStatus) {
                super.process(aSecurityStatus);
                if (QATest.safeEquals(this.mReqID, aSecurityStatus.getRequestID())) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
                try {
                    SecurityStatusRequest ssr = new SecurityStatusRequest("GBP/JPY");
                    this.mReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)ssr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testSetSLEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mLimitReqID;
            private String mStopReqID;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    String requestID = aExe.getRequestID();
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, requestID)) {
                        System.out.println("client: trying to set a limit on the entry order in 2 seconds");
                        OrderSingle limit = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), 0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)limit);
                        System.out.println("client: limit order reqId = " + this.mLimitReqID);
                        System.out.println("client: trying to set a stop on the entry order in 2 seconds");
                        OrderSingle stop = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), -0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        this.mStopReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)stop);
                        System.out.println("client: stop  order reqId = " + this.mStopReqID);
                    } else if (QATest.safeEquals(this.mStopReqID, requestID) || QATest.safeEquals(this.mLimitReqID, requestID)) {
                        if (MessageAnalyzer.isLimitOrder(aExe)) {
                            this.mGotLimitDelete = true;
                            if (this.mGotStoptDelete) {
                                this.setSuccess(true);
                            }
                        } else {
                            this.mGotStoptDelete = true;
                            if (this.mGotLimitDelete) {
                                this.setSuccess(true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("symbol = " + symbol);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testDynamicSetSLTEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mLimitReqID;
            private String mStopReqID;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    String requestID = aExe.getRequestID();
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, requestID)) {
                        System.out.println("client: trying to set a limit on the entry order in 2 seconds");
                        OrderSingle limit = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), 0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegLimit = new PegInstruction();
                        pegLimit.setPegPriceType(4);
                        pegLimit.setPegMoveType(0);
                        pegLimit.setPegOffsetType(1);
                        pegLimit.setPegOffsetValue(this.add(aExe.getPrice(), 0.008, aExe.getInstrument().getSymbol()));
                        pegLimit.setFXCMPegFluctuatePts(1);
                        limit.setPegInstructions(pegLimit);
                        this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)limit);
                        System.out.println("client: limit order reqId = " + this.mLimitReqID);
                        System.out.println("client: trying to set a stop on the entry order in 2 seconds");
                        OrderSingle stop = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), -0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegStop = new PegInstruction();
                        pegStop.setPegPriceType(4);
                        pegStop.setPegMoveType(0);
                        pegStop.setPegOffsetType(1);
                        pegStop.setPegOffsetValue(this.add(aExe.getPrice(), -0.008, aExe.getInstrument().getSymbol()));
                        pegStop.setFXCMPegFluctuatePts(1);
                        stop.setPegInstructions(pegStop);
                        this.mStopReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)stop);
                        System.out.println("client: stop  order reqId = " + this.mStopReqID);
                    } else if (QATest.safeEquals(this.mStopReqID, requestID) || QATest.safeEquals(this.mLimitReqID, requestID)) {
                        if (MessageAnalyzer.isLimitOrder(aExe)) {
                            this.mGotLimitDelete = true;
                            if (this.mGotStoptDelete) {
                                this.setSuccess(true);
                            }
                        } else {
                            this.mGotStoptDelete = true;
                            if (this.mGotLimitDelete) {
                                this.setSuccess(true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("symbol = " + symbol);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testFixedSetSLTEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mLimitReqID;
            private String mStopReqID;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    String requestID = aExe.getRequestID();
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, requestID)) {
                        System.out.println("client: trying to set a limit on the entry order in 2 seconds");
                        OrderSingle limit = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), 0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegLimit = new PegInstruction();
                        pegLimit.setPegPriceType(4);
                        pegLimit.setPegMoveType(0);
                        pegLimit.setPegOffsetType(1);
                        pegLimit.setPegOffsetValue(0.0);
                        pegLimit.setFXCMPegFluctuatePts(10);
                        limit.setPegInstructions(pegLimit);
                        this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)limit);
                        System.out.println("client: limit order reqId = " + this.mLimitReqID);
                        System.out.println("client: trying to set a stop on the entry order in 2 seconds");
                        OrderSingle stop = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), -0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegStop = new PegInstruction();
                        pegStop.setPegPriceType(4);
                        pegStop.setPegMoveType(0);
                        pegStop.setPegOffsetType(1);
                        pegStop.setPegOffsetValue(0.0);
                        pegStop.setFXCMPegFluctuatePts(10);
                        stop.setPegInstructions(pegStop);
                        this.mStopReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)stop);
                        System.out.println("client: stop  order reqId = " + this.mStopReqID);
                    } else if (QATest.safeEquals(this.mStopReqID, requestID) || QATest.safeEquals(this.mLimitReqID, requestID)) {
                        if (MessageAnalyzer.isLimitOrder(aExe)) {
                            this.mGotLimitDelete = true;
                            if (this.mGotStoptDelete) {
                                this.setSuccess(true);
                            }
                        } else {
                            this.mGotStoptDelete = true;
                            if (this.mGotLimitDelete) {
                                this.setSuccess(true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("symbol = " + symbol);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testFixedPtsSetSLTEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mLimitReqID;
            private String mStopReqID;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    String requestID = aExe.getRequestID();
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, requestID)) {
                        System.out.println("client: trying to set a limit on the entry order in 2 seconds");
                        OrderSingle limit = MessageGenerator.generateStopLimitClose(0.0, aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegLimit = new PegInstruction();
                        pegLimit.setPegPriceType(4);
                        pegLimit.setPegMoveType(0);
                        pegLimit.setPegOffsetType(1);
                        pegLimit.setPegOffsetValue(50.0);
                        pegLimit.setFXCMPegFluctuatePts(10);
                        limit.setPegInstructions(pegLimit);
                        this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)limit);
                        System.out.println("client: limit order reqId = " + this.mLimitReqID);
                        System.out.println("client: trying to set a stop on the entry order in 2 seconds");
                        OrderSingle stop = MessageGenerator.generateStopLimitClose(0.0, aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegStop = new PegInstruction();
                        pegStop.setPegPriceType(4);
                        pegStop.setPegMoveType(0);
                        pegStop.setPegOffsetType(1);
                        pegStop.setPegOffsetValue(-50.0);
                        pegStop.setFXCMPegFluctuatePts(10);
                        stop.setPegInstructions(pegStop);
                        this.mStopReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)stop);
                        System.out.println("client: stop  order reqId = " + this.mStopReqID);
                    } else if (QATest.safeEquals(this.mStopReqID, requestID) || QATest.safeEquals(this.mLimitReqID, requestID)) {
                        if (MessageAnalyzer.isLimitOrder(aExe)) {
                            this.mGotLimitDelete = true;
                            if (this.mGotStoptDelete) {
                                this.setSuccess(true);
                            }
                        } else {
                            this.mGotStoptDelete = true;
                            if (this.mGotLimitDelete) {
                                this.setSuccess(true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("symbol = " + symbol);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem, 10);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testDynamicPtsSetSLTEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private String mRequestId;
            private String mLimitReqID;
            private String mStopReqID;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    String requestID = aExe.getRequestID();
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, requestID)) {
                        System.out.println("client: trying to set a limit on the entry order in 2 seconds");
                        OrderSingle limit = MessageGenerator.generateStopLimitClose(0.0, aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegLimit = new PegInstruction();
                        pegLimit.setPegPriceType(4);
                        pegLimit.setPegMoveType(0);
                        pegLimit.setPegOffsetType(1);
                        pegLimit.setPegOffsetValue(50.0);
                        pegLimit.setFXCMPegFluctuatePts(1);
                        limit.setPegInstructions(pegLimit);
                        this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)limit);
                        System.out.println("client: limit order reqId = " + this.mLimitReqID);
                        System.out.println("client: trying to set a stop on the entry order in 2 seconds");
                        OrderSingle stop = MessageGenerator.generateStopLimitClose(0.0, aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        PegInstruction pegStop = new PegInstruction();
                        pegStop.setPegPriceType(4);
                        pegStop.setPegMoveType(0);
                        pegStop.setPegOffsetType(1);
                        pegStop.setPegOffsetValue(-50.0);
                        pegStop.setFXCMPegFluctuatePts(1);
                        stop.setPegInstructions(pegStop);
                        this.mStopReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)stop);
                        System.out.println("client: stop  order reqId = " + this.mStopReqID);
                    } else if (QATest.safeEquals(this.mStopReqID, requestID) || QATest.safeEquals(this.mLimitReqID, requestID)) {
                        if (MessageAnalyzer.isLimitOrder(aExe)) {
                            this.mGotLimitDelete = true;
                            if (this.mGotStoptDelete) {
                                this.setSuccess(true);
                            }
                        } else {
                            this.mGotStoptDelete = true;
                            if (this.mGotLimitDelete) {
                                this.setSuccess(true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        System.out.println("symbol = " + symbol);
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem, 10);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testSetSLMarketOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag = true;
            private String mRequestId;
            private String mLimitReqID;
            private String mStopReqID;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (this.mFlag && QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID())) {
                    try {
                        System.out.println("client: trying to set a stop on the position in 2 seconds");
                        OrderSingle order = MessageGenerator.generateStopLimitClose(this.add(aPositionReport.getSettlPrice(), -0.001, aPositionReport.getInstrument().getSymbol()), aPositionReport.getFXCMPosID(), OrdTypeFactory.STOP, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), SideFactory.BUY, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mStopReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: stop order reqId = " + this.mStopReqID);
                        System.out.println("client: trying to set a limit on the position in 2 seconds");
                        order = MessageGenerator.generateStopLimitClose(this.add(aPositionReport.getSettlPrice(), 0.001, aPositionReport.getInstrument().getSymbol()), aPositionReport.getFXCMPosID(), OrdTypeFactory.LIMIT, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), SideFactory.BUY, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mLimitReqID = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: limit order reqId = " + this.mLimitReqID);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.mFlag = false;
                }
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", null);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (QATest.safeEquals(this.mStopReqID, aExecutionReport.getRequestID()) || QATest.safeEquals(this.mLimitReqID, aExecutionReport.getRequestID())) {
                    if (MessageAnalyzer.isLimitOrder(aExecutionReport)) {
                        this.mGotLimitDelete = true;
                        if (this.mGotStoptDelete) {
                            this.setSuccess(true);
                        }
                    } else {
                        this.mGotStoptDelete = true;
                        if (this.mGotLimitDelete) {
                            this.setSuccess(true);
                        }
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testUpdateRateQtyEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag = true;
            private String mRequestId;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                try {
                    if (this.mOrder && "EUR/USD".equals(aMarketDataSnapshot.getInstrument().getSymbol())) {
                        this.mOrder = false;
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        OrderSingle os = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getBidClose(), -0.001, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.SELL, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, aExe.getRequestID())) {
                        if (this.mFlag) {
                            this.mFlag = false;
                            System.out.println("client: updating the entry price");
                            OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest("test custom text entry", aExe.getOrderID(), aExe.getSide(), aExe.getOrdType(), this.add(aExe.getPrice(), -0.011, aExe.getInstrument().getSymbol()), aExe.getAccount());
                            os.setOrderID(aExe.getOrderID());
                            os.setOrigClOrdID(aExe.getClOrdID());
                            os.setSide(aExe.getSide());
                            os.setInstrument(aExe.getInstrument());
                            os.setOrderQty(aExe.getOrderQty() / 2.0);
                            os.setLeavesQty(aExe.getOrderQty() * 5.0);
                            this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                        } else {
                            this.setSuccess(true);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testUpdateSLEntryOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag1 = true;
            private boolean mFlag2 = true;
            private String mRequestId;
            private String mLimitId;
            private String mStopId;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(MarketDataSnapshot aMarketDataSnapshot) {
                super.process(aMarketDataSnapshot);
                try {
                    String symbol = aMarketDataSnapshot.getInstrument().getSymbol();
                    if (this.mOrder && !this.mAccounts.isEmpty() && !symbol.contains("JPY")) {
                        CollateralReport acct = (CollateralReport)this.mAccounts.get(0);
                        this.mOrder = false;
                        OrderSingle orderSingle = MessageGenerator.generateStopLimitEntry(this.add(aMarketDataSnapshot.getAskClose(), 0.008, aMarketDataSnapshot.getInstrument().getSymbol()), OrdTypeFactory.STOP, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, aMarketDataSnapshot.getInstrument().getSymbol(), cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: entry order requestId = " + this.mRequestId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(ExecutionReport aExe) {
                super.process(aExe);
                try {
                    if (MessageAnalyzer.isStopLimitEntryOrder(aExe) && QATest.safeEquals(this.mRequestId, aExe.getRequestID())) {
                        System.out.println("client: trying to set a limit on the entry order");
                        OrderSingle order = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), 0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.LIMIT, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: limit order reqId = " + this.mLimitId);
                        System.out.println("client: trying to set a stop on the entry order");
                        order = MessageGenerator.generateStopLimitClose(this.add(aExe.getPrice(), -0.008, aExe.getInstrument().getSymbol()), aExe.getFXCMPosID(), OrdTypeFactory.STOP, aExe.getAccount(), aExe.getOrderQty(), SideFactory.BUY, aExe.getInstrument().getSymbol(), cem);
                        this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: stop  order reqId = " + this.mStopId);
                    } else if (MessageAnalyzer.isStopLimitCloseOrder(aExe)) {
                        if (MessageAnalyzer.isLimitOrder(aExe) && QATest.safeEquals(this.mLimitId, aExe.getRequestID())) {
                            if (this.mFlag1) {
                                System.out.println("client: updating a limit order");
                                OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest("test custom text limit order", aExe.getOrderID(), aExe.getSide(), aExe.getOrdType(), this.add(aExe.getPrice(), 0.004, aExe.getInstrument().getSymbol()), aExe.getAccount());
                                os.setOrderID(aExe.getOrderID());
                                os.setOrigClOrdID(aExe.getClOrdID());
                                os.setSide(aExe.getSide());
                                os.setInstrument(aExe.getInstrument());
                                os.setOrderQty(aExe.getOrderQty());
                                this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                                this.mFlag1 = false;
                            } else {
                                this.mGotLimitDelete = true;
                                if (this.mGotStoptDelete) {
                                    this.setSuccess(true);
                                }
                            }
                        } else if (MessageAnalyzer.isStopOrder(aExe) && QATest.safeEquals(this.mStopId, aExe.getRequestID())) {
                            if (this.mFlag2) {
                                System.out.println("client: updating a stop order");
                                OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest("test custom text stop order", aExe.getOrderID(), aExe.getSide(), aExe.getOrdType(), this.add(aExe.getPrice(), -0.004, aExe.getInstrument().getSymbol()), aExe.getAccount());
                                os.setOrderID(aExe.getOrderID());
                                os.setOrigClOrdID(aExe.getClOrdID());
                                os.setSide(aExe.getSide());
                                os.setInstrument(aExe.getInstrument());
                                os.setOrderQty(aExe.getOrderQty());
                                this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                                this.mFlag2 = false;
                            } else {
                                this.mGotStoptDelete = true;
                                if (this.mGotLimitDelete) {
                                    this.setSuccess(true);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testUpdateSLMarketOrder() {
        final String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private final List mAccounts = new ArrayList();
            private boolean mOrder = true;
            private boolean mFlag1 = true;
            private boolean mFlag2 = true;
            private String mRequestId;
            private String mStopId;
            private String mLimitId;
            private boolean mGotLimitDelete;
            private boolean mGotStoptDelete;

            GenericListener() {
            }

            @Override
            public void process(ExecutionReport aExecutionReport) {
                super.process(aExecutionReport);
                if (MessageAnalyzer.isStopLimitCloseOrder(aExecutionReport)) {
                    try {
                        if (MessageAnalyzer.isLimitOrder(aExecutionReport) && QATest.safeEquals(this.mLimitId, aExecutionReport.getRequestID())) {
                            if (this.mFlag1) {
                                this.mFlag1 = false;
                                System.out.println("\nupdating a limit order");
                                OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest("test custom text limit", aExecutionReport.getOrderID(), aExecutionReport.getSide(), aExecutionReport.getOrdType(), this.add(aExecutionReport.getPrice(), 0.004, aExecutionReport.getInstrument().getSymbol()), aExecutionReport.getAccount());
                                os.setOrderID(aExecutionReport.getOrderID());
                                os.setOrigClOrdID(aExecutionReport.getClOrdID());
                                os.setSide(aExecutionReport.getSide());
                                os.setInstrument(aExecutionReport.getInstrument());
                                os.setOrderQty(aExecutionReport.getOrderQty());
                                this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                            } else {
                                this.mGotLimitDelete = true;
                                if (this.mGotStoptDelete) {
                                    this.setSuccess(true);
                                }
                            }
                        } else if (MessageAnalyzer.isStopOrder(aExecutionReport) && QATest.safeEquals(this.mStopId, aExecutionReport.getRequestID())) {
                            if (this.mFlag2) {
                                this.mFlag2 = false;
                                System.out.println("\nupdating a stop order");
                                OrderCancelReplaceRequest os = MessageGenerator.generateOrderReplaceRequest("test custom text stop", aExecutionReport.getOrderID(), aExecutionReport.getSide(), aExecutionReport.getOrdType(), this.add(aExecutionReport.getPrice(), -0.004, aExecutionReport.getInstrument().getSymbol()), aExecutionReport.getAccount());
                                os.setOrderID(aExecutionReport.getOrderID());
                                os.setOrigClOrdID(aExecutionReport.getClOrdID());
                                os.setSide(aExecutionReport.getSide());
                                os.setInstrument(aExecutionReport.getInstrument());
                                os.setOrderQty(aExecutionReport.getOrderQty());
                                this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)os);
                            } else {
                                this.mGotStoptDelete = true;
                                if (this.mGotLimitDelete) {
                                    this.setSuccess(true);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void process(CollateralReport aCollateralReport) {
                try {
                    if (this.mOrder) {
                        OrderSingle orderSingle = MessageGenerator.generateMarketOrder(aCollateralReport.getAccount(), aCollateralReport.getQuantity(), SideFactory.BUY, "EUR/USD", cem);
                        this.mRequestId = QATest.this.mFxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: good order requestid = " + this.mRequestId);
                        this.mOrder = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(PositionReport aPositionReport) {
                super.process(aPositionReport);
                if (QATest.safeEquals(this.mRequestId, aPositionReport.getRequestID())) {
                    System.out.println("client: inc pos report = " + aPositionReport);
                    try {
                        System.out.println("\nclient: trying to set a stop on the open position");
                        OrderSingle order = MessageGenerator.generateStopLimitClose(this.add(aPositionReport.getSettlPrice(), -0.008, aPositionReport.getInstrument().getSymbol()), aPositionReport.getFXCMPosID(), OrdTypeFactory.STOP, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), SideFactory.BUY, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mStopId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: stop  order reqId = " + this.mStopId);
                        System.out.println("\nclient: trying to set a limit on the open position");
                        order = MessageGenerator.generateStopLimitClose(this.add(aPositionReport.getSettlPrice(), 0.008, aPositionReport.getInstrument().getSymbol()), aPositionReport.getFXCMPosID(), OrdTypeFactory.LIMIT, aPositionReport.getAccount(), aPositionReport.getPositionQty().getQty(), SideFactory.BUY, aPositionReport.getInstrument().getSymbol(), cem);
                        this.mLimitId = QATest.this.mFxcmGateway.sendMessage((ITransportable)order);
                        System.out.println("client: limit order reqId = " + this.mLimitId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, this.mAccounts, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public boolean testUserStatus() {
        String cem = Util.getCurrentlyExecutingMethod();
        System.out.println(cem);
        class GenericListener
        extends MessageTestHandler {
            private String mRID;

            GenericListener() {
            }

            @Override
            public void process(UserResponse aUserResponse) {
                System.out.println("\naUserResponse = " + aUserResponse);
                if (aUserResponse.getRequestID().equals(this.mRID)) {
                    this.setSuccess(true);
                }
            }

            @Override
            public void process(TradingSessionStatus aTradingSessionStatus) {
                super.process(aTradingSessionStatus);
                UserRequest req = new UserRequest();
                req.setUsername(QATest.this.mUsername);
                req.setPassword(QATest.this.mPassword);
                req.setUserRequestType(4);
                try {
                    this.mRID = QATest.this.mFxcmGateway.sendMessage((ITransportable)req);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void process(Logout aLogout) {
                super.process(aLogout);
                UserRequest req = new UserRequest();
                req.setUsername(QATest.this.mUsername);
                req.setPassword(QATest.this.mPassword);
                req.setUserRequestType(4);
                try {
                    this.mRID = QATest.this.mFxcmGateway.sendMessage((ITransportable)req);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void messageArrived(ITransportable aMessage) {
                QATest.this.handleMessage(aMessage, null, this);
            }
        }
        return this.doResult(new GenericListener());
    }

    public static void main(String[] aArgs) {
        if (aArgs.length < 4) {
            System.out.println("must supply 4 arguments: username, password, station, hostname, command, config");
            return;
        }
        if (aArgs.length > 4) {
            QATest.runTest(aArgs);
        }
    }

    private abstract class MessageTestHandler
    implements IGenericMessageListener {
        private boolean mSuccess;
        protected TradingSessionStatus mTradingSessionStatus;

        private MessageTestHandler() {
        }

        public boolean isSuccess() {
            return this.mSuccess;
        }

        public void setSuccess(boolean aSuccess) {
            this.mSuccess = aSuccess;
        }

        public void process(UserResponse aUserResponse) {
        }

        public void process(CollateralInquiryAck aCollateralInquiryAck) {
        }

        public void process(CollateralReport aCollateralReport) {
            if (QATest.this.mAccountMassID.equals(aCollateralReport.getRequestID()) && aCollateralReport.isLastRptRequested()) {
                try {
                    System.out.println("client out: do marketdatarequest for testing to get fast mds");
                    MarketDataRequest mdr = new MarketDataRequest();
                    Enumeration securities = this.mTradingSessionStatus.getSecurities();
                    while (securities.hasMoreElements()) {
                        TradingSecurity o = (TradingSecurity)securities.nextElement();
                        mdr.addRelatedSymbol((Instrument)o);
                    }
                    mdr.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SUBSCRIBE);
                    mdr.setMDEntryTypeSet(7);
                    QATest.this.mFxcmGateway.sendMessage((ITransportable)mdr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public double add(double aValue1, double aValue2, String aSymbol) throws NotDefinedException {
            int precision = this.mTradingSessionStatus.getSecurity(aSymbol).getFXCMSymPrecision();
            return BigDecimal.valueOf(aValue1 + aValue2).setScale(precision, 4).doubleValue();
        }

        public void process(ExecutionReport aExecutionReport) {
        }

        public void process(ClosedPositionReport aClosedPositionReport) {
        }

        public void process(PositionReport aPositionReport) {
        }

        public void process(BusinessMessageReject aBusinessMessageReject) {
            System.out.println("client inc: aBusinessMessageReject = " + aBusinessMessageReject);
        }

        public void process(RequestForPositionsAck aRequestForPositionsAck) {
            System.out.println("client inc: aRequestForPositionsAck = " + aRequestForPositionsAck);
        }

        public void process(TradingSessionStatus aTradingSessionStatus) {
            this.mTradingSessionStatus = aTradingSessionStatus;
            System.out.println("client inc: aTradingSessionStatus = " + aTradingSessionStatus);
        }

        public void process(SecurityStatus aSecurityStatus) {
            System.out.println("client inc: aSecurityStatus = " + aSecurityStatus);
        }

        public void process(SecurityList aSecurityList) {
            System.out.println("client inc: aSecurityList = " + aSecurityList);
        }

        public void process(Quote aQuote) {
            System.out.println("client inc: aQuote = " + aQuote);
        }

        public void process(MarketDataSnapshot aMarketDataSnapshot) {
        }

        public void process(MarketDataRequestReject aMarketDataRequestReject) {
        }

        public void process(Logout aLogout) {
            System.out.println("client inc: aLogout = " + aLogout);
        }
    }

    private static class DefaultStatusListener
    implements IStatusMessageListener {
        private final boolean mPrint;

        DefaultStatusListener(boolean aPrint) {
            this.mPrint = aPrint;
        }

        @Override
        public void messageArrived(ISessionStatus aStatus) {
            if (this.mPrint) {
                System.out.println("aStatus = " + aStatus);
            }
            if (aStatus.getStatusCode() == -2 || aStatus.getStatusCode() == 5 || aStatus.getStatusCode() == -1) {
                System.out.println("aStatus = " + aStatus);
            }
        }
    }
}

