/*
 * Decompiled with CFR 0.152.
 */
import com.fxcm.external.api.transport.FXCMLoginProperties;
import com.fxcm.external.api.transport.GatewayFactory;
import com.fxcm.external.api.transport.IGateway;
import com.fxcm.external.api.transport.listeners.IGenericMessageListener;
import com.fxcm.external.api.transport.listeners.IStatusMessageListener;
import com.fxcm.external.api.util.MessageGenerator;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.admin.Heartbeat;
import com.fxcm.fix.admin.Logout;
import com.fxcm.fix.admin.TestRequest;
import com.fxcm.fix.other.BusinessMessageReject;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.fix.posttrade.ClosedPositionReport;
import com.fxcm.fix.posttrade.CollateralInquiryAck;
import com.fxcm.fix.posttrade.CollateralReport;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.fix.posttrade.RequestForPositionsAck;
import com.fxcm.fix.pretrade.MarketDataRequest;
import com.fxcm.fix.pretrade.MarketDataSnapshot;
import com.fxcm.fix.pretrade.SecurityList;
import com.fxcm.fix.pretrade.SecurityStatus;
import com.fxcm.fix.pretrade.TradingSessionStatus;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderCancelReject;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.messaging.ISessionStatus;
import com.fxcm.messaging.ITransportable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

public class ClientTester {
    private static List cAccounts = new ArrayList();
    private static String cAccountMassID = "";
    private static String cOpenOrderMassID = "";
    private static String cOpenPositionMassID = "";
    private static String cClosedPositionMassID = "";
    private static String cTradingSessionStatusID = "";
    private static TradingSessionStatus cTradingSessionStatus;
    private static boolean cPrintMarketData;

    public static void main(String[] args) {
        final IGateway fxcmGateway = GatewayFactory.createGateway();
        fxcmGateway.registerGenericMessageListener(new IGenericMessageListener(){

            @Override
            public void messageArrived(ITransportable aMessage) {
                if (aMessage instanceof MarketDataSnapshot) {
                    MarketDataSnapshot incomingQuote = (MarketDataSnapshot)aMessage;
                    if (incomingQuote.getMDReqID() != null) {
                        System.out.println("client: snapshot = " + incomingQuote);
                    } else if (cPrintMarketData) {
                        System.out.println("client: streaming = " + incomingQuote);
                    }
                } else if (aMessage instanceof OrderCancelReject) {
                    System.out.println("client: streaming = " + aMessage);
                } else if (aMessage instanceof SecurityStatus) {
                    System.out.println("client: streaming = " + aMessage);
                } else if (aMessage instanceof SecurityList) {
                    System.out.println("client: streaming = " + aMessage);
                } else if (aMessage instanceof UserResponse) {
                    System.out.println("client: streaming = " + aMessage);
                } else if (aMessage instanceof Logout) {
                    System.out.println("client: streaming = " + aMessage);
                } else if (aMessage instanceof TradingSessionStatus) {
                    cTradingSessionStatus = (TradingSessionStatus)aMessage;
                    if (cTradingSessionStatusID.equals(cTradingSessionStatus.getRequestID())) {
                        System.out.println("client: reply = " + cTradingSessionStatus);
                        try {
                            MarketDataRequest mdr = new MarketDataRequest();
                            Enumeration securities = cTradingSessionStatus.getSecurities();
                            while (securities.hasMoreElements()) {
                                TradingSecurity o = (TradingSecurity)securities.nextElement();
                                mdr.addRelatedSymbol((Instrument)o);
                            }
                            mdr.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SUBSCRIBE);
                            mdr.setMDEntryTypeSet(7);
                            fxcmGateway.sendMessage((ITransportable)mdr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println("client: streaming = " + cTradingSessionStatus);
                    }
                } else if (aMessage instanceof RequestForPositionsAck) {
                    RequestForPositionsAck rfpa = (RequestForPositionsAck)aMessage;
                    if (cOpenPositionMassID.equals(rfpa.getRequestID())) {
                        System.out.println("client: open positions = " + rfpa);
                    } else if (cClosedPositionMassID.equals(rfpa.getRequestID())) {
                        System.out.println("client: close positions = " + rfpa);
                    } else {
                        System.out.println("client: rfpa = " + rfpa);
                    }
                } else if (aMessage instanceof ClosedPositionReport) {
                    ClosedPositionReport cpr = (ClosedPositionReport)aMessage;
                    if (cClosedPositionMassID.equals(cpr.getRequestID())) {
                        System.out.println("client: reply = " + cpr);
                    } else {
                        System.out.println("client: streaming = " + cpr);
                    }
                } else if (aMessage instanceof PositionReport) {
                    PositionReport pr = (PositionReport)aMessage;
                    if (cOpenPositionMassID.equals(pr.getRequestID())) {
                        System.out.println("client: reply = " + pr);
                    } else {
                        System.out.println("client: streaming = " + pr);
                    }
                } else if (aMessage instanceof ExecutionReport) {
                    ExecutionReport ep = (ExecutionReport)aMessage;
                    if (cOpenOrderMassID.equals(ep.getRequestID())) {
                        System.out.println("client: reply = " + ep);
                    } else {
                        System.out.println("client: streaming = " + ep);
                    }
                } else if (aMessage instanceof CollateralInquiryAck) {
                    CollateralInquiryAck cia = (CollateralInquiryAck)aMessage;
                    if (cAccountMassID.equals(cia.getRequestID())) {
                        System.out.println("client: reply = " + cia);
                    } else {
                        System.out.println("client: streaming = " + cia);
                    }
                } else if (aMessage instanceof CollateralReport) {
                    CollateralReport cr = (CollateralReport)aMessage;
                    if (cAccountMassID.equals(cr.getRequestID())) {
                        System.out.println("client: reply = " + cr);
                        cAccounts.add(cr);
                    } else {
                        System.out.println("client: streaming = " + cr);
                    }
                } else if (aMessage instanceof BusinessMessageReject) {
                    BusinessMessageReject bmr = (BusinessMessageReject)aMessage;
                    System.out.println("client: streaming =" + bmr);
                } else if (aMessage instanceof Heartbeat) {
                    System.out.println(new Date() + " :: client: streaming = " + aMessage);
                }
            }
        });
        fxcmGateway.registerStatusMessageListener(new IStatusMessageListener(){

            @Override
            public void messageArrived(ISessionStatus aStatus) {
                switch (aStatus.getStatusCode()) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        break;
                    }
                    default: {
                        System.out.println(("client: inc status msg = [" + aStatus.getStatusCode() + "] [" + aStatus.getStatusName() + "] [" + aStatus.getStatusMessage() + "]").toUpperCase());
                        if (aStatus.getStatusCode() != -1) break;
                        try {
                            fxcmGateway.relogin();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        try {
            String username = args[0];
            String password = args[1];
            String terminal = args[2];
            String server = args[3];
            String file = null;
            if (args.length == 5) {
                file = args[4];
            }
            FXCMLoginProperties properties = file == null ? new FXCMLoginProperties(username, password, terminal, server) : new FXCMLoginProperties(username, password, terminal, server, file);
            properties.addProperty("MessageFlags", String.valueOf(1L));
            properties.addProperty("com.fxcm.messaging.IConnectionManager.AdminMessages", "true");
            System.out.println("client: start logging in");
            fxcmGateway.login(properties);
            cTradingSessionStatusID = fxcmGateway.requestTradingSessionStatus();
            System.out.println(">>> requestTradingSessionStatus = " + cTradingSessionStatusID);
            cAccountMassID = fxcmGateway.requestAccounts();
            System.out.println(">>> requestAccounts = " + cAccountMassID);
            cOpenOrderMassID = fxcmGateway.requestOpenOrders();
            System.out.println(">>> requestOpenOrders = " + cOpenOrderMassID);
            cOpenPositionMassID = fxcmGateway.requestOpenPositions();
            System.out.println(">>> requestOpenPositions = " + cOpenPositionMassID);
            cClosedPositionMassID = fxcmGateway.requestClosedPositions();
            System.out.println(">>> requestClosedPositions = " + cClosedPositionMassID);
            System.out.println("client: done logging in\n");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String reqid;
                OrderSingle orderSingle;
                CollateralReport acct;
                String str;
                if ((str = in.readLine()) == null) {
                    continue;
                }
                if ("o".equalsIgnoreCase(str.trim())) {
                    acct = (CollateralReport)cAccounts.get(0);
                    orderSingle = MessageGenerator.generateMarketOrder(acct.getAccount(), 10.0, SideFactory.BUY, "EUR/USD", "true market order test " + System.currentTimeMillis());
                    try {
                        reqid = fxcmGateway.sendMessage((ITransportable)orderSingle);
                        System.out.println("client: submitting order = " + reqid);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if ("eo".equalsIgnoreCase(str.trim())) {
                    acct = (CollateralReport)cAccounts.get(0);
                    orderSingle = MessageGenerator.generateStopLimitEntry(null, 1.1, OrdTypeFactory.LIMIT, acct.getAccount(), acct.getQuantity(), SideFactory.BUY, "EUR/USD", "entry order - limit profit");
                    reqid = fxcmGateway.sendMessage((ITransportable)orderSingle);
                    System.out.println("client: entry order requestId = " + reqid);
                    continue;
                }
                if ("m".equalsIgnoreCase(str.trim())) {
                    cPrintMarketData = !cPrintMarketData;
                    continue;
                }
                if ("ts".equalsIgnoreCase(str.trim())) {
                    TestRequest tr = new TestRequest();
                    String string = fxcmGateway.sendMessage((ITransportable)tr);
                    continue;
                }
                if ("exit".equalsIgnoreCase(str.trim())) {
                    fxcmGateway.logout();
                    System.exit(0);
                    continue;
                }
                String out = "Commands:\n o [submit market order]," + " m [toggle streaming marketdata]," + " eo [submit entry order]\n" + " exit [stop process]\n";
                System.out.println(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

