import type { Runtime, RuntimeEvaluationListener, RuntimeEvaluationResult } from '@mongosh/browser-runtime-core';
import type { MongoshBus } from '@mongosh/types';
import type { CompassServiceProvider } from '@mongosh/service-provider-node-driver';
type DevtoolsConnectOptions = Parameters<(typeof CompassServiceProvider)['connect']>[1];
declare class WorkerRuntime implements Runtime {
    private initOptions;
    evaluationListener: RuntimeEvaluationListener | null;
    private eventEmitter;
    private workerProcess;
    private workerProcessRuntime;
    private initWorkerPromise;
    private workerThreadEvaluationListener;
    private workerProcessMongoshBus;
    private workerProcessPath;
    constructor(uri: string, driverOptions: DevtoolsConnectOptions, cliOptions?: {
        nodb?: boolean;
    }, workerOptions?: WorkerOptions, eventEmitter?: MongoshBus);
    private initWorker;
    evaluate(code: string): Promise<RuntimeEvaluationResult>;
    getCompletions(code: string): Promise<import("@mongosh/browser-runtime-core").Completion[]>;
    getShellPrompt(): Promise<string>;
    setEvaluationListener(listener: RuntimeEvaluationListener | null): RuntimeEvaluationListener | null;
    terminate(): Promise<void>;
    interrupt(): Promise<boolean>;
    waitForRuntimeToBeReady(): Promise<void>;
}
export { WorkerRuntime };
