"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerThreadEvaluationListener = void 0;
const rpc_1 = require("./rpc");
const serializer_1 = require("./serializer");
class WorkerThreadEvaluationListener {
    constructor(workerRuntime, worker) {
        this.exposedListener = (0, rpc_1.exposeAll)({
            onPrompt(question, type) {
                var _a, _b, _c;
                return ((_c = (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.onPrompt) === null || _b === void 0 ? void 0 : _b.call(_a, question, type)) !== null && _c !== void 0 ? _c : '');
            },
            onPrint(values) {
                var _a, _b;
                values = values.map(serializer_1.deserializeEvaluationResult);
                return (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.onPrint) === null || _b === void 0 ? void 0 : _b.call(_a, values);
            },
            setConfig(key, value) {
                var _a, _b, _c;
                return ((_c = (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.setConfig) === null || _b === void 0 ? void 0 : _b.call(_a, key, value)) !== null && _c !== void 0 ? _c : Promise.resolve('ignored'));
            },
            resetConfig(key) {
                var _a, _b, _c;
                return ((_c = (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.resetConfig) === null || _b === void 0 ? void 0 : _b.call(_a, key)) !== null && _c !== void 0 ? _c : Promise.resolve('ignored'));
            },
            validateConfig(key, value) {
                var _a, _b, _c;
                return ((_c = (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.validateConfig) === null || _b === void 0 ? void 0 : _b.call(_a, key, value)) !== null && _c !== void 0 ? _c : Promise.resolve(null));
            },
            getConfig(key) {
                var _a, _b;
                return (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.getConfig) === null || _b === void 0 ? void 0 : _b.call(_a, key);
            },
            listConfigOptions() {
                var _a, _b;
                return (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.listConfigOptions) === null || _b === void 0 ? void 0 : _b.call(_a);
            },
            onClearCommand() {
                var _a, _b;
                return (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.onClearCommand) === null || _b === void 0 ? void 0 : _b.call(_a);
            },
            onExit(exitCode) {
                var _a, _b, _c;
                return ((_c = (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.onExit) === null || _b === void 0 ? void 0 : _b.call(_a, exitCode)) !== null && _c !== void 0 ? _c : Promise.resolve());
            },
            getLogPath() {
                var _a, _b;
                return (_b = (_a = workerRuntime.evaluationListener) === null || _a === void 0 ? void 0 : _a.getLogPath) === null || _b === void 0 ? void 0 : _b.call(_a);
            },
        }, worker);
    }
    terminate() {
        this.exposedListener[rpc_1.close]();
    }
}
exports.WorkerThreadEvaluationListener = WorkerThreadEvaluationListener;
//# sourceMappingURL=worker-thread-evaluation-listener.js.map