"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lock = void 0;
class Lock {
    constructor() {
        this.promise = null;
        this.resolve = null;
    }
    lock() {
        if (this.isLocked()) {
            throw new Error("Can't create another lock while locked");
        }
        this.promise = new Promise((resolve) => {
            this.resolve = resolve;
        });
        return this.promise;
    }
    unlock() {
        const resolve = this.resolve;
        if (resolve) {
            this.promise = null;
            this.resolve = null;
            resolve(Lock.UNLOCK_TOKEN);
            return true;
        }
        return false;
    }
    isLocked() {
        return Boolean(this.promise);
    }
    isUnlockToken(resolvedValue) {
        return resolvedValue === Lock.UNLOCK_TOKEN;
    }
}
exports.Lock = Lock;
Lock.UNLOCK_TOKEN = 'UNLOCKED';
//# sourceMappingURL=lock.js.map