/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@ParametersAreNonnullByDefault
public class TextUtil {
    @Nullable
    @CheckReturnValue
    public static String readTextContentOrNull(Element element) {
        String text = TextUtil.readTextContent(element);
        return text.isEmpty() ? null : text;
    }

    @Nonnull
    @CheckReturnValue
    public static String readTextContent(Element element) {
        StringBuilder result = new StringBuilder();
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            short nodeType = current.getNodeType();
            if (nodeType != 3 && nodeType != 4) continue;
            Text t = (Text)current;
            result.append(t.getData());
        }
        return result.toString();
    }
}

