/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.newmatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.css.constants.MarginBoxName;
import org.xhtmlrenderer.css.extend.AttributeResolver;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.extend.TreeResolver;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.newmatch.Selector;
import org.xhtmlrenderer.css.sheet.FontFaceRule;
import org.xhtmlrenderer.css.sheet.MediaRule;
import org.xhtmlrenderer.css.sheet.PageRule;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.util.Util;
import org.xhtmlrenderer.util.XRLog;

public class Matcher {
    private final Mapper docMapper;
    private final AttributeResolver _attRes;
    private final TreeResolver _treeRes;
    private final StylesheetFactory _styleFactory;
    private final Map<Node, Mapper> _map = Collections.synchronizedMap(new HashMap());
    private final Set<Node> _hoverElements = Collections.synchronizedSet(new HashSet());
    private final Set<Node> _activeElements = Collections.synchronizedSet(new HashSet());
    private final Set<Node> _focusElements = Collections.synchronizedSet(new HashSet());
    private final Set<Node> _visitElements = Collections.synchronizedSet(new HashSet());
    private final List<PageRule> _pageRules = new ArrayList<PageRule>();
    private final List<FontFaceRule> _fontFaceRules = new ArrayList<FontFaceRule>();

    public Matcher(TreeResolver tr, AttributeResolver ar, StylesheetFactory factory, List<Stylesheet> stylesheets, String medium) {
        this._treeRes = tr;
        this._attRes = ar;
        this._styleFactory = factory;
        this.docMapper = this.createDocumentMapper(stylesheets, medium);
    }

    public void removeStyle(Element e) {
        this._map.remove(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CascadedStyle getCascadedStyle(Element e, boolean restyle) {
        Element element = e;
        synchronized (element) {
            Mapper em = restyle ? this.matchElement(e) : this.getMapper(e);
            return em.getCascadedStyle(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CascadedStyle getPECascadedStyle(Element e, String pseudoElement) {
        Element element = e;
        synchronized (element) {
            Mapper em = this.getMapper(e);
            return em.getPECascadedStyle(e, pseudoElement);
        }
    }

    public PageInfo getPageCascadedStyle(String pageName, String pseudoPage) {
        ArrayList<PropertyDeclaration> props = new ArrayList<PropertyDeclaration>();
        HashMap<MarginBoxName, List<PropertyDeclaration>> marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
        for (PageRule pageRule : this._pageRules) {
            if (!pageRule.applies(pageName, pseudoPage)) continue;
            props.addAll(pageRule.getRuleset().getPropertyDeclarations());
            marginBoxes.putAll(pageRule.getMarginBoxes());
        }
        CascadedStyle style = props.isEmpty() ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(props);
        return new PageInfo(props, style, marginBoxes);
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this._fontFaceRules;
    }

    public boolean isVisitedStyled(Node e) {
        return this._visitElements.contains(e);
    }

    public boolean isHoverStyled(Node e) {
        return this._hoverElements.contains(e);
    }

    public boolean isActiveStyled(Node e) {
        return this._activeElements.contains(e);
    }

    public boolean isFocusStyled(Node e) {
        return this._focusElements.contains(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mapper matchElement(Node e) {
        Node node = e;
        synchronized (node) {
            Mapper child;
            Node parent = this._treeRes.getParentElement(e);
            if (parent != null) {
                Mapper m = this.getMapper(parent);
                child = m.mapChild(e);
            } else {
                child = this.docMapper.mapChild(e);
            }
            return child;
        }
    }

    Mapper createDocumentMapper(List<Stylesheet> stylesheets, String medium) {
        TreeMap<String, Selector> sorter = new TreeMap<String, Selector>();
        this.addAllStylesheets(stylesheets, sorter, medium);
        XRLog.match("Matcher created with " + sorter.size() + " selectors");
        return new Mapper(sorter.values());
    }

    private void addAllStylesheets(List<Stylesheet> stylesheets, Map<String, Selector> sorter, String medium) {
        int count = 0;
        int pCount = 0;
        for (Stylesheet stylesheet : stylesheets) {
            for (Object obj : stylesheet.getContents()) {
                MediaRule mediaRule;
                if (obj instanceof Ruleset) {
                    for (Selector selector : ((Ruleset)obj).getFSSelectors()) {
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                    continue;
                }
                if (obj instanceof PageRule) {
                    PageRule pageRule = (PageRule)obj;
                    pageRule.setPos(++pCount);
                    this._pageRules.add(pageRule);
                    continue;
                }
                if (!(obj instanceof MediaRule) || !(mediaRule = (MediaRule)obj).matches(medium)) continue;
                for (Ruleset ruleset : mediaRule.getContents()) {
                    for (Selector selector : ruleset.getFSSelectors()) {
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                }
            }
            this._fontFaceRules.addAll(stylesheet.getFontFaceRules());
        }
        this._pageRules.sort(Comparator.comparingLong(PageRule::getOrder));
    }

    private void link(Node e, Mapper m) {
        this._map.put(e, m);
    }

    private Mapper getMapper(Node e) {
        Mapper m = this._map.get(e);
        if (m != null) {
            return m;
        }
        m = this.matchElement(e);
        return m;
    }

    private static Iterator<Ruleset> getMatchedRulesets(final List<Selector> mappedSelectors) {
        return new Iterator<Ruleset>(){
            final Iterator<Selector> selectors;
            {
                this.selectors = mappedSelectors.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.selectors.hasNext();
            }

            @Override
            public Ruleset next() {
                if (this.hasNext()) {
                    return this.selectors.next().getRuleset();
                }
                throw new NoSuchElementException("No more rulesets");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing rulesets is not supported");
            }
        };
    }

    private static Iterator<Ruleset> getSelectedRulesets(List<Selector> selectorList) {
        final List<Selector> sl = selectorList;
        return new Iterator<Ruleset>(){
            final Iterator<Selector> selectors;
            {
                this.selectors = sl.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.selectors.hasNext();
            }

            @Override
            public Ruleset next() {
                if (this.hasNext()) {
                    return this.selectors.next().getRuleset();
                }
                throw new NoSuchElementException("No more rulesets");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing rulesets is not supported");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ruleset getElementStyle(Node e) {
        Node node = e;
        synchronized (node) {
            if (this._attRes == null || this._styleFactory == null) {
                return null;
            }
            String style = this._attRes.getElementStyling(e);
            if (Util.isNullOrEmpty(style)) {
                return null;
            }
            return this._styleFactory.parseStyleDeclaration(2, style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ruleset getNonCssStyle(Node e) {
        Node node = e;
        synchronized (node) {
            if (this._attRes == null || this._styleFactory == null) {
                return null;
            }
            String style = this._attRes.getNonCssStyling(e);
            if (Util.isNullOrEmpty(style)) {
                return null;
            }
            return this._styleFactory.parseStyleDeclaration(2, style);
        }
    }

    protected class Mapper {
        private List<Selector> axes;
        private Map<String, List<Selector>> pseudoSelectors;
        private List<Selector> mappedSelectors;
        private Map<String, Mapper> children;

        Mapper(Collection<Selector> selectors) {
            this.axes = new ArrayList<Selector>(selectors.size());
            this.axes.addAll(selectors);
        }

        private Mapper() {
        }

        Mapper mapChild(Node e) {
            Mapper childMapper;
            ArrayList<Selector> childAxes = new ArrayList<Selector>(this.axes.size() + 10);
            HashMap<String, List<Selector>> pseudoSelectors = new HashMap<String, List<Selector>>();
            LinkedList<Selector> mappedSelectors = new LinkedList<Selector>();
            StringBuilder key = new StringBuilder();
            for (Selector axe : this.axes) {
                if (axe.getAxis() == 0) {
                    childAxes.add(axe);
                } else if (axe.getAxis() == 2) {
                    throw new RuntimeException("Selector axis==2");
                }
                if (!axe.matches(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                String pseudoElement = axe.getPseudoElement();
                if (pseudoElement != null) {
                    List l = pseudoSelectors.computeIfAbsent(pseudoElement, k -> new LinkedList());
                    l.add(axe);
                    key.append(axe.getSelectorID()).append(":");
                    continue;
                }
                if (axe.isPseudoClass(2)) {
                    Matcher.this._visitElements.add(e);
                }
                if (axe.isPseudoClass(8)) {
                    Matcher.this._activeElements.add(e);
                }
                if (axe.isPseudoClass(4)) {
                    Matcher.this._hoverElements.add(e);
                }
                if (axe.isPseudoClass(16)) {
                    Matcher.this._focusElements.add(e);
                }
                if (!axe.matchesDynamic(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                key.append(axe.getSelectorID()).append(":");
                Selector chain = axe.getChainedSelector();
                if (chain == null) {
                    mappedSelectors.add(axe);
                    continue;
                }
                if (chain.getAxis() == 2) {
                    throw new RuntimeException("Selector axis==2");
                }
                childAxes.add(chain);
            }
            if (this.children == null) {
                this.children = new HashMap<String, Mapper>();
            }
            if ((childMapper = this.children.get(key.toString())) == null) {
                childMapper = new Mapper();
                childMapper.axes = childAxes;
                childMapper.pseudoSelectors = pseudoSelectors;
                childMapper.mappedSelectors = mappedSelectors;
                this.children.put(key.toString(), childMapper);
            }
            Matcher.this.link(e, childMapper);
            return childMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CascadedStyle getCascadedStyle(Node e) {
            Node node = e;
            synchronized (node) {
                Ruleset elementStyling = Matcher.this.getElementStyle(e);
                Ruleset nonCssStyling = Matcher.this.getNonCssStyle(e);
                ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
                if (nonCssStyling != null) {
                    propList.addAll(nonCssStyling.getPropertyDeclarations());
                }
                Iterator i = Matcher.getMatchedRulesets(this.mappedSelectors);
                while (i.hasNext()) {
                    Ruleset rs = (Ruleset)i.next();
                    propList.addAll(rs.getPropertyDeclarations());
                }
                if (elementStyling != null) {
                    propList.addAll(elementStyling.getPropertyDeclarations());
                }
                return propList.isEmpty() ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(propList);
            }
        }

        public CascadedStyle getPECascadedStyle(Node e, String pseudoElement) {
            Iterator<Map.Entry<String, List<Selector>>> si = this.pseudoSelectors.entrySet().iterator();
            if (!si.hasNext()) {
                return null;
            }
            List<Selector> pe = this.pseudoSelectors.get(pseudoElement);
            if (pe == null) {
                return null;
            }
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            Iterator i = Matcher.getSelectedRulesets(pe);
            while (i.hasNext()) {
                Ruleset rs = (Ruleset)i.next();
                propList.addAll(rs.getPropertyDeclarations());
            }
            if (propList.isEmpty()) {
                return CascadedStyle.emptyCascadedStyle;
            }
            return new CascadedStyle(propList);
        }
    }
}

