/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.utilslib;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageUtils {
    public static BufferedImage scaleWithAspectWidth(BufferedImage img, int width) {
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        int height = imgHeight * width / imgWidth;
        return ImageUtils.scaleImage(img, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scaleImage(BufferedImage img, int width, int height) {
        if (img.getWidth() == width && img.getHeight() == height) {
            return img;
        }
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D g = newImage.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(img, 0, 0, width, height, null);
        }
        finally {
            g.dispose();
        }
        return newImage;
    }
}

