/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.utilslib;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;

public class DesktopUtils {
    private static void showBrowseUrlDialog(String url) {
        JOptionPane.showInputDialog(null, "Unable to open browser, please visit the URL manually (copy it from the box):", "Unable to open browser", 0, null, null, url);
    }

    public static void browseUrl(final String url) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                try {
                    if (url.startsWith("mailto:")) {
                        Desktop.getDesktop().mail(new URI(url));
                    } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(new URI(url));
                    } else if (OperatingSystem.getOperatingSystem() == OperatingSystem.LINUX) {
                        new ProcessBuilder("xdg-open", url).start();
                    } else if (OperatingSystem.getOperatingSystem() == OperatingSystem.OSX) {
                        new ProcessBuilder("open", url).start();
                    } else {
                        SwingUtilities.invokeLater(() -> DesktopUtils.showBrowseUrlDialog(url));
                    }
                }
                catch (IOException e) {
                    Utils.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    SwingUtilities.invokeLater(() -> DesktopUtils.showBrowseUrlDialog(url));
                }
                catch (URISyntaxException e) {
                    Utils.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
                catch (RuntimeException e) {
                    Utils.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
                return null;
            }
        }.execute();
    }

    public static void open(final File file) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                Utils.getLogger().info("Attempting to open " + file.getAbsolutePath());
                String asciiUri = file.toURI().toASCIIString();
                Utils.getLogger().info("Using " + asciiUri);
                if (asciiUri.startsWith("file:") && !asciiUri.startsWith("file://")) {
                    asciiUri = asciiUri.replaceFirst("file:", "file://");
                }
                Utils.getLogger().info("Intermediary path " + asciiUri);
                try {
                    Desktop.getDesktop().open(new File(new URI(asciiUri).getPath()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        }.execute();
    }
}

