/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.listitems.javaversion;

import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.ui.lang.ResourceLoader;

public class JavaVersionItem {
    private IJavaRuntime javaVersion;
    private ResourceLoader resourceLoader;

    public JavaVersionItem(IJavaRuntime javaVersion, ResourceLoader resourceLoader) {
        this.javaVersion = javaVersion;
        this.resourceLoader = resourceLoader;
    }

    public String getVersionNumber() {
        return this.javaVersion.getVersion();
    }

    public boolean is64Bit() {
        return this.javaVersion.is64Bit();
    }

    public IJavaRuntime getJavaVersion() {
        return this.javaVersion;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String toString() {
        String version = this.javaVersion.getVersion();
        String bitness = this.javaVersion.is64Bit() ? this.resourceLoader.getString("launcheroptions.java.64bit", new String[0]) : this.resourceLoader.getString("launcheroptions.java.32bit", new String[0]);
        String vendor = this.javaVersion.getVendor();
        return vendor + " " + version + " " + bitness;
    }
}

