/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.list;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class SimpleScrollbarUI
extends BasicScrollBarUI {
    private final Color myTrackColor;
    private final Color myThumbColor;

    public SimpleScrollbarUI(Color trackColor, Color thumbColor) {
        this.myTrackColor = trackColor;
        this.myThumbColor = thumbColor;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.thumbColor = this.myThumbColor;
        this.trackColor = this.myTrackColor;
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(this.trackColor);
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int x = thumbBounds.x + 1;
        int y = thumbBounds.y + 1;
        int width = thumbBounds.width - 2;
        int height = thumbBounds.height - 2;
        g.setColor(this.thumbColor);
        g.fillRect(x, y, width, height);
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int endTrackY = sbSize.height - sbInsets.bottom;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        float trackH = (float)sbSize.height - (float)sbInsetsH;
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = endTrackY - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        int itrackY = 0;
        int itrackH = endTrackY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > endTrackY) {
                thumbY = endTrackY - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }
}

