/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.installation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.technicpack.launchercore.util.DownloadListener;

public class ProgressBar
extends JLabel
implements DownloadListener {
    float progressPct;
    private Color backFillColor = null;

    public ProgressBar() {
        super("");
    }

    public Color getBackFill() {
        return this.backFillColor;
    }

    public void setBackFill(Color backFill) {
        this.backFillColor = backFill;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        int width = this.getWidth() - 3;
        int height = this.getHeight() - 3;
        int x = 1;
        int y = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() != null) {
            insets = this.getBorder().getBorderInsets(this);
        }
        x += insets.left;
        y += insets.top;
        width -= insets.left + insets.right;
        height -= insets.top + insets.bottom;
        Shape clip = g2d.getClip();
        if (this.getBackFill() != null) {
            g2d.setColor(this.getBackFill());
            g2d.clipRect(x, y, width, height);
            g2d.fillRoundRect(x, y, width, height, height, height);
        }
        g2d.setColor(this.getBackground());
        float clipWidth = this.progressPct * (float)width;
        g2d.clipRect(x, y, (int)clipWidth, height);
        g2d.fillRoundRect(x, y, width, height, height, height);
        g2d.setClip(clip);
        g2d.setColor(this.getForeground());
        Stroke stroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawRoundRect(x, y, width, height, height, height);
        g2d.setStroke(stroke);
        int iconWidth = 0;
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, g2d, x + height / 4, y + (height / 2 - this.getIcon().getIconHeight() / 2));
            iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
        }
        g2d.setFont(this.getFont());
        int textY = y + (height - g2d.getFontMetrics().getHeight()) / 2 + g2d.getFontMetrics().getAscent();
        String pctText = String.format(Locale.ROOT, "%.2f%%", Float.valueOf(this.progressPct * 100.0f));
        int textX = x + width - height / 4 - g2d.getFontMetrics().stringWidth(pctText);
        g2d.drawString(pctText, textX, textY);
        g2d.clipRect(x, y, textX - x - 3, height);
        g2d.drawString(this.getText(), x + height / 4 + iconWidth, textY);
        g2d.setClip(clip);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(32000, 32000);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    protected void setProgress(String progressText, float progress) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.setProgress(progressText, progress));
            return;
        }
        this.setText(progressText);
        this.progressPct = progress / 100.0f;
        this.repaint();
    }

    @Override
    public void stateChanged(String fileName, float progress) {
        this.setProgress(fileName, progress);
    }
}

