/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls.feeds;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.technicpack.ui.lang.ResourceLoader;

public class StatBox
extends JButton {
    private ResourceLoader resources;
    JLabel fieldLabel;
    JLabel valueLabel;

    public StatBox(ResourceLoader resources, String fieldName, Integer value) {
        this.resources = resources;
        this.setOpaque(false);
        this.initComponents(fieldName);
        this.setValue(value);
    }

    public void setValue(Integer value) {
        String valueStr = this.buildValueStr(value);
        this.valueLabel.setText(valueStr);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fieldLabel != null) {
            this.fieldLabel.setForeground(color);
        }
        if (this.valueLabel != null) {
            this.valueLabel.setForeground(color);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension arcs = new Dimension(5, 5);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
    }

    private void initComponents(String fieldName) {
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 3));
        this.valueLabel = new JLabel("");
        this.valueLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 22.0f, 1));
        this.valueLabel.setForeground(this.getForeground());
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setAlignmentX(0.5f);
        this.valueLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.add(this.valueLabel);
        this.fieldLabel = new JLabel(fieldName);
        this.fieldLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 12.0f));
        this.fieldLabel.setForeground(this.getForeground());
        this.fieldLabel.setHorizontalAlignment(0);
        this.fieldLabel.setAlignmentX(0.5f);
        this.add(this.fieldLabel);
    }

    private String buildValueStr(Integer value) {
        if (value == null) {
            return "??";
        }
        if (value >= 1000000000) {
            return this.buildShortenedStr((value + 50000000) / 100000000, "B");
        }
        if (value >= 1000000) {
            return this.buildShortenedStr((value + 50000) / 100000, "M");
        }
        if (value >= 1000) {
            return this.buildShortenedStr((value + 50) / 100, "K");
        }
        return NumberFormat.getInstance().format(value);
    }

    private String buildShortenedStr(int value, String suffix) {
        if (value > 100) {
            return Integer.toString(value / 10) + suffix;
        }
        return Float.toString((float)value / 10.0f) + suffix;
    }
}

