/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public class WatermarkTextField
extends JTextField {
    private final String watermarkText;
    private final Color watermarkColor;

    public WatermarkTextField(String watermarkText, Color watermarkColor) {
        this.watermarkColor = watermarkColor;
        this.watermarkText = watermarkText;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getText().isEmpty() && !this.isFocusOwner()) {
            g.setColor(this.watermarkColor);
            double height = g.getFontMetrics().getStringBounds(this.watermarkText, g).getHeight();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.drawString(this.watermarkText, 6, g.getFontMetrics().getAscent() + (int)(((double)this.getHeight() - height) / 2.0));
        }
    }
}

