/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TiledBackground
extends JPanel {
    private transient BufferedImage image;
    private int imageWidth;
    private int imageHeight;
    private boolean filterImage;

    public TiledBackground(BufferedImage image) {
        this.setImage(image);
    }

    public boolean getFilterImage() {
        return this.filterImage;
    }

    public void setFilterImage(boolean filterImage) {
        this.filterImage = filterImage;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (image != null) {
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int destWidth = this.getWidth();
        int destHeight = this.getHeight();
        if (this.image == null) {
            Color staticColor = new Color(this.getBackground().getRGB());
            g.setColor(staticColor);
            g.fillRect(0, 0, destWidth, destHeight);
            return;
        }
        int startY = 0;
        while (startY < destHeight) {
            int startX = 0;
            int nextStartY = startY + this.imageHeight;
            while (startX < destWidth) {
                int nextStartX = startX + this.imageWidth;
                g.drawImage(this.image, startX, startY, nextStartX, nextStartY, 0, 0, this.imageWidth, this.imageHeight, null);
                startX = nextStartX;
            }
            startY = nextStartY;
        }
        if (this.filterImage) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, destWidth, destHeight);
        }
    }
}

