/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.ui.controls;

import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public class SplatPane
extends JComponent {
    private JComponent hoverTarget;
    private Icon image;
    private int alignment;
    private int offsetX;
    private int offsetY;

    public SplatPane(JComponent hoverTarget, Icon image, int alignment, int offsetX, int offsetY) {
        this.hoverTarget = hoverTarget;
        this.image = image;
        this.alignment = alignment;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public void paintComponent(Graphics g) {
        int x = this.hoverTarget.getX();
        int y = this.hoverTarget.getY();
        int width = this.hoverTarget.getWidth();
        int height = this.hoverTarget.getHeight();
        x -= this.offsetX;
        y -= this.offsetY;
        int splatWidth = this.image.getIconWidth();
        int splatHeight = this.image.getIconHeight();
        int widthDiff = (width += this.offsetX * 2) - splatWidth;
        int heightDiff = (height += this.offsetY * 2) - splatHeight;
        if (this.alignment == 1 || this.alignment == 5) {
            x += widthDiff / 2;
        }
        if (this.alignment == 3 || this.alignment == 7) {
            y += heightDiff / 2;
        }
        if (this.alignment == 2 || this.alignment == 3 || this.alignment == 4) {
            x += widthDiff;
        }
        if (this.alignment == 4 || this.alignment == 5 || this.alignment == 6) {
            y += heightDiff;
        }
        g.clipRect(x, y, width, height);
        this.image.paintIcon(this, g, x, y);
    }
}

