/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.solder.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.exception.BuildInaccessibleException;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.rest.io.Modpack;
import net.technicpack.solder.ISolderPackApi;
import net.technicpack.solder.io.SolderPackInfo;
import net.technicpack.utilslib.Utils;
import org.joda.time.DateTime;
import org.joda.time.Seconds;

public class CachedSolderPackApi
implements ISolderPackApi {
    private final ISolderPackApi innerApi;
    private final int cacheInSeconds;
    private final String packSlug;
    private SolderPackInfo rootInfoCache = null;
    private DateTime lastInfoAccess = new DateTime(0L);
    private final Cache<String, Modpack> buildCache;
    private final Cache<String, Boolean> deadBuildCache;
    private final Path cachePath;

    public CachedSolderPackApi(LauncherFileSystem fileSystem, ISolderPackApi innerApi, int cacheInSeconds, String packSlug) {
        this.innerApi = innerApi;
        this.cacheInSeconds = cacheInSeconds;
        this.packSlug = packSlug;
        this.cachePath = fileSystem.getPackAssetsDirectory().resolve(packSlug).resolve("soldercache.json");
        this.buildCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds, TimeUnit.SECONDS).build();
        this.deadBuildCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds / 10, TimeUnit.SECONDS).build();
    }

    @Override
    public String getMirrorUrl() {
        return this.innerApi.getMirrorUrl();
    }

    @Override
    public SolderPackInfo getPackInfoForBulk() throws RestfulAPIException {
        if (this.rootInfoCache != null) {
            return this.rootInfoCache;
        }
        this.loadForeverCache();
        if (this.rootInfoCache != null) {
            return this.rootInfoCache;
        }
        return this.pullAndCache();
    }

    @Override
    public SolderPackInfo getPackInfo() throws RestfulAPIException {
        if (Seconds.secondsBetween(this.lastInfoAccess, DateTime.now()).isLessThan(Seconds.seconds(this.cacheInSeconds)) && this.rootInfoCache != null) {
            return this.rootInfoCache;
        }
        try {
            return this.pullAndCache();
        }
        catch (RestfulAPIException e) {
            e.printStackTrace();
            return this.getPackInfoForBulk();
        }
    }

    private SolderPackInfo pullAndCache() throws RestfulAPIException {
        try {
            this.rootInfoCache = this.innerApi.getPackInfoForBulk();
            this.saveForeverCache();
            SolderPackInfo solderPackInfo = this.rootInfoCache;
            return solderPackInfo;
        }
        finally {
            this.lastInfoAccess = DateTime.now();
        }
    }

    private void loadForeverCache() {
        if (!Files.exists(this.cachePath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.cachePath, StandardCharsets.UTF_8);){
            this.rootInfoCache = Utils.getGson().fromJson((Reader)reader, SolderPackInfo.class);
            if (this.rootInfoCache == null) {
                return;
            }
            this.rootInfoCache.setLocal();
            this.rootInfoCache.setSolder(this.innerApi);
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to load Solder cache for modpack \"%s\"", this.packSlug), e);
        }
    }

    private void saveForeverCache() {
        try {
            Files.createDirectories(this.cachePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.cachePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                Utils.getGson().toJson((Object)this.rootInfoCache, (Appendable)writer);
            }
        }
        catch (JsonIOException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to save Solder cache for modpack \"%s\"", this.packSlug), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Modpack getPackBuild(String build) throws BuildInaccessibleException {
        Boolean isDead = this.deadBuildCache.getIfPresent(build);
        if (Boolean.TRUE.equals(isDead)) {
            return null;
        }
        Modpack modpack = this.buildCache.getIfPresent(build);
        if (modpack != null) {
            return modpack;
        }
        try {
            modpack = this.innerApi.getPackBuild(build);
            if (modpack != null) {
                this.buildCache.put(build, modpack);
            }
            Modpack modpack2 = modpack;
            this.deadBuildCache.put(build, modpack == null);
            return modpack2;
        }
        catch (Throwable throwable) {
            this.deadBuildCache.put(build, modpack == null);
            throw throwable;
        }
    }
}

