/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.rest.io;

import java.io.File;
import java.io.IOException;
import net.technicpack.rest.io.Resource;

public class Mod
extends Resource {
    private String name;
    private String version;

    public Mod() {
    }

    public Mod(String name, String version, String url, String md5) {
        super(url, md5);
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public File generateSafeCacheFile(File cacheDir) throws IOException {
        String filename = this.version != null && !this.version.isEmpty() ? this.name + "-" + this.version + ".zip" : this.name + ".zip";
        File filePath = new File(cacheDir, filename = filename.replaceAll("[\\\\/:*?\"<>|]", "-"));
        if (!filePath.toPath().normalize().startsWith(cacheDir.toPath())) {
            throw new IOException("Unsafe mod cache path detected (" + filePath + ") with base " + cacheDir);
        }
        return filePath;
    }

    public String toString() {
        return "Mod{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", url='" + this.getUrl() + '\'' + ", md5='" + this.getMd5() + '\'' + '}';
    }
}

