/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.rest;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.rest.RestfulAPIException;

public abstract class RestObject {
    private static final Gson gson = new Gson();
    private String error;

    public static <T extends RestObject> T getRestObject(Class<T> restObject, String url) throws RestfulAPIException {
        try {
            RestObject result;
            URLConnection conn = new URL(url).openConnection();
            conn.setRequestProperty("User-Agent", TechnicConstants.getUserAgent());
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                result = (RestObject)gson.fromJson((Reader)reader, restObject);
            }
            if (result == null) {
                throw new RestfulAPIException(String.format("Unable to access URL [%s]", url));
            }
            if (result.hasError()) {
                throw new RestfulAPIException(String.format("Error in response: %s", result.getError()));
            }
            return (T)result;
        }
        catch (SocketTimeoutException e) {
            throw new RestfulAPIException(String.format("Timed out accessing URL [%s]", url), e);
        }
        catch (MalformedURLException e) {
            throw new RestfulAPIException(String.format("Invalid URL [%s]", url), e);
        }
        catch (JsonIOException | IOException e) {
            throw new RestfulAPIException(String.format("Error accessing URL [%s]", url), e);
        }
        catch (JsonParseException e) {
            throw new RestfulAPIException(String.format("Error parsing response JSON at URL [%s]", url), e);
        }
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }
}

