/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.platform.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.technicpack.platform.io.FeedItem;
import net.technicpack.rest.RestObject;
import net.technicpack.rest.io.Modpack;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.rest.io.Resource;

public class PlatformPackInfo
extends RestObject
implements PackInfo {
    private String name;
    private String displayName;
    private String url;
    private String platformUrl;
    private Resource icon;
    private Resource logo;
    private Resource background;
    private String minecraft;
    private String forge;
    private String version;
    private String solder;
    private String description;
    private Integer ratings;
    private Integer runs;
    private Integer installs;
    private boolean isServer;
    private boolean isOfficial;
    private String discordServerId;
    private ArrayList<FeedItem> feed = new ArrayList();
    private transient boolean isLocal = false;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getWebSite() {
        return this.platformUrl;
    }

    @Override
    public Resource getIcon() {
        return this.icon;
    }

    @Override
    public Resource getBackground() {
        return this.background;
    }

    @Override
    public Resource getLogo() {
        return this.logo;
    }

    protected String getVersion() {
        if (this.hasSolder()) {
            return null;
        }
        return this.version;
    }

    @Override
    public String getRecommended() {
        return this.getVersion();
    }

    @Override
    public String getLatest() {
        return this.getVersion();
    }

    @Override
    public ArrayList<FeedItem> getFeed() {
        return this.feed;
    }

    @Override
    public String getDiscordId() {
        return this.discordServerId;
    }

    @Override
    public List<String> getBuilds() {
        if (this.hasSolder()) {
            return Collections.emptyList();
        }
        ArrayList<String> builds = new ArrayList<String>();
        builds.add(this.version);
        return builds;
    }

    public String getGameVersion() {
        return this.minecraft;
    }

    public String getForge() {
        return this.forge;
    }

    public String getSolder() {
        return this.solder;
    }

    @Override
    public boolean hasSolder() {
        return this.solder != null && !this.solder.isEmpty();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc facilisis congue dignissim. Aliquam posuere eros vel eros luctus molestie. Duis non massa vel orci sagittis semper. Pellentesque lorem diam, viverra in bibendum in, tincidunt in neque. Curabitur consectetur aliquam sem eget laoreet. Quisque eget turpis a velit semper dictum at ut neque. Nulla placerat odio eget neque commodo posuere. Nam porta lacus elit, a rutrum enim mollis vel.";
        }
        return this.description;
    }

    @Override
    public Integer getLikes() {
        return this.ratings;
    }

    @Override
    public Integer getRuns() {
        return this.runs;
    }

    @Override
    public Integer getInstalls() {
        return this.installs;
    }

    @Override
    public boolean isServerPack() {
        return this.isServer;
    }

    @Override
    public Modpack getModpack(String build) {
        return new Modpack(this);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setLocal() {
        this.isLocal = true;
    }

    @Override
    public boolean isLocal() {
        if (this.hasSolder()) {
            return true;
        }
        return this.isLocal;
    }

    @Override
    public boolean isOfficial() {
        return this.isOfficial;
    }

    public String toString() {
        return "PlatformPackInfo{name='" + this.name + '\'' + ", displayName='" + this.displayName + '\'' + ", url='" + this.url + '\'' + ", icon=" + this.icon + ", logo=" + this.logo + ", background=" + this.background + ", gameVersion='" + this.minecraft + '\'' + ", forge='" + this.forge + '\'' + ", version='" + this.version + '\'' + ", solder='" + this.solder + '\'' + '}';
    }
}

