/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.platform.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.NewsData;
import net.technicpack.platform.io.PlatformPackInfo;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.utilslib.Utils;

public class ModpackCachePlatformApi
implements IPlatformApi {
    private IPlatformApi innerApi;
    private Cache<String, PlatformPackInfo> cache;
    private Cache<String, Boolean> deadPacks;
    private Cache<String, PlatformPackInfo> foreverCache;
    private LauncherFileSystem fileSystem;

    public ModpackCachePlatformApi(IPlatformApi innerApi, int cacheInSeconds, LauncherFileSystem fileSystem) {
        this.innerApi = innerApi;
        this.fileSystem = fileSystem;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds, TimeUnit.SECONDS).build();
        this.foreverCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).build();
        this.deadPacks = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheInSeconds / 10, TimeUnit.SECONDS).build();
    }

    @Override
    public PlatformPackInfo getPlatformPackInfoForBulk(String packSlug) throws RestfulAPIException {
        PlatformPackInfo info = this.foreverCache.getIfPresent(packSlug);
        if (info == null) {
            info = this.loadForeverCache(packSlug);
        }
        if (info == null && this.isDead(packSlug)) {
            return null;
        }
        if (info == null) {
            info = this.pullAndCache(packSlug);
        }
        return info;
    }

    @Override
    public PlatformPackInfo getPlatformPackInfo(String packSlug) {
        PlatformPackInfo info = this.cache.getIfPresent(packSlug);
        if (info == null && this.isDead(packSlug)) {
            return this.getDeadPackInfo(packSlug);
        }
        try {
            if (info == null) {
                info = this.pullAndCache(packSlug);
            }
        }
        catch (RestfulAPIException e) {
            e.printStackTrace();
            this.deadPacks.put(packSlug, true);
            return this.getDeadPackInfo(packSlug);
        }
        return info;
    }

    protected PlatformPackInfo getDeadPackInfo(String packSlug) {
        try {
            PlatformPackInfo deadInfo = this.getPlatformPackInfoForBulk(packSlug);
            if (deadInfo != null) {
                deadInfo.setLocal();
            }
            return deadInfo;
        }
        catch (RestfulAPIException e) {
            return null;
        }
    }

    private boolean isDead(String packSlug) {
        Boolean isDead = this.deadPacks.getIfPresent(packSlug);
        return isDead != null && isDead != false;
    }

    private PlatformPackInfo pullAndCache(String packSlug) throws RestfulAPIException {
        PlatformPackInfo info = null;
        try {
            info = this.innerApi.getPlatformPackInfoForBulk(packSlug);
            if (info != null) {
                this.cache.put(packSlug, info);
                this.foreverCache.put(packSlug, info);
                this.saveForeverCache(info);
            }
            this.deadPacks.put(packSlug, info == null);
        }
        catch (Throwable throwable) {
            this.deadPacks.put(packSlug, info == null);
            throw throwable;
        }
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PlatformPackInfo loadForeverCache(String packSlug) {
        Path cacheFile = this.fileSystem.getPackAssetsDirectory().resolve(packSlug).resolve("cache.json");
        if (!Files.exists(cacheFile, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(cacheFile, StandardCharsets.UTF_8);){
            PlatformPackInfo info = Utils.getGson().fromJson((Reader)reader, PlatformPackInfo.class);
            if (info != null) {
                this.foreverCache.put(packSlug, info);
            }
            PlatformPackInfo platformPackInfo = info;
            return platformPackInfo;
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to load pack cache %s", cacheFile), e);
            return null;
        }
    }

    private void saveForeverCache(PlatformPackInfo info) {
        Path cacheFile = this.fileSystem.getPackAssetsDirectory().resolve(info.getName()).resolve("cache.json");
        try {
            Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(cacheFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                Utils.getGson().toJson((Object)info, (Appendable)writer);
            }
        }
        catch (JsonIOException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to save pack cache %s", cacheFile), e);
        }
    }

    @Override
    public String getPlatformUri(String packSlug) {
        return this.innerApi.getPlatformUri(packSlug);
    }

    @Override
    public void incrementPackRuns(String packSlug) {
        this.innerApi.incrementPackRuns(packSlug);
    }

    @Override
    public void incrementPackInstalls(String packSlug) {
        this.innerApi.incrementPackInstalls(packSlug);
    }

    @Override
    public NewsData getNews() throws RestfulAPIException {
        return this.innerApi.getNews();
    }
}

