/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.launch.WindowType;
import net.technicpack.utilslib.OperatingSystem;

public class Rule {
    private static final String HAS_CUSTOM_RESOLUTION = "has_custom_resolution";
    private static final String IS_DEMO_USER = "is_demo_user";
    private static final String HAS_QUICK_PLAYS_SUPPORT = "has_quick_plays_support";
    private static final String IS_QUICK_PLAY_SINGLEPLAYER = "is_quick_play_singleplayer";
    private static final String IS_QUICK_PLAY_MULTIPLAYER = "is_quick_play_multiplayer";
    private static final String IS_QUICK_PLAY_REALMS = "is_quick_play_realms";
    private static final String FEATURES_FIELD = "features";
    private static final String ACTION_FIELD = "action";
    private static final String OS_FIELD = "os";
    private static final String OS_NAME_FIELD = "name";
    private static final String OS_VERSION_FIELD = "version";
    private static final String OS_ARCH_FIELD = "arch";
    private static final String ACTION_ALLOW_VALUE = "allow";
    private static final String ACTION_DISALLOW_VALUE = "disallow";
    private final boolean negated;
    private final List<RuleCondition> conditions = new ArrayList<RuleCondition>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.negated == rule.negated && Objects.equals(this.conditions, rule.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.negated, this.conditions);
    }

    public static boolean isAllowable(List<Rule> rules, ILaunchOptions options, IJavaRuntime runtime) {
        for (int i = rules.size() - 1; i >= 0; --i) {
            Rule rule = rules.get(i);
            if (!rule.isApplicable(options, runtime)) continue;
            return !rule.isNegated();
        }
        return false;
    }

    public Rule(JsonObject rule) {
        String action;
        switch (action = rule.get(ACTION_FIELD).getAsString()) {
            case "allow": {
                this.negated = false;
                break;
            }
            case "disallow": {
                this.negated = true;
                break;
            }
            default: {
                throw new JsonSyntaxException("Expected rule action, got: " + action);
            }
        }
        if (rule.has(OS_FIELD)) {
            JsonObject os = rule.get(OS_FIELD).getAsJsonObject();
            this.conditions.add(new OsCondition(os.has(OS_NAME_FIELD) ? os.get(OS_NAME_FIELD).getAsString() : null, os.has(OS_VERSION_FIELD) ? os.get(OS_VERSION_FIELD).getAsString() : null, os.has(OS_ARCH_FIELD) ? os.get(OS_ARCH_FIELD).getAsString() : null));
        }
        if (rule.has(FEATURES_FIELD)) {
            JsonObject features = rule.get(FEATURES_FIELD).getAsJsonObject();
            Iterator<String> iterator = features.keySet().iterator();
            block24: while (iterator.hasNext()) {
                String feature;
                switch (feature = iterator.next()) {
                    case "has_custom_resolution": {
                        this.conditions.add(new CustomResolutionCondition(features.get(HAS_CUSTOM_RESOLUTION).getAsBoolean()));
                        continue block24;
                    }
                    case "is_demo_user": {
                        this.conditions.add(new DemoUserCondition(features.get(IS_DEMO_USER).getAsBoolean()));
                        continue block24;
                    }
                    case "has_quick_plays_support": {
                        this.conditions.add(new QuickPlaysSupportCondition(features.get(HAS_QUICK_PLAYS_SUPPORT).getAsBoolean()));
                        continue block24;
                    }
                    case "is_quick_play_singleplayer": {
                        this.conditions.add(new QuickPlaySingleplayerCondition(features.get(IS_QUICK_PLAY_SINGLEPLAYER).getAsBoolean()));
                        continue block24;
                    }
                    case "is_quick_play_multiplayer": {
                        this.conditions.add(new QuickPlayMultiplayerCondition(features.get(IS_QUICK_PLAY_MULTIPLAYER).getAsBoolean()));
                        continue block24;
                    }
                    case "is_quick_play_realms": {
                        this.conditions.add(new QuickPlayRealmsCondition(features.get(IS_QUICK_PLAY_REALMS).getAsBoolean()));
                        continue block24;
                    }
                }
                throw new JsonSyntaxException("Unknown feature: " + feature);
            }
        }
    }

    public boolean isApplicable(ILaunchOptions options, IJavaRuntime runtime) {
        if (this.conditions.isEmpty()) {
            return true;
        }
        for (RuleCondition condition : this.conditions) {
            if (condition.test(options, runtime)) continue;
            return false;
        }
        return true;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        for (RuleCondition condition : this.conditions) {
            condition.serialize(json);
        }
        json.addProperty(ACTION_FIELD, this.negated ? ACTION_DISALLOW_VALUE : ACTION_ALLOW_VALUE);
        return json;
    }

    private static JsonObject getFeatures(JsonObject root) {
        if (root.has(FEATURES_FIELD)) {
            return root.get(FEATURES_FIELD).getAsJsonObject();
        }
        JsonObject features = new JsonObject();
        root.add(FEATURES_FIELD, features);
        return features;
    }

    private static class QuickPlayRealmsCondition
    implements RuleCondition {
        private final boolean shouldQuickPlayBeRealms;

        QuickPlayRealmsCondition(boolean shouldQuickPlayBeRealms) {
            this.shouldQuickPlayBeRealms = shouldQuickPlayBeRealms;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuickPlayRealmsCondition that = (QuickPlayRealmsCondition)o;
            return this.shouldQuickPlayBeRealms == that.shouldQuickPlayBeRealms;
        }

        public int hashCode() {
            return Objects.hashCode(this.shouldQuickPlayBeRealms);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            return !this.shouldQuickPlayBeRealms;
        }

        @Override
        public void serialize(JsonObject root) {
            Rule.getFeatures(root).addProperty(Rule.IS_QUICK_PLAY_REALMS, this.shouldQuickPlayBeRealms);
        }
    }

    private static class QuickPlayMultiplayerCondition
    implements RuleCondition {
        private final boolean shouldQuickPlayBeMultiplayer;

        QuickPlayMultiplayerCondition(boolean shouldQuickPlayBeMultiplayer) {
            this.shouldQuickPlayBeMultiplayer = shouldQuickPlayBeMultiplayer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuickPlayMultiplayerCondition that = (QuickPlayMultiplayerCondition)o;
            return this.shouldQuickPlayBeMultiplayer == that.shouldQuickPlayBeMultiplayer;
        }

        public int hashCode() {
            return Objects.hashCode(this.shouldQuickPlayBeMultiplayer);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            return !this.shouldQuickPlayBeMultiplayer;
        }

        @Override
        public void serialize(JsonObject root) {
            Rule.getFeatures(root).addProperty(Rule.IS_QUICK_PLAY_MULTIPLAYER, this.shouldQuickPlayBeMultiplayer);
        }
    }

    private static class QuickPlaySingleplayerCondition
    implements RuleCondition {
        private final boolean shouldQuickPlayBeSingleplayer;

        QuickPlaySingleplayerCondition(boolean shouldQuickPlayBeSingleplayer) {
            this.shouldQuickPlayBeSingleplayer = shouldQuickPlayBeSingleplayer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuickPlaySingleplayerCondition that = (QuickPlaySingleplayerCondition)o;
            return this.shouldQuickPlayBeSingleplayer == that.shouldQuickPlayBeSingleplayer;
        }

        public int hashCode() {
            return Objects.hashCode(this.shouldQuickPlayBeSingleplayer);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            return !this.shouldQuickPlayBeSingleplayer;
        }

        @Override
        public void serialize(JsonObject root) {
            Rule.getFeatures(root).addProperty(Rule.IS_QUICK_PLAY_SINGLEPLAYER, this.shouldQuickPlayBeSingleplayer);
        }
    }

    private static class QuickPlaysSupportCondition
    implements RuleCondition {
        private final boolean shouldHaveQuickPlaysSupport;

        QuickPlaysSupportCondition(boolean shouldHaveQuickPlaysSupport) {
            this.shouldHaveQuickPlaysSupport = shouldHaveQuickPlaysSupport;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuickPlaysSupportCondition that = (QuickPlaysSupportCondition)o;
            return this.shouldHaveQuickPlaysSupport == that.shouldHaveQuickPlaysSupport;
        }

        public int hashCode() {
            return Objects.hashCode(this.shouldHaveQuickPlaysSupport);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            return !this.shouldHaveQuickPlaysSupport;
        }

        @Override
        public void serialize(JsonObject root) {
            Rule.getFeatures(root).addProperty(Rule.HAS_QUICK_PLAYS_SUPPORT, this.shouldHaveQuickPlaysSupport);
        }
    }

    private static class DemoUserCondition
    implements RuleCondition {
        private final boolean shouldBeDemoUser;

        DemoUserCondition(boolean shouldBeDemoUser) {
            this.shouldBeDemoUser = shouldBeDemoUser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DemoUserCondition that = (DemoUserCondition)o;
            return this.shouldBeDemoUser == that.shouldBeDemoUser;
        }

        public int hashCode() {
            return Objects.hashCode(this.shouldBeDemoUser);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            return !this.shouldBeDemoUser;
        }

        @Override
        public void serialize(JsonObject root) {
            Rule.getFeatures(root).addProperty(Rule.IS_DEMO_USER, this.shouldBeDemoUser);
        }
    }

    private static class CustomResolutionCondition
    implements RuleCondition {
        private final boolean shouldHaveCustomResolution;

        CustomResolutionCondition(boolean shouldHaveCustomResolution) {
            this.shouldHaveCustomResolution = shouldHaveCustomResolution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomResolutionCondition that = (CustomResolutionCondition)o;
            return this.shouldHaveCustomResolution == that.shouldHaveCustomResolution;
        }

        public int hashCode() {
            return Objects.hashCode(this.shouldHaveCustomResolution);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            return opts != null && opts.getLaunchWindowType() == WindowType.CUSTOM == this.shouldHaveCustomResolution;
        }

        @Override
        public void serialize(JsonObject root) {
            Rule.getFeatures(root).addProperty(Rule.HAS_CUSTOM_RESOLUTION, this.shouldHaveCustomResolution);
        }
    }

    private static class OsCondition
    implements RuleCondition {
        private final String name;
        private final Pattern version;
        private final String arch;

        OsCondition(String name, String version, String arch) {
            this.name = name;
            this.version = version == null ? null : Pattern.compile(version, 2);
            this.arch = arch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OsCondition that = (OsCondition)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.arch, that.arch);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version, this.arch);
        }

        @Override
        public boolean test(ILaunchOptions opts, IJavaRuntime runtime) {
            String os = OperatingSystem.getOperatingSystem().getName();
            String osVersion = System.getProperty("os.version");
            String archProp = runtime.getOsArch().toLowerCase(Locale.ROOT);
            return !(this.name != null && !this.name.equalsIgnoreCase(os) || this.version != null && !this.version.matcher(osVersion).matches() || this.arch != null && !archProp.contains(this.arch.toLowerCase()));
        }

        @Override
        public void serialize(JsonObject root) {
            JsonObject os = new JsonObject();
            if (this.name != null) {
                os.addProperty(Rule.OS_NAME_FIELD, this.name);
            }
            if (this.version != null) {
                os.addProperty(Rule.OS_VERSION_FIELD, this.version.pattern());
            }
            if (this.arch != null) {
                os.addProperty(Rule.OS_ARCH_FIELD, this.arch);
            }
            root.add(Rule.OS_FIELD, os);
        }
    }

    private static interface RuleCondition {
        public boolean test(ILaunchOptions var1, IJavaRuntime var2);

        public void serialize(JsonObject var1);
    }
}

