/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.io;

import java.util.List;
import java.util.stream.Collectors;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.AssetIndex;
import net.technicpack.minecraftcore.mojang.version.io.GameDownloads;
import net.technicpack.minecraftcore.mojang.version.io.LaunchArguments;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import net.technicpack.minecraftcore.mojang.version.io.MinecraftVersionInfoRaw;
import net.technicpack.minecraftcore.mojang.version.io.ReleaseType;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;

public class MinecraftVersionInfo
implements IMinecraftVersionInfo {
    private final String id;
    private final ReleaseType type;
    private final LaunchArguments arguments;
    private final List<Library> libraries;
    private final List<Rule> rules;
    private final String assets;
    private final AssetIndex assetIndex;
    private final GameDownloads downloads;
    private final String inheritsFrom;
    private final VersionJavaInfo javaVersion;
    private String mainClass;
    private transient boolean areAssetsVirtual;
    private transient boolean mapToResources;
    private transient IJavaRuntime javaRuntime;

    MinecraftVersionInfo(MinecraftVersionInfoRaw raw) {
        this.id = raw.id;
        this.type = raw.type;
        if (raw.arguments != null) {
            this.arguments = raw.arguments;
        } else if (raw.minecraftArguments != null && !raw.minecraftArguments.isEmpty()) {
            this.arguments = LaunchArguments.fromLegacyString(raw.minecraftArguments);
        } else {
            throw new IllegalArgumentException("No arguments found");
        }
        this.libraries = raw.libraries;
        this.mainClass = raw.mainClass;
        this.rules = raw.rules;
        this.assets = raw.assets;
        this.assetIndex = raw.assetIndex;
        this.downloads = raw.downloads;
        this.inheritsFrom = raw.inheritsFrom;
        this.javaVersion = raw.javaVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public ArgumentList getMinecraftArguments() {
        return this.arguments.getGameArgs();
    }

    @Override
    public ArgumentList getJavaArguments() {
        return this.arguments.getJvmArgs();
    }

    @Override
    public List<Library> getLibraries() {
        return this.libraries;
    }

    @Override
    public List<Library> getLibrariesForCurrentOS(ILaunchOptions options, IJavaRuntime runtime) {
        return this.libraries.stream().filter(x -> x.isForCurrentOS(options, runtime)).distinct().collect(Collectors.toList());
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public String getAssetsKey() {
        return this.assets;
    }

    @Override
    public AssetIndex getAssetIndex() {
        return this.assetIndex;
    }

    @Override
    public GameDownloads getDownloads() {
        return this.downloads;
    }

    @Override
    public String getParentVersion() {
        return this.inheritsFrom;
    }

    @Override
    public boolean getAreAssetsVirtual() {
        return this.areAssetsVirtual;
    }

    @Override
    public void setAreAssetsVirtual(boolean areAssetsVirtual) {
        this.areAssetsVirtual = areAssetsVirtual;
    }

    @Override
    public boolean getAssetsMapToResources() {
        return this.mapToResources;
    }

    @Override
    public void setAssetsMapToResources(boolean mapToResources) {
        this.mapToResources = mapToResources;
    }

    @Override
    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    @Override
    public void prependLibrary(Library library) {
        this.libraries.add(0, library);
    }

    @Override
    public VersionJavaInfo getMojangRuntimeInformation() {
        return this.javaVersion;
    }

    @Override
    public void removeLibrary(String libraryName) {
        this.libraries.removeIf(library -> library.getName().equals(libraryName));
    }

    @Override
    public IJavaRuntime getJavaRuntime() {
        return this.javaRuntime;
    }

    @Override
    public void setJavaRuntime(IJavaRuntime runtime) {
        this.javaRuntime = runtime;
    }

    public String toString() {
        return "MinecraftVersionInfo{id='" + this.id + '\'' + ", type=" + (Object)((Object)this.type) + ", arguments=" + this.arguments + ", libraries=" + this.libraries + ", mainClass='" + this.mainClass + '\'' + ", rules=" + this.rules + ", assets='" + this.assets + '\'' + ", assetIndex=" + this.assetIndex + ", downloads=" + this.downloads + ", inheritsFrom='" + this.inheritsFrom + '\'' + ", javaVersion=" + this.javaVersion + ", areAssetsVirtual=" + this.areAssetsVirtual + ", mapToResources=" + this.mapToResources + ", javaRuntime=" + this.javaRuntime + '}';
    }
}

