/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.mojang.version.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.MinecraftVersionInfoBuilder;
import net.technicpack.minecraftcore.mojang.version.builder.MinecraftVersionInfoRetriever;
import net.technicpack.minecraftcore.mojang.version.io.MinecraftVersionInfo;

public class FileMinecraftVersionInfoBuilder
implements MinecraftVersionInfoBuilder {
    private File version;
    private MinecraftVersionInfoRetriever retriever;
    private List<MinecraftVersionInfoRetriever> fallbackRetrievers;

    public FileMinecraftVersionInfoBuilder(File version, MinecraftVersionInfoRetriever retriever, List<MinecraftVersionInfoRetriever> fallbackRetrievers) {
        this.version = version;
        this.retriever = retriever;
        this.fallbackRetrievers = fallbackRetrievers;
    }

    @Override
    public IMinecraftVersionInfo buildVersionFromKey(String key) throws InterruptedException, IOException {
        File target = this.version;
        if (key != null) {
            if (this.version.isDirectory()) {
                String targetFile = key + ".json";
                target = new File(this.version, targetFile);
            }
            if (this.retriever != null) {
                this.retriever.retrieveVersion(target, key);
            }
            if (this.fallbackRetrievers != null) {
                for (MinecraftVersionInfoRetriever fallbackRetriever : this.fallbackRetrievers) {
                    if (target.exists()) break;
                    fallbackRetriever.retrieveVersion(target, key);
                }
            }
        }
        if (!target.exists()) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(target.toPath(), StandardCharsets.UTF_8);){
            IMinecraftVersionInfo iMinecraftVersionInfo = MojangUtils.getGson().fromJson((Reader)reader, MinecraftVersionInfo.class);
            return iMinecraftVersionInfo;
        }
    }
}

