/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.microsoft.auth;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v5.Apache5HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import net.technicpack.launchercore.exception.AuthenticationException;
import net.technicpack.launchercore.exception.MicrosoftAuthException;
import net.technicpack.launchercore.exception.SessionException;
import net.technicpack.minecraftcore.microsoft.auth.MicrosoftUser;
import net.technicpack.minecraftcore.microsoft.auth.model.Entitlements;
import net.technicpack.minecraftcore.microsoft.auth.model.MinecraftError;
import net.technicpack.minecraftcore.microsoft.auth.model.MinecraftProfile;
import net.technicpack.minecraftcore.microsoft.auth.model.XSTSRequest;
import net.technicpack.minecraftcore.microsoft.auth.model.XSTSUnauthorized;
import net.technicpack.minecraftcore.microsoft.auth.model.XboxAuthRequest;
import net.technicpack.minecraftcore.microsoft.auth.model.XboxMinecraftRequest;
import net.technicpack.minecraftcore.microsoft.auth.model.XboxMinecraftResponse;
import net.technicpack.minecraftcore.microsoft.auth.model.XboxResponse;
import net.technicpack.utilslib.DesktopUtils;
import net.technicpack.utilslib.Utils;

public class MicrosoftAuthenticator {
    private static final HttpTransport HTTP_TRANSPORT = new Apache5HttpTransport();
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private final HttpRequestFactory REQUEST_FACTORY = HTTP_TRANSPORT.createRequestFactory(request -> {
        request.setParser(new JsonObjectParser(JSON_FACTORY));
        request.setLoggingEnabled(true);
        request.setCurlLoggingEnabled(true);
    });
    private static final String TECHNIC_CLIENT_ID = "8dfabc1d-38a9-42d8-bc08-677dbc60fe65";
    private static final String[] SCOPES = new String[]{"XboxLive.signin", "XboxLive.offline_access"};
    private static final String TOKEN_SERVER_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/token";
    private static final String AUTHORIZATION_SERVER_URL = "https://login.live.com/oauth20_authorize.srf?prompt=select_account&cobrandid=8058f65d-ce06-4c30-9559-473c9275a65d";
    private final FileDataStoreFactory dataStoreFactory;
    private static final String XBOX_AUTH_URL = "https://user.auth.xboxlive.com/user/authenticate";
    private static final String XBOX_XSTS_URL = "https://xsts.auth.xboxlive.com/xsts/authorize";
    private static final String MINECRAFT_AUTH_URL = "https://api.minecraftservices.com/launcher/login";
    private static final String MINECRAFT_PROFILE_URL = "https://api.minecraftservices.com/minecraft/profile";
    private static final String MINECRAFT_ENTITLEMENTS_URL = "https://api.minecraftservices.com/entitlements/license";
    private LocalServerReceiver receiver;

    public MicrosoftAuthenticator(File dataStore) {
        Path dataStorePath = Paths.get(dataStore.getAbsolutePath(), new String[0]);
        if (Files.exists(dataStorePath, new LinkOption[0])) {
            try {
                FileOwnerAttributeView fileAttributeView = Files.getFileAttributeView(dataStorePath, FileOwnerAttributeView.class, new LinkOption[0]);
                fileAttributeView.getOwner();
            }
            catch (AccessDeniedException e) {
                try {
                    Files.delete(dataStorePath);
                }
                catch (IOException e2) {
                    Sentry.captureException(e2);
                    throw new RuntimeException(e2);
                }
            }
            catch (IOException e) {
                Sentry.captureException(e);
            }
        }
        try {
            this.dataStoreFactory = new FileDataStoreFactory(dataStore);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to setup credential store.", e);
        }
    }

    public MicrosoftUser loginNewUser() throws MicrosoftAuthException {
        String tempCredentialId = UUID.randomUUID().toString();
        Credential credential = this.getOAuthCredential(tempCredentialId);
        XboxResponse xboxResponse = this.authenticateXbox(credential);
        XboxResponse xstsResponse = this.authenticateXSTS(xboxResponse.token);
        XboxMinecraftResponse xboxMinecraftResponse = this.authenticateMinecraftXbox(xstsResponse);
        if (!this.checkMinecraftOwnership(this.getEntitlements(xboxMinecraftResponse))) {
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.NO_MINECRAFT, "Microsoft account does not own Minecraft");
        }
        MinecraftProfile profile = this.getMinecraftProfile(xboxMinecraftResponse);
        this.updateCredentialStore(profile.id, credential);
        return new MicrosoftUser(xboxMinecraftResponse, profile);
    }

    public void refreshSession(MicrosoftUser user) throws AuthenticationException {
        Credential credential = this.loadExistingCredential(user.getId());
        if (credential == null) {
            credential = this.loadExistingCredential(user.getUsername());
        }
        if (credential == null) {
            throw new SessionException("Microsoft login expired or is invalid");
        }
        try {
            if (!credential.refreshToken()) {
                throw new SessionException("Microsoft login expired or is invalid");
            }
        }
        catch (TokenResponseException e) {
            throw new SessionException("Microsoft login expired or is invalid", e);
        }
        catch (IOException e) {
            throw new AuthenticationException("Failed to refresh session", e);
        }
        this.updateCredentialStore(user.getId(), credential);
        XboxResponse xboxResponse = this.authenticateXbox(credential);
        XboxResponse xstsResponse = this.authenticateXSTS(xboxResponse.token);
        XboxMinecraftResponse xboxMinecraftResponse = this.authenticateMinecraftXbox(xstsResponse);
        user.setAuthToken(xboxMinecraftResponse);
        if (!this.checkMinecraftOwnership(this.getEntitlements(xboxMinecraftResponse))) {
            throw new SessionException("Microsoft account does not own Minecraft");
        }
        MinecraftProfile profile = this.getMinecraftProfile(xboxMinecraftResponse);
        user.setProfile(profile);
    }

    private Credential getOAuthCredential(String id) throws MicrosoftAuthException {
        this.receiver = new LocalServerReceiver.Builder().setHost("localhost").setPort(-1).setCallbackPath("/").build();
        try {
            AuthorizationCodeFlow flow = this.buildFlow();
            return new AuthorizationCodeInstalledApp(flow, this.receiver, DesktopUtils::browseUrl).authorize(id);
        }
        catch (StreamCorruptedException e) {
            File[] files;
            Utils.getLogger().log(Level.SEVERE, "Data store is corrupt, purging", e);
            File dataDir = this.dataStoreFactory.getDataDirectory();
            if (dataDir != null && dataDir.exists() && (files = dataDir.listFiles()) != null) {
                for (File file : files) {
                    if (file.delete()) continue;
                    Utils.getLogger().log(Level.SEVERE, "Failed to delete " + file.getAbsolutePath());
                }
            }
            return this.getOAuthCredential(id);
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to get OAuth authorization", e);
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.OAUTH, "Failed to get OAuth authorization", (Throwable)e);
        }
    }

    public void stopReceiver() {
        try {
            this.receiver.stop();
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to stop receiver", e);
        }
    }

    private Credential loadExistingCredential(String username) throws MicrosoftAuthException {
        try {
            AuthorizationCodeFlow flow = this.buildFlow();
            return flow.loadCredential(username);
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to load from credential store.", e);
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.OAUTH, "Failed to load from credential store.");
        }
    }

    private XboxResponse authenticateXbox(Credential credential) throws MicrosoftAuthException {
        XboxAuthRequest xboxAuthRequest = new XboxAuthRequest(credential.getAccessToken());
        JsonHttpContent httpContent = new JsonHttpContent(JSON_FACTORY, xboxAuthRequest);
        HttpRequest request = this.buildPostRequest(XBOX_AUTH_URL, httpContent);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse httpResponse = null;
        try {
            httpResponse = request.execute();
            XboxResponse xboxResponse = httpResponse.parseAs(XboxResponse.class);
            return xboxResponse;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to get Xbox authentication.", e);
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.XBOX, "Failed to get Xbox authentication.", (Throwable)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private XboxResponse authenticateXSTS(String token) throws MicrosoftAuthException {
        XSTSRequest xstsRequest = new XSTSRequest(token);
        JsonHttpContent httpContent = new JsonHttpContent(JSON_FACTORY, xstsRequest);
        HttpRequest request = this.buildPostRequest(XBOX_XSTS_URL, httpContent);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse httpResponse = null;
        try {
            httpResponse = request.execute();
            httpResponse.setLoggingEnabled(true);
            switch (httpResponse.getStatusCode()) {
                case 401: {
                    XSTSUnauthorized unauthorized = httpResponse.parseAs(XSTSUnauthorized.class);
                    throw new MicrosoftAuthException(unauthorized.getExceptionType(), "Failed to get XSTS authentication.");
                }
                case 200: {
                    XboxResponse xboxResponse = httpResponse.parseAs(XboxResponse.class);
                    return xboxResponse;
                }
            }
            try {
                throw new HttpResponseException(httpResponse);
            }
            catch (IOException e) {
                Utils.getLogger().log(Level.SEVERE, "Failed to get XSTS authentication.", e);
                throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.XSTS, "Failed to get XSTS authentication.", (Throwable)e);
            }
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private XboxMinecraftResponse authenticateMinecraftXbox(XboxResponse xstsResponse) throws MicrosoftAuthException {
        XboxMinecraftRequest xboxMinecraftRequest = new XboxMinecraftRequest(xstsResponse);
        JsonHttpContent httpContent = new JsonHttpContent(JSON_FACTORY, xboxMinecraftRequest);
        HttpRequest request = this.buildPostRequest(MINECRAFT_AUTH_URL, httpContent);
        HttpResponse httpResponse = null;
        try {
            httpResponse = request.execute();
            XboxMinecraftResponse xboxMinecraftResponse = httpResponse.parseAs(XboxMinecraftResponse.class);
            return xboxMinecraftResponse;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to authenticate with Xbox for Minecraft.", e);
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.XBOX_MINECRAFT, "Failed to authenticate with Xbox for Minecraft.", (Throwable)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Entitlements getEntitlements(XboxMinecraftResponse xboxMinecraftResponse) throws MicrosoftAuthException {
        HttpRequest request = this.buildGetRequest(String.format("%s?requestId=%s", MINECRAFT_ENTITLEMENTS_URL, UUID.randomUUID()));
        String authorization = xboxMinecraftResponse.getAuthorization();
        request.setHeaders(request.getHeaders().setAuthorization(authorization));
        HttpResponse httpResponse = null;
        try {
            httpResponse = request.execute();
            Entitlements entitlements = httpResponse.parseAs(Entitlements.class);
            return entitlements;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to request entitlements.", e);
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.REQUEST, "Failed to request entitlements.", (Throwable)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean checkMinecraftOwnership(Entitlements entitlements) {
        return entitlements.items.stream().anyMatch(i -> i.name.equalsIgnoreCase("game_minecraft")) && entitlements.items.stream().anyMatch(i -> i.name.equalsIgnoreCase("product_minecraft"));
    }

    private MinecraftProfile getMinecraftProfile(XboxMinecraftResponse xboxMinecraftResponse) throws MicrosoftAuthException {
        HttpRequest request = this.buildGetRequest(MINECRAFT_PROFILE_URL);
        String authorization = xboxMinecraftResponse.getAuthorization();
        request.setHeaders(request.getHeaders().setAuthorization(authorization));
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse httpResponse = null;
        try {
            httpResponse = request.execute();
            httpResponse.setLoggingEnabled(true);
            switch (httpResponse.getStatusCode()) {
                case 404: {
                    MinecraftError minecraftError = httpResponse.parseAs(MinecraftError.class);
                    throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.NO_PROFILE, "Minecraft Account Error: " + minecraftError.error);
                }
                case 200: {
                    MinecraftProfile minecraftProfile = httpResponse.parseAs(MinecraftProfile.class);
                    return minecraftProfile;
                }
            }
            try {
                throw new HttpResponseException(httpResponse);
            }
            catch (IOException e) {
                Utils.getLogger().log(Level.SEVERE, "Failed to load minecraft profile.", e);
                throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.MINECRAFT_PROFILE, "Failed to load minecraft profile.", (Throwable)e);
            }
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AuthorizationCodeFlow buildFlow() throws IOException {
        return new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), HTTP_TRANSPORT, JSON_FACTORY, new GenericUrl(TOKEN_SERVER_URL), new ClientParametersAuthentication(TECHNIC_CLIENT_ID, null), TECHNIC_CLIENT_ID, AUTHORIZATION_SERVER_URL).setScopes(Arrays.asList(SCOPES)).setDataStoreFactory(this.dataStoreFactory).build();
    }

    private void updateCredentialStore(String id, Credential credential) {
        try {
            this.dataStoreFactory.getDataStore(StoredCredential.DEFAULT_DATA_STORE_ID).clear();
            this.dataStoreFactory.getDataStore(StoredCredential.DEFAULT_DATA_STORE_ID).set(id, new StoredCredential(credential));
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, "Failed to save user credential to the data store.", e);
        }
    }

    private void ensureHostIsNotLocalhost(GenericUrl url) throws MicrosoftAuthException {
        try {
            if (InetAddress.getByName(url.getHost()).getHostAddress().equals("127.0.0.1")) {
                DesktopUtils.browseUrl("https://support.technicpack.net/hc/en-us/articles/18587630118541");
                throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.DNS, url.getHost() + " resolves to 127.0.0.1\n\nYour hosts file needs to be fixed.");
            }
        }
        catch (UnknownHostException e) {
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.DNS, "DNS resolution failed for " + url.getHost() + ": unknown host");
        }
    }

    private HttpRequest buildGetRequest(String url) throws MicrosoftAuthException {
        GenericUrl genericUrl = new GenericUrl(url);
        this.ensureHostIsNotLocalhost(genericUrl);
        try {
            return this.REQUEST_FACTORY.buildGetRequest(genericUrl);
        }
        catch (IOException e) {
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.REQUEST, "Failed to build get request.", (Throwable)e);
        }
    }

    private HttpRequest buildPostRequest(String url, HttpContent httpContent) throws MicrosoftAuthException {
        GenericUrl genericUrl = new GenericUrl(url);
        this.ensureHostIsNotLocalhost(genericUrl);
        try {
            return this.REQUEST_FACTORY.buildPostRequest(genericUrl, httpContent);
        }
        catch (IOException e) {
            throw new MicrosoftAuthException(MicrosoftAuthException.ExceptionType.REQUEST, "Failed to build post request.", (Throwable)e);
        }
    }
}

