/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.launch;

import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import net.technicpack.autoupdate.IBuildNumber;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.auth.UserModel;
import net.technicpack.launchercore.exception.InstallException;
import net.technicpack.launchercore.launch.GameProcess;
import net.technicpack.launchercore.launch.ProcessExitListener;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.RunData;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.launch.LaunchCommandCollector;
import net.technicpack.minecraftcore.launch.LaunchOptions;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.ProcessUtils;
import net.technicpack.utilslib.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class MinecraftLauncher {
    private final LauncherFileSystem fileSystem;
    private final IPlatformApi platformApi;
    private final UserModel userModel;
    private final JavaVersionRepository javaVersions;
    private final IBuildNumber buildNumber;

    public MinecraftLauncher(IPlatformApi platformApi, LauncherFileSystem fileSystem, UserModel userModel, JavaVersionRepository javaVersions, IBuildNumber buildNumber) {
        this.fileSystem = fileSystem;
        this.platformApi = platformApi;
        this.userModel = userModel;
        this.javaVersions = javaVersions;
        this.buildNumber = buildNumber;
    }

    public JavaVersionRepository getJavaVersions() {
        return this.javaVersions;
    }

    public GameProcess launch(ModpackModel pack, long memory, LaunchOptions options, ProcessExitListener exitListener, IMinecraftVersionInfo version) throws IOException, InstallException {
        List<String> commands = this.buildCommands(pack, memory, version, options);
        String userAccessToken = this.userModel.getCurrentUser().getAccessToken();
        String commandStr = String.join((CharSequence)" ", commands);
        if (!userAccessToken.equals("0")) {
            commandStr = commandStr.replace(userAccessToken, "USER_ACCESS_TOKEN");
        }
        Utils.getLogger().info("Running " + commandStr);
        ProcessBuilder processBuilder = ProcessUtils.createProcessBuilder(commands).directory(pack.getInstalledDirectory()).redirectErrorStream(true);
        Process process = processBuilder.start();
        GameProcess mcProcess = new GameProcess(process, userAccessToken);
        if (exitListener != null) {
            mcProcess.setExitListener(exitListener);
        }
        this.platformApi.incrementPackRuns(pack.getName());
        if (!Utils.sendTracking("runModpack", pack.getName(), pack.getInstalledVersion().getVersion(), options.getOptions().getClientId())) {
            Utils.getLogger().info("Failed to record event");
        }
        return mcProcess;
    }

    private List<String> buildCommands(ModpackModel pack, long memory, IMinecraftVersionInfo version, LaunchOptions options) throws InstallException {
        ArgumentList jvmArgs;
        LaunchCommandCollector commands = new LaunchCommandCollector();
        String wrapperCommand = options.getOptions().getWrapperCommand();
        if (StringUtils.isNotEmpty(wrapperCommand)) {
            commands.addRaw(wrapperCommand);
        }
        IJavaRuntime javaRuntime = version.getJavaRuntime();
        commands.addRaw(javaRuntime.getExecutableFile().toString());
        OperatingSystem operatingSystem = OperatingSystem.getOperatingSystem();
        String nativesDir = new File(pack.getBinDir(), "natives").getAbsolutePath();
        ILaunchOptions launchOpts = options.getOptions();
        String cpString = this.buildClassPath(pack, version, launchOpts);
        Utils.getLogger().log(Level.FINE, String.format("Classpath:%n%n%s", cpString.replace(File.pathSeparatorChar, '\n')));
        StringSubstitutor paramDereferencer = this.createParamDereferencer(pack, version, nativesDir, cpString, launchOpts);
        String customJvmArgs = options.getOptions().getJavaArgs();
        if (StringUtils.isNotEmpty(customJvmArgs)) {
            customJvmArgs = customJvmArgs.replaceAll("[\\r\\n]", " ");
            for (String customJvmArg : customJvmArgs.split(" +")) {
                commands.addRaw(customJvmArg);
            }
        }
        String launchJavaVersion = javaRuntime.getVersion();
        if (!MojangUtils.hasModernMinecraftForge(version) && !MojangUtils.hasNeoForge(version) && (jvmArgs = version.getJavaArguments()) != null) {
            for (String arg : jvmArgs.resolve(options.getOptions(), javaRuntime, paramDereferencer)) {
                commands.add(arg);
            }
        }
        commands.addRaw("-Xms" + memory + "m");
        commands.addRaw("-Xmx" + memory + "m");
        if (!RunData.isJavaVersionAtLeast(launchJavaVersion, "1.8")) {
            int permSize = 128;
            if (memory >= 6144L) {
                permSize = 512;
            } else if (memory >= 2048L) {
                permSize = 256;
            }
            commands.add("-XX:MaxPermSize=" + permSize + "m");
        }
        commands.addUnique("-Djava.library.path=" + nativesDir);
        commands.addUnique("-Dfml.ignoreInvalidMinecraftCertificates=true");
        commands.addUnique("-Dfml.ignorePatchDiscrepancies=true");
        if (MojangUtils.requiresForgeWrapper(version)) {
            commands.addUnique("-Dforgewrapper.librariesDir=" + this.fileSystem.getCacheDirectory().toString());
            File modpackJar = new File(pack.getBinDir(), "modpack.jar");
            commands.addUnique("-Dforgewrapper.installer=" + modpackJar.getAbsolutePath());
            String mcVersion = MojangUtils.getMinecraftVersion(version);
            Path minecraftJar = this.fileSystem.getCacheDirectory().resolve(String.format("minecraft_%s.jar", mcVersion));
            commands.addUnique("-Dforgewrapper.minecraft=" + minecraftJar);
        }
        commands.addUnique("-Dminecraft.applet.TargetDirectory=" + pack.getInstalledDirectory().getAbsolutePath());
        commands.addUnique("-Duser.language=en");
        if (!options.getOptions().shouldUseStencilBuffer()) {
            commands.add("-Dforge.forceNoStencil=true");
        }
        if (operatingSystem.equals((Object)OperatingSystem.OSX)) {
            commands.add("-Xdock:icon=" + options.getIconPath());
            commands.add("-Xdock:name=" + pack.getDisplayName());
            boolean hasLwjgl3 = version.getLibrariesForCurrentOS(launchOpts, javaRuntime).stream().anyMatch(library -> library.getName().startsWith("org.lwjgl:lwjgl:"));
            if (hasLwjgl3) {
                commands.addUnique("-XstartOnFirstThread");
            }
        } else if (operatingSystem.equals((Object)OperatingSystem.WINDOWS)) {
            commands.addUnique("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
        }
        commands.addUnique("-cp", cpString);
        commands.addRaw(version.getMainClass());
        List<String> mcArgs = version.getMinecraftArguments().resolve(launchOpts, javaRuntime, paramDereferencer);
        ListIterator<String> mcArgsIterator = mcArgs.listIterator();
        while (mcArgsIterator.hasNext()) {
            String current = mcArgsIterator.next();
            String next = mcArgsIterator.hasNext() ? mcArgs.get(mcArgsIterator.nextIndex()) : null;
            if (current.startsWith("--")) {
                if (next != null && !next.startsWith("--")) {
                    if (current.equals("--tweakClass")) {
                        commands.add(current, next);
                    } else {
                        commands.addUnique(current, next);
                    }
                    mcArgsIterator.next();
                    continue;
                }
                commands.addUnique(current);
                continue;
            }
            commands.add(current);
        }
        options.appendToCommands(commands);
        return commands.collect();
    }

    private StringSubstitutor createParamDereferencer(ModpackModel pack, IMinecraftVersionInfo version, String nativesDir, String cpString, ILaunchOptions launchOpts) {
        HashMap<String, String> params = new HashMap<String, String>();
        IUserType user = this.userModel.getCurrentUser();
        File gameDirectory = pack.getInstalledDirectory();
        params.put("auth_username", user.getUsername());
        params.put("auth_session", user.getSessionId());
        params.put("auth_access_token", user.getAccessToken());
        params.put("auth_player_name", user.getDisplayName());
        params.put("auth_uuid", user.getId());
        params.put("profile_name", user.getDisplayName());
        params.put("version_name", version.getId());
        params.put("version_type", version.getType().getName());
        params.put("game_directory", gameDirectory.getAbsolutePath());
        params.put("natives_directory", nativesDir);
        params.put("classpath", cpString);
        params.put("resolution_width", Integer.toString(launchOpts.getCustomWidth()));
        params.put("resolution_height", Integer.toString(launchOpts.getCustomHeight()));
        String targetAssets = this.fileSystem.getAssetsDirectory().toString();
        String assetsKey = version.getAssetsKey();
        if (assetsKey == null || assetsKey.isEmpty()) {
            assetsKey = "legacy";
        }
        if (version.getAreAssetsVirtual()) {
            targetAssets = targetAssets + File.separator + "virtual" + File.separator + assetsKey;
        } else if (version.getAssetsMapToResources()) {
            targetAssets = pack.getResourcesDir().getAbsolutePath();
        }
        params.put("game_assets", targetAssets);
        params.put("assets_root", targetAssets);
        params.put("assets_index_name", assetsKey);
        params.put("user_type", user.getMCUserType());
        params.put("user_properties", user.getUserProperties());
        params.put("launcher_name", "technic");
        params.put("launcher_version", "4." + this.buildNumber.getBuildNumber());
        return new StringSubstitutor(params);
    }

    private String buildClassPath(ModpackModel pack, IMinecraftVersionInfo version, ILaunchOptions launchOptions) throws InstallException {
        Path minecraft;
        File modpack;
        StringBuilder sb = new StringBuilder(10000);
        char separator = File.pathSeparatorChar;
        IJavaRuntime runtime = version.getJavaRuntime();
        Sentry.addBreadcrumb(String.format("Runtime is %s", runtime));
        String bitness = runtime.getBitness();
        for (Library library : version.getLibrariesForCurrentOS(launchOptions, runtime)) {
            if (library.getNatives() != null) continue;
            Path file = this.fileSystem.getCacheDirectory().resolve(library.getArtifactPath().replace("${arch}", bitness));
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new InstallException("Library " + library.getName() + " not found.");
            }
            sb.append(file).append(separator);
        }
        boolean hasModernMinecraftForge = MojangUtils.hasModernMinecraftForge(version);
        boolean hasNeoForge = MojangUtils.hasNeoForge(version);
        if (!hasModernMinecraftForge && !hasNeoForge && (modpack = new File(pack.getBinDir(), "modpack.jar")).exists()) {
            sb.append(modpack.getAbsolutePath()).append(separator);
        }
        if (!Files.isRegularFile(minecraft = hasModernMinecraftForge || hasNeoForge ? this.fileSystem.getCacheDirectory().resolve(String.format("minecraft_%s.jar", version.getParentVersion())) : pack.getBinDir().toPath().resolve("minecraft.jar"), new LinkOption[0])) {
            throw new RuntimeException(String.format("Minecraft not installed for this pack: %s", pack.getName()));
        }
        sb.append(minecraft);
        return sb.toString();
    }
}

