/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LaunchCommandCollector {
    private final List<String> commands = new ArrayList<String>();
    private final Set<String> seen = new HashSet<String>();

    public void addRaw(String command) {
        this.commands.add(command);
    }

    public void add(String command) {
        int eqIndex = command.indexOf("=");
        if (eqIndex != -1) {
            String commandPart = command.substring(0, eqIndex);
            this.markExists(commandPart);
        } else {
            this.markExists(command);
        }
        this.commands.add(command);
    }

    public void add(String command, String param) {
        this.markExists(command);
        this.commands.add(command);
        this.commands.add(param);
    }

    public void addUnique(String command) {
        int eqIndex = command.indexOf("=");
        if (eqIndex != -1) {
            String commandPart = command.substring(0, eqIndex);
            if (this.exists(commandPart)) {
                return;
            }
            this.markExists(commandPart);
        } else {
            if (this.exists(command)) {
                return;
            }
            this.markExists(command);
        }
        this.commands.add(command);
    }

    public void addUnique(String command, String param) {
        if (!this.exists(command)) {
            this.add(command, param);
        }
    }

    public boolean exists(String command) {
        return this.seen.contains(command.toLowerCase().trim());
    }

    private void markExists(String command) {
        this.seen.add(command.toLowerCase().trim());
    }

    public List<String> collect() {
        return Collections.unmodifiableList(this.commands);
    }
}

