/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import org.apache.commons.io.FileUtils;

public class RenameJnilibToDylibTask
implements IInstallTask<IMinecraftVersionInfo> {
    private ModpackModel modpack;

    public RenameJnilibToDylibTask(ModpackModel modpack) {
        this.modpack = modpack;
    }

    @Override
    public String getTaskDescription() {
        return "Fixing OSX natives";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException {
        File nativesDir = new File(this.modpack.getBinDir(), "natives");
        if (!nativesDir.exists()) {
            return;
        }
        Iterator<File> filesIterator = FileUtils.iterateFiles(nativesDir, new String[]{"jnilib"}, true);
        while (filesIterator.hasNext()) {
            File file = filesIterator.next();
            if (!file.getName().endsWith(".jnilib")) continue;
            String filename = file.getName();
            String newFilename = filename.substring(0, filename.length() - ".jnilib".length()) + ".dylib";
            File newFile = new File(file.getParentFile(), newFilename);
            if (file.renameTo(newFile)) continue;
            throw new IOException("Failed to rename " + file.getAbsolutePath() + " to " + newFile.getAbsolutePath());
        }
    }
}

