/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.ListenerTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.install.verifiers.MD5FileVerifier;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.install.verifiers.ValidZipFileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.ExtractRulesFileFilter;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;

public class InstallVersionLibTask
extends ListenerTask<IMinecraftVersionInfo> {
    private Library library;
    private ITasksQueue<IMinecraftVersionInfo> grabQueue;
    private ITasksQueue<IMinecraftVersionInfo> downloadLibraryQueue;
    private ITasksQueue<IMinecraftVersionInfo> copyLibraryQueue;
    private ModpackModel pack;
    private LauncherFileSystem fileSystem;

    public InstallVersionLibTask(Library library, ITasksQueue<IMinecraftVersionInfo> grabQueue, ITasksQueue<IMinecraftVersionInfo> downloadLibraryQueue, ITasksQueue<IMinecraftVersionInfo> copyLibraryQueue, ModpackModel pack, LauncherFileSystem fileSystem) {
        this.library = library;
        this.downloadLibraryQueue = downloadLibraryQueue;
        this.copyLibraryQueue = copyLibraryQueue;
        this.grabQueue = grabQueue;
        this.pack = pack;
        this.fileSystem = fileSystem;
    }

    @Override
    public String getTaskDescription() {
        return this.library.getName();
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException, InterruptedException {
        String sha1;
        super.runTask(queue);
        queue.refreshProgress();
        String nativeClassifier = null;
        File extractDirectory = null;
        if (this.library.getNatives() != null && (nativeClassifier = this.library.getNatives().get((Object)OperatingSystem.getOperatingSystem())) != null) {
            extractDirectory = new File(this.pack.getBinDir(), "natives");
        }
        IMinecraftVersionInfo version = queue.getMetadata();
        String bitness = version.getJavaRuntime().getBitness();
        String path = this.library.getArtifactPath(nativeClassifier).replace("${arch}", bitness);
        Path cache = this.fileSystem.getCacheDirectory().resolve(path);
        if (cache.getParent() != null) {
            Files.createDirectories(cache.getParent(), new FileAttribute[0]);
        }
        IFileVerifier verifier = (sha1 = this.library.getArtifactSha1(nativeClassifier)) != null && !sha1.isEmpty() ? new SHA1FileVerifier(sha1) : new ValidZipFileVerifier();
        if (Files.isRegularFile(cache, new LinkOption[0]) && verifier.isFileValid(cache) && extractDirectory == null) {
            return;
        }
        String url = null;
        if (!Files.isRegularFile(cache, new LinkOption[0]) || !verifier.isFileValid(cache)) {
            String md5;
            url = this.library.getDownloadUrl(path).replace("${arch}", bitness);
            if ((sha1 == null || sha1.isEmpty()) && (md5 = Utils.getETag(url)) != null && !md5.isEmpty()) {
                verifier = new MD5FileVerifier(md5);
            }
        }
        ExtractRulesFileFilter filter = null;
        if (this.library.getExtract() != null) {
            filter = new ExtractRulesFileFilter(this.library.getExtract());
        }
        EnsureFileTask<IMinecraftVersionInfo> ensureFileTask = new EnsureFileTask<IMinecraftVersionInfo>(this.downloadLibraryQueue, cache).withUrl(url).withVerifier(verifier).withZipFilter(filter);
        if (extractDirectory != null) {
            ensureFileTask.withExtractTo(extractDirectory, this.copyLibraryQueue);
        }
        this.grabQueue.addTask(ensureFileTask);
    }
}

